/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.api.index.PropertyPhysicalToLogicalConverter;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyRecordChange;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class PropertyPhysicalToLogicalConverterTest {
    @ClassRule
    public static PageCacheRule pageCacheRule = new PageCacheRule();
    private final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final TestDirectory testDirectory = TestDirectory.testDirectory((FileSystemAbstraction)this.fs);
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fs).around((TestRule)this.testDirectory);
    private NeoStores neoStores;
    private PropertyStore store;
    private final Value longString = Values.of((Object)"my super looooooooooooooooooooooooooooooooooooooong striiiiiiiiiiiiiiiiiiiiiiing");
    private final Value longerString = Values.of((Object)"my super looooooooooooooooooooooooooooooooooooooong striiiiiiiiiiiiiiiiiiiiiiingdd");
    private PropertyPhysicalToLogicalConverter converter;
    private final long[] none = new long[0];

    @Before
    public void before() {
        StoreFactory storeFactory = new StoreFactory(this.testDirectory.databaseLayout(), Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs.get()), pageCacheRule.getPageCache(this.fs.get()), this.fs.get(), (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY);
        this.neoStores = storeFactory.openAllNeoStores(true);
        this.store = this.neoStores.getPropertyStore();
        this.converter = new PropertyPhysicalToLogicalConverter(this.store);
    }

    @After
    public void after() {
        this.neoStores.close();
    }

    @Test
    public void shouldConvertInlinedAddedProperty() {
        int key = 10;
        Value value = Values.of((Object)12345);
        PropertyRecord before = PropertyPhysicalToLogicalConverterTest.propertyRecord(new PropertyBlock[0]);
        PropertyRecord after = PropertyPhysicalToLogicalConverterTest.propertyRecord(this.property(key, value));
        MatcherAssert.assertThat((Object)this.convert(this.none, this.none, this.change(before, after)), (Matcher)Matchers.equalTo((Object)EntityUpdates.forEntity((long)0L).added(key, value).build()));
    }

    @Test
    public void shouldConvertInlinedChangedProperty() {
        int key = 10;
        Value valueBefore = Values.of((Object)12341);
        Value valueAfter = Values.of((Object)738);
        PropertyRecord before = PropertyPhysicalToLogicalConverterTest.propertyRecord(this.property(key, valueBefore));
        PropertyRecord after = PropertyPhysicalToLogicalConverterTest.propertyRecord(this.property(key, valueAfter));
        EntityUpdates update = this.convert(this.none, this.none, this.change(before, after));
        EntityUpdates expected = EntityUpdates.forEntity((long)0L).changed(key, valueBefore, valueAfter).build();
        Assert.assertEquals((Object)expected, (Object)update);
    }

    @Test
    public void shouldIgnoreInlinedUnchangedProperty() {
        int key = 10;
        Value value = Values.of((Object)12341);
        PropertyRecord before = PropertyPhysicalToLogicalConverterTest.propertyRecord(this.property(key, value));
        PropertyRecord after = PropertyPhysicalToLogicalConverterTest.propertyRecord(this.property(key, value));
        MatcherAssert.assertThat((Object)this.convert(this.none, this.none, this.change(before, after)), (Matcher)Matchers.equalTo((Object)EntityUpdates.forEntity((long)0L).build()));
    }

    @Test
    public void shouldConvertInlinedRemovedProperty() {
        int key = 10;
        Value value = Values.of((Object)12341);
        PropertyRecord before = PropertyPhysicalToLogicalConverterTest.propertyRecord(this.property(key, value));
        PropertyRecord after = PropertyPhysicalToLogicalConverterTest.propertyRecord(new PropertyBlock[0]);
        EntityUpdates update = this.convert(this.none, this.none, this.change(before, after));
        EntityUpdates expected = EntityUpdates.forEntity((long)0L).removed(key, value).build();
        Assert.assertEquals((Object)expected, (Object)update);
    }

    @Test
    public void shouldConvertDynamicAddedProperty() {
        int key = 10;
        PropertyRecord before = PropertyPhysicalToLogicalConverterTest.propertyRecord(new PropertyBlock[0]);
        PropertyRecord after = PropertyPhysicalToLogicalConverterTest.propertyRecord(this.property(key, this.longString));
        MatcherAssert.assertThat((Object)this.convert(this.none, this.none, this.change(before, after)), (Matcher)Matchers.equalTo((Object)EntityUpdates.forEntity((long)0L).added(key, this.longString).build()));
    }

    @Test
    public void shouldConvertDynamicChangedProperty() {
        int key = 10;
        PropertyRecord before = PropertyPhysicalToLogicalConverterTest.propertyRecord(this.property(key, this.longString));
        PropertyRecord after = PropertyPhysicalToLogicalConverterTest.propertyRecord(this.property(key, this.longerString));
        EntityUpdates update = this.convert(this.none, this.none, this.change(before, after));
        EntityUpdates expected = EntityUpdates.forEntity((long)0L).changed(key, this.longString, this.longerString).build();
        Assert.assertEquals((Object)expected, (Object)update);
    }

    @Test
    public void shouldConvertDynamicInlinedRemovedProperty() {
        int key = 10;
        PropertyRecord before = PropertyPhysicalToLogicalConverterTest.propertyRecord(this.property(key, this.longString));
        PropertyRecord after = PropertyPhysicalToLogicalConverterTest.propertyRecord(new PropertyBlock[0]);
        EntityUpdates update = this.convert(this.none, this.none, this.change(before, after));
        EntityUpdates expected = EntityUpdates.forEntity((long)0L).removed(key, this.longString).build();
        Assert.assertEquals((Object)expected, (Object)update);
    }

    @Test
    public void shouldTreatPropertyThatMovedToAnotherRecordAsChange() {
        int key = 12;
        Value oldValue = Values.of((Object)"value1");
        Value newValue = Values.of((Object)"value two");
        PropertyRecordChange movedFrom = this.change(PropertyPhysicalToLogicalConverterTest.propertyRecord(this.property(key, oldValue)), PropertyPhysicalToLogicalConverterTest.propertyRecord(new PropertyBlock[0]));
        PropertyRecordChange movedTo = this.change(PropertyPhysicalToLogicalConverterTest.propertyRecord(new PropertyBlock[0]), PropertyPhysicalToLogicalConverterTest.propertyRecord(this.property(key, newValue)));
        EntityUpdates update = this.convert(this.none, this.none, movedFrom, movedTo);
        EntityUpdates expected = EntityUpdates.forEntity((long)0L).changed(key, oldValue, newValue).build();
        Assert.assertEquals((Object)expected, (Object)update);
    }

    private static PropertyRecord propertyRecord(PropertyBlock ... propertyBlocks) {
        PropertyRecord record = new PropertyRecord(0L);
        if (propertyBlocks != null) {
            record.setInUse(true);
            for (PropertyBlock propertyBlock : propertyBlocks) {
                record.addPropertyBlock(propertyBlock);
            }
        }
        record.setNodeId(0L);
        return record;
    }

    private PropertyBlock property(long key, Value value) {
        PropertyBlock block = new PropertyBlock();
        this.store.encodeValue(block, (int)key, value);
        return block;
    }

    private EntityUpdates convert(long[] labelsBefore, long[] labelsAfter, PropertyRecordChange change) {
        return this.convert(labelsBefore, labelsAfter, new PropertyRecordChange[]{change});
    }

    private EntityUpdates convert(long[] labelsBefore, long[] labelsAfter, PropertyRecordChange ... changes) {
        EntityUpdates.Builder updates = EntityUpdates.forEntity((long)0L).withTokens(labelsBefore).withTokensAfter(labelsAfter);
        this.converter.convertPropertyRecord(0L, Iterables.iterable((Object[])changes), updates);
        return updates.build();
    }

    private PropertyRecordChange change(final PropertyRecord before, final PropertyRecord after) {
        return new PropertyRecordChange(){

            public PropertyRecord getBefore() {
                return before;
            }

            public PropertyRecord getAfter() {
                return after;
            }
        };
    }
}

