/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.io.pagecache.ByteArrayPageCursor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GeometryType;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.string.UTF8;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.AnyValues;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
class GenericKeyStateTest {
    private final IndexSpecificSpaceFillingCurveSettingsCache noSpecificIndexSettings = new IndexSpecificSpaceFillingCurveSettingsCache(new ConfiguredSpaceFillingCurveSettingsCache(Config.defaults()), new HashMap());
    @Inject
    private static RandomRule random;

    GenericKeyStateTest() {
    }

    @BeforeEach
    void setupRandomConfig() {
        random = random.withConfiguration(new RandomValues.Configuration(){

            public int stringMinLength() {
                return 0;
            }

            public int stringMaxLength() {
                return 50;
            }

            public int arrayMinLength() {
                return 0;
            }

            public int arrayMaxLength() {
                return 10;
            }

            public int maxCodePoint() {
                return 65535;
            }
        });
        random.reset();
    }

    @ParameterizedTest
    @MethodSource(value={"validValueGenerators"})
    void readWhatIsWritten(ValueGenerator valueGenerator) {
        PageCursor cursor = this.newPageCursor();
        GenericKey writeState = this.newKeyState();
        Value value = valueGenerator.next();
        int offset = cursor.getOffset();
        writeState.writeValue(value, NativeIndexKey.Inclusion.NEUTRAL);
        writeState.put(cursor);
        GenericKey readState = this.newKeyState();
        int size = writeState.size();
        cursor.setOffset(offset);
        Assertions.assertTrue((boolean)readState.get(cursor, size), (String)"failed to read");
        Assertions.assertEquals((int)0, (int)readState.compareValueTo(writeState), (String)"key states are not equal");
        Value readValue = readState.asValue();
        Assertions.assertEquals((Object)value, (Object)readValue, (String)"deserialized values are not equal");
    }

    @ParameterizedTest
    @MethodSource(value={"validValueGenerators"})
    void copyShouldCopy(ValueGenerator valueGenerator) {
        GenericKey from = this.newKeyState();
        Value value = valueGenerator.next();
        from.writeValue(value, NativeIndexKey.Inclusion.NEUTRAL);
        GenericKey to = this.genericKeyStateWithSomePreviousState(valueGenerator);
        to.copyFrom(from);
        Assertions.assertEquals((int)0, (int)from.compareValueTo(to), (String)"states not equals after copy");
    }

    @Test
    void copyShouldCopyExtremeValues() {
        GenericKey extreme = this.newKeyState();
        GenericKey copy = this.newKeyState();
        for (ValueGroup valueGroup : ValueGroup.values()) {
            if (valueGroup == ValueGroup.NO_VALUE) continue;
            extreme.initValueAsLowest(valueGroup);
            copy.copyFrom(extreme);
            Assertions.assertEquals((int)0, (int)extreme.compareValueTo(copy), (String)("states not equals after copy, valueGroup=" + valueGroup));
            extreme.initValueAsHighest(valueGroup);
            copy.copyFrom(extreme);
            Assertions.assertEquals((int)0, (int)extreme.compareValueTo(copy), (String)("states not equals after copy, valueGroup=" + valueGroup));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"validComparableValueGenerators"})
    void compareToMustAlignWithValuesCompareTo(ValueGenerator valueGenerator) {
        int i;
        ArrayList<Value> values = new ArrayList<Value>();
        ArrayList<GenericKey> states = new ArrayList<GenericKey>();
        for (i = 0; i < 10; ++i) {
            Value value = valueGenerator.next();
            values.add(value);
            GenericKey state = this.newKeyState();
            state.writeValue(value, NativeIndexKey.Inclusion.NEUTRAL);
            states.add(state);
        }
        values.sort((Comparator<Value>)Values.COMPARATOR);
        states.sort(GenericKey::compareValueTo);
        for (i = 0; i < values.size(); ++i) {
            Assertions.assertEquals(values.get(i), (Object)((GenericKey)states.get(i)).asValue(), (String)"sort order was different");
        }
    }

    @Test
    void comparePointsMustOnlyReturnZeroForEqualPoints() {
        PointValue firstPoint = random.randomValues().nextPointValue();
        PointValue equalPoint = Values.point((Point)firstPoint);
        CoordinateReferenceSystem crs = firstPoint.getCoordinateReferenceSystem();
        SpaceFillingCurve curve = this.noSpecificIndexSettings.forCrs(crs, false);
        Long spaceFillingCurveValue = curve.derivedValueFor(firstPoint.coordinate());
        PointValue centerPoint = Values.pointValue((CoordinateReferenceSystem)crs, (double[])curve.centerPointFor(spaceFillingCurveValue.longValue()));
        GenericKey firstKey = this.newKeyState();
        firstKey.writeValue((Value)firstPoint, NativeIndexKey.Inclusion.NEUTRAL);
        GenericKey equalKey = this.newKeyState();
        equalKey.writeValue((Value)equalPoint, NativeIndexKey.Inclusion.NEUTRAL);
        GenericKey centerKey = this.newKeyState();
        centerKey.writeValue((Value)centerPoint, NativeIndexKey.Inclusion.NEUTRAL);
        GenericKey noCoordsKey = this.newKeyState();
        noCoordsKey.writeValue((Value)equalPoint, NativeIndexKey.Inclusion.NEUTRAL);
        GeometryType.setNoCoordinates((GenericKey)noCoordsKey);
        Assertions.assertEquals((int)0, (int)firstKey.compareValueTo(equalKey), (String)"expected keys to be equal");
        Assertions.assertEquals((Object)(firstPoint.compareTo(centerPoint) != 0 ? 1 : 0), (Object)(firstKey.compareValueTo(centerKey) != 0 ? 1 : 0), (String)"expected keys to be equal if and only if source points are equal");
        Assertions.assertEquals((int)0, (int)firstKey.compareValueTo(noCoordsKey), (String)"expected keys to be equal");
    }

    @Test
    void comparePointArraysMustOnlyReturnZeroForEqualArrays() {
        PointArray firstArray = random.randomValues().nextPointArray();
        PointValue[] sourcePointValues = (PointValue[])firstArray.asObjectCopy();
        PointArray equalArray = Values.pointArray((PointValue[])sourcePointValues);
        PointValue[] centerPointValues = new PointValue[sourcePointValues.length];
        for (int i = 0; i < sourcePointValues.length; ++i) {
            PointValue sourcePointValue = sourcePointValues[i];
            CoordinateReferenceSystem crs = sourcePointValue.getCoordinateReferenceSystem();
            SpaceFillingCurve curve = this.noSpecificIndexSettings.forCrs(crs, false);
            Long spaceFillingCurveValue = curve.derivedValueFor(sourcePointValue.coordinate());
            centerPointValues[i] = Values.pointValue((CoordinateReferenceSystem)crs, (double[])curve.centerPointFor(spaceFillingCurveValue.longValue()));
        }
        PointArray centerArray = Values.pointArray((PointValue[])centerPointValues);
        GenericKey firstKey = this.newKeyState();
        firstKey.writeValue((Value)firstArray, NativeIndexKey.Inclusion.NEUTRAL);
        GenericKey equalKey = this.newKeyState();
        equalKey.writeValue((Value)equalArray, NativeIndexKey.Inclusion.NEUTRAL);
        GenericKey centerKey = this.newKeyState();
        centerKey.writeValue((Value)centerArray, NativeIndexKey.Inclusion.NEUTRAL);
        GenericKey noCoordsKey = this.newKeyState();
        noCoordsKey.writeValue((Value)equalArray, NativeIndexKey.Inclusion.NEUTRAL);
        GeometryType.setNoCoordinates((GenericKey)noCoordsKey);
        Assertions.assertEquals((int)0, (int)firstKey.compareValueTo(equalKey), (String)"expected keys to be equal");
        Assertions.assertEquals((Object)(firstArray.compareToSequence((SequenceValue)centerArray, AnyValues.COMPARATOR) != 0 ? 1 : 0), (Object)(firstKey.compareValueTo(centerKey) != 0 ? 1 : 0), (String)"expected keys to be equal if and only if source points are equal");
        Assertions.assertEquals((int)0, (int)firstKey.compareValueTo(noCoordsKey), (String)"expected keys to be equal");
    }

    @ParameterizedTest
    @MethodSource(value={"validComparableValueGenerators"})
    void mustProduceValidMinimalSplitters(ValueGenerator valueGenerator) {
        Value value2;
        Value value1 = valueGenerator.next();
        while (Values.COMPARATOR.compare(value1, value2 = valueGenerator.next()) == 0) {
        }
        Value left = this.pickSmaller(value1, value2);
        Value right = left == value1 ? value2 : value1;
        this.assertValidMinimalSplitter(left, right);
    }

    @ParameterizedTest
    @MethodSource(value={"validValueGenerators"})
    void mustProduceValidMinimalSplittersWhenValuesAreEqual(ValueGenerator valueGenerator) {
        this.assertValidMinimalSplitterForEqualValues(valueGenerator.next());
    }

    @ParameterizedTest
    @MethodSource(value={"validValueGenerators"})
    void mustReportCorrectSize(ValueGenerator valueGenerator) {
        PageCursor cursor = this.newPageCursor();
        Value value = valueGenerator.next();
        GenericKey state = this.newKeyState();
        state.writeValue(value, NativeIndexKey.Inclusion.NEUTRAL);
        int offsetBefore = cursor.getOffset();
        int reportedSize = state.size();
        state.put(cursor);
        int offsetAfter = cursor.getOffset();
        int actualSize = offsetAfter - offsetBefore;
        Assertions.assertEquals((int)reportedSize, (int)actualSize, (String)String.format("did not report correct size, value=%s, actualSize=%d, reportedSize=%d", value, actualSize, reportedSize));
    }

    @Test
    void lowestMustBeLowest() {
        this.assertLowest((Value)PointValue.MIN_VALUE);
        this.assertLowest((Value)DateTimeValue.MIN_VALUE);
        this.assertLowest((Value)LocalDateTimeValue.MIN_VALUE);
        this.assertLowest((Value)DateValue.MIN_VALUE);
        this.assertLowest((Value)TimeValue.MIN_VALUE);
        this.assertLowest((Value)LocalTimeValue.MIN_VALUE);
        this.assertLowest((Value)DurationValue.duration((Duration)Duration.ofSeconds(Long.MIN_VALUE, 0L)));
        this.assertLowest((Value)DurationValue.duration((Period)Period.of(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE)));
        this.assertLowest(Values.of((Object)UTF8.decode((byte[])new byte[0])));
        this.assertLowest(Values.of((Object)false));
        this.assertLowest(Values.of((Object)-128));
        this.assertLowest(Values.of((Object)Short.MIN_VALUE));
        this.assertLowest(Values.of((Object)Integer.MIN_VALUE));
        this.assertLowest(Values.of((Object)Long.MIN_VALUE));
        this.assertLowest(Values.of((Object)Float.valueOf(Float.NEGATIVE_INFINITY)));
        this.assertLowest(Values.of((Object)Double.NEGATIVE_INFINITY));
        this.assertLowest((Value)Values.pointArray((PointValue[])new PointValue[0]));
        this.assertLowest((Value)Values.dateTimeArray((ZonedDateTime[])new ZonedDateTime[0]));
        this.assertLowest((Value)Values.localDateTimeArray((LocalDateTime[])new LocalDateTime[0]));
        this.assertLowest((Value)Values.dateArray((LocalDate[])new LocalDate[0]));
        this.assertLowest((Value)Values.timeArray((OffsetTime[])new OffsetTime[0]));
        this.assertLowest((Value)Values.localTimeArray((LocalTime[])new LocalTime[0]));
        this.assertLowest((Value)Values.durationArray((DurationValue[])new DurationValue[0]));
        this.assertLowest((Value)Values.durationArray((TemporalAmount[])new TemporalAmount[0]));
        this.assertLowest(Values.of((Object)new String[0]));
        this.assertLowest(Values.of((Object)new boolean[0]));
        this.assertLowest(Values.of((Object)new byte[0]));
        this.assertLowest(Values.of((Object)new short[0]));
        this.assertLowest(Values.of((Object)new int[0]));
        this.assertLowest(Values.of((Object)new long[0]));
        this.assertLowest(Values.of((Object)new float[0]));
        this.assertLowest(Values.of((Object)new double[0]));
    }

    @Test
    void highestMustBeHighest() {
        this.assertHighest((Value)PointValue.MAX_VALUE);
        this.assertHighest((Value)DateTimeValue.MAX_VALUE);
        this.assertHighest((Value)LocalDateTimeValue.MAX_VALUE);
        this.assertHighest((Value)DateValue.MAX_VALUE);
        this.assertHighest((Value)TimeValue.MAX_VALUE);
        this.assertHighest((Value)LocalTimeValue.MAX_VALUE);
        this.assertHighest((Value)DurationValue.duration((Duration)Duration.ofSeconds(Long.MAX_VALUE, 999999999L)));
        this.assertHighest((Value)DurationValue.duration((Period)Period.of(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE)));
        this.assertHighestString();
        this.assertHighest(Values.of((Object)true));
        this.assertHighest(Values.of((Object)127));
        this.assertHighest(Values.of((Object)Short.MAX_VALUE));
        this.assertHighest(Values.of((Object)Integer.MAX_VALUE));
        this.assertHighest(Values.of((Object)Long.MAX_VALUE));
        this.assertHighest(Values.of((Object)Float.valueOf(Float.POSITIVE_INFINITY)));
        this.assertHighest(Values.of((Object)Double.POSITIVE_INFINITY));
        this.assertHighest((Value)Values.pointArray((PointValue[])new PointValue[]{PointValue.MAX_VALUE}));
        this.assertHighest((Value)Values.dateTimeArray((ZonedDateTime[])new ZonedDateTime[]{(ZonedDateTime)DateTimeValue.MAX_VALUE.asObjectCopy()}));
        this.assertHighest((Value)Values.localDateTimeArray((LocalDateTime[])new LocalDateTime[]{(LocalDateTime)LocalDateTimeValue.MAX_VALUE.asObjectCopy()}));
        this.assertHighest((Value)Values.dateArray((LocalDate[])new LocalDate[]{(LocalDate)DateValue.MAX_VALUE.asObjectCopy()}));
        this.assertHighest((Value)Values.timeArray((OffsetTime[])new OffsetTime[]{(OffsetTime)TimeValue.MAX_VALUE.asObjectCopy()}));
        this.assertHighest((Value)Values.localTimeArray((LocalTime[])new LocalTime[]{(LocalTime)LocalTimeValue.MAX_VALUE.asObjectCopy()}));
        this.assertHighest((Value)Values.durationArray((DurationValue[])new DurationValue[]{DurationValue.duration((Duration)Duration.ofSeconds(Long.MAX_VALUE, 999999999L))}));
        this.assertHighest((Value)Values.durationArray((DurationValue[])new DurationValue[]{DurationValue.duration((Period)Period.of(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE))}));
        this.assertHighest((Value)Values.durationArray((TemporalAmount[])new TemporalAmount[]{Duration.ofSeconds(Long.MAX_VALUE, 999999999L)}));
        this.assertHighest((Value)Values.durationArray((TemporalAmount[])new TemporalAmount[]{Period.of(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE)}));
        this.assertHighestStringArray();
        this.assertHighest((Value)Values.booleanArray((boolean[])new boolean[]{true}));
        this.assertHighest((Value)Values.byteArray((byte[])new byte[]{127}));
        this.assertHighest((Value)Values.shortArray((short[])new short[]{Short.MAX_VALUE}));
        this.assertHighest((Value)Values.intArray((int[])new int[]{Integer.MAX_VALUE}));
        this.assertHighest((Value)Values.longArray((long[])new long[]{Long.MAX_VALUE}));
        this.assertHighest((Value)Values.floatArray((float[])new float[]{Float.POSITIVE_INFINITY}));
        this.assertHighest((Value)Values.doubleArray((double[])new double[]{Double.POSITIVE_INFINITY}));
    }

    @Test
    void shouldNeverOverwriteDereferencedTextValues() {
        TextValue srcValue = Values.utf8Value((byte[])"First string".getBytes(StandardCharsets.UTF_8));
        GenericKey genericKeyState = this.newKeyState();
        genericKeyState.writeValue((Value)srcValue, NativeIndexKey.Inclusion.NEUTRAL);
        Value dereferencedValue = genericKeyState.asValue();
        Assertions.assertEquals((Object)srcValue, (Object)dereferencedValue);
        PageCursor cursor = this.newPageCursor();
        int offset = cursor.getOffset();
        genericKeyState.put(cursor);
        int keySize = cursor.getOffset() - offset;
        cursor.setOffset(offset);
        genericKeyState.clear();
        TextValue srcValue2 = Values.utf8Value((byte[])"Secondstring".getBytes(StandardCharsets.UTF_8));
        genericKeyState.writeValue((Value)srcValue2, NativeIndexKey.Inclusion.NEUTRAL);
        Value dereferencedValue2 = genericKeyState.asValue();
        Assertions.assertEquals((Object)srcValue2, (Object)dereferencedValue2);
        Assertions.assertEquals((Object)srcValue, (Object)dereferencedValue);
        genericKeyState.clear();
        genericKeyState.get(cursor, keySize);
        Value dereferencedValue3 = genericKeyState.asValue();
        Assertions.assertEquals((Object)srcValue, (Object)dereferencedValue3);
        Assertions.assertEquals((Object)srcValue2, (Object)dereferencedValue2);
        Assertions.assertEquals((Object)srcValue, (Object)dereferencedValue);
    }

    @Test
    void indexedCharShouldComeBackAsCharValue() {
        this.shouldReadBackToExactOriginalValue((Value)random.randomValues().nextCharValue());
    }

    @Test
    void indexedCharArrayShouldComeBackAsCharArrayValue() {
        this.shouldReadBackToExactOriginalValue((Value)random.randomValues().nextCharArray());
    }

    private void shouldReadBackToExactOriginalValue(Value srcValue) {
        GenericKey state = this.newKeyState();
        state.clear();
        state.writeValue(srcValue, NativeIndexKey.Inclusion.NEUTRAL);
        Value retrievedValueAfterWrittenToState = state.asValue();
        Assertions.assertEquals((Object)srcValue, (Object)retrievedValueAfterWrittenToState);
        Assertions.assertEquals(srcValue.getClass(), retrievedValueAfterWrittenToState.getClass());
        PageCursor cursor = this.newPageCursor();
        int offset = cursor.getOffset();
        state.put(cursor);
        int keySize = cursor.getOffset() - offset;
        cursor.setOffset(offset);
        state.clear();
        state.get(cursor, keySize);
        Value retrievedValueAfterReadFromCursor = state.asValue();
        Assertions.assertEquals((Object)srcValue, (Object)retrievedValueAfterReadFromCursor);
        Assertions.assertEquals(srcValue.getClass(), retrievedValueAfterReadFromCursor.getClass());
    }

    private void assertHighestStringArray() {
        for (int i = 0; i < 1000; ++i) {
            this.assertHighest((Value)random.randomValues().nextTextArray());
        }
    }

    private void assertHighestString() {
        for (int i = 0; i < 1000; ++i) {
            this.assertHighest((Value)random.randomValues().nextTextValue());
        }
    }

    private void assertHighest(Value value) {
        GenericKey highestOfAll = this.newKeyState();
        GenericKey highestInValueGroup = this.newKeyState();
        GenericKey other = this.newKeyState();
        highestOfAll.initValueAsHighest(ValueGroup.UNKNOWN);
        highestInValueGroup.initValueAsHighest(value.valueGroup());
        other.writeValue(value, NativeIndexKey.Inclusion.NEUTRAL);
        Assertions.assertTrue((highestInValueGroup.compareValueTo(other) > 0 ? 1 : 0) != 0, (String)("highestInValueGroup not higher than " + value));
        Assertions.assertTrue((highestOfAll.compareValueTo(other) > 0 ? 1 : 0) != 0, (String)("highestOfAll not higher than " + value));
        Assertions.assertTrue((highestOfAll.compareValueTo(highestInValueGroup) > 0 || highestOfAll.type == highestInValueGroup.type ? 1 : 0) != 0, (String)"highestOfAll not higher than highestInValueGroup");
    }

    private void assertLowest(Value value) {
        GenericKey lowestOfAll = this.newKeyState();
        GenericKey lowestInValueGroup = this.newKeyState();
        GenericKey other = this.newKeyState();
        lowestOfAll.initValueAsLowest(ValueGroup.UNKNOWN);
        lowestInValueGroup.initValueAsLowest(value.valueGroup());
        other.writeValue(value, NativeIndexKey.Inclusion.NEUTRAL);
        Assertions.assertTrue((lowestInValueGroup.compareValueTo(other) <= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((lowestOfAll.compareValueTo(other) <= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((lowestOfAll.compareValueTo(lowestInValueGroup) <= 0 ? 1 : 0) != 0);
    }

    private Value pickSmaller(Value value1, Value value2) {
        return Values.COMPARATOR.compare(value1, value2) < 0 ? value1 : value2;
    }

    private void assertValidMinimalSplitter(Value left, Value right) {
        GenericKey leftState = this.newKeyState();
        leftState.writeValue(left, NativeIndexKey.Inclusion.NEUTRAL);
        GenericKey rightState = this.newKeyState();
        rightState.writeValue(right, NativeIndexKey.Inclusion.NEUTRAL);
        GenericKey minimalSplitter = this.newKeyState();
        rightState.minimalSplitter(leftState, rightState, minimalSplitter);
        Assertions.assertTrue((leftState.compareValueTo(minimalSplitter) < 0 ? 1 : 0) != 0, (String)("left state not less than minimal splitter, leftState=" + leftState + ", rightState=" + rightState + ", minimalSplitter=" + minimalSplitter));
        Assertions.assertTrue((rightState.compareValueTo(minimalSplitter) >= 0 ? 1 : 0) != 0, (String)("right state not less than minimal splitter, leftState=" + leftState + ", rightState=" + rightState + ", minimalSplitter=" + minimalSplitter));
    }

    private void assertValidMinimalSplitterForEqualValues(Value value) {
        GenericKey leftState = this.newKeyState();
        leftState.writeValue(value, NativeIndexKey.Inclusion.NEUTRAL);
        GenericKey rightState = this.newKeyState();
        rightState.writeValue(value, NativeIndexKey.Inclusion.NEUTRAL);
        GenericKey minimalSplitter = this.newKeyState();
        rightState.minimalSplitter(leftState, rightState, minimalSplitter);
        Assertions.assertEquals((int)0, (int)leftState.compareValueTo(minimalSplitter), (String)("left state not equal to minimal splitter, leftState=" + leftState + ", rightState=" + rightState + ", minimalSplitter=" + minimalSplitter));
        Assertions.assertEquals((int)0, (int)rightState.compareValueTo(minimalSplitter), (String)("right state not equal to minimal splitter, leftState=" + leftState + ", rightState=" + rightState + ", minimalSplitter=" + minimalSplitter));
    }

    private static Value nextValidValue(boolean includeIncomparable) {
        Value value;
        do {
            value = random.randomValues().nextValue();
        } while (!includeIncomparable && GenericKeyStateTest.isIncomparable(value));
        return value;
    }

    private static boolean isIncomparable(Value value) {
        return Values.isGeometryValue((Value)value) || Values.isGeometryArray((Value)value);
    }

    private static ValueGenerator[] listValueGenerators(boolean includeIncomparable) {
        ArrayList<ValueGenerator> generators = new ArrayList<ValueGenerator>(Arrays.asList(() -> random.randomValues().nextDateTimeValue(), () -> random.randomValues().nextLocalDateTimeValue(), () -> random.randomValues().nextDateValue(), () -> random.randomValues().nextTimeValue(), () -> random.randomValues().nextLocalTimeValue(), () -> random.randomValues().nextPeriod(), () -> random.randomValues().nextDuration(), () -> random.randomValues().nextCharValue(), () -> random.randomValues().nextTextValue(), () -> random.randomValues().nextAlphaNumericTextValue(), () -> random.randomValues().nextBooleanValue(), () -> random.randomValues().nextNumberValue(), () -> random.randomValues().nextDateTimeArray(), () -> random.randomValues().nextLocalDateTimeArray(), () -> random.randomValues().nextDateArray(), () -> random.randomValues().nextTimeArray(), () -> random.randomValues().nextLocalTimeArray(), () -> random.randomValues().nextDurationArray(), () -> random.randomValues().nextDurationArray(), () -> random.randomValues().nextCharArray(), () -> random.randomValues().nextTextArray(), () -> random.randomValues().nextAlphaNumericTextArray(), () -> random.randomValues().nextBooleanArray(), () -> random.randomValues().nextByteArray(), () -> random.randomValues().nextShortArray(), () -> random.randomValues().nextIntArray(), () -> random.randomValues().nextLongArray(), () -> random.randomValues().nextFloatArray(), () -> random.randomValues().nextDoubleArray(), () -> GenericKeyStateTest.nextValidValue(includeIncomparable)));
        if (includeIncomparable) {
            generators.addAll(Arrays.asList(() -> random.randomValues().nextPointValue(), () -> random.randomValues().nextGeographicPoint(), () -> random.randomValues().nextGeographic3DPoint(), () -> random.randomValues().nextCartesianPoint(), () -> random.randomValues().nextCartesian3DPoint(), () -> random.randomValues().nextGeographicPointArray(), () -> random.randomValues().nextGeographic3DPoint(), () -> random.randomValues().nextCartesianPointArray(), () -> random.randomValues().nextCartesian3DPointArray()));
        }
        return generators.toArray(new ValueGenerator[0]);
    }

    private static Stream<ValueGenerator> validValueGenerators() {
        return Stream.of(GenericKeyStateTest.listValueGenerators(true));
    }

    private static Stream<ValueGenerator> validComparableValueGenerators() {
        return Stream.of(GenericKeyStateTest.listValueGenerators(false));
    }

    private GenericKey genericKeyStateWithSomePreviousState(ValueGenerator valueGenerator) {
        GenericKey to = this.newKeyState();
        if (random.nextBoolean()) {
            NativeIndexKey.Inclusion inclusion = (NativeIndexKey.Inclusion)random.among((Object[])NativeIndexKey.Inclusion.values());
            Value value = valueGenerator.next();
            to.writeValue(value, inclusion);
        }
        return to;
    }

    private PageCursor newPageCursor() {
        return ByteArrayPageCursor.wrap((int)8192);
    }

    private GenericKey newKeyState() {
        return new GenericKey(this.noSpecificIndexSettings);
    }

    @FunctionalInterface
    private static interface ValueGenerator {
        public Value next();
    }
}

