/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.schema.DateLayout;
import org.neo4j.kernel.impl.index.schema.DurationLayout;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexLayoutFactory;
import org.neo4j.kernel.impl.index.schema.LocalDateTimeLayout;
import org.neo4j.kernel.impl.index.schema.LocalTimeLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessorTests;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexSingleValueKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.NumberIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NumberIndexKey;
import org.neo4j.kernel.impl.index.schema.NumberIndexProvider;
import org.neo4j.kernel.impl.index.schema.NumberLayoutNonUnique;
import org.neo4j.kernel.impl.index.schema.StringIndexAccessor;
import org.neo4j.kernel.impl.index.schema.StringIndexKey;
import org.neo4j.kernel.impl.index.schema.StringIndexProvider;
import org.neo4j.kernel.impl.index.schema.StringLayout;
import org.neo4j.kernel.impl.index.schema.TemporalIndexAccessor;
import org.neo4j.kernel.impl.index.schema.TemporalIndexFiles;
import org.neo4j.kernel.impl.index.schema.TemporalIndexProvider;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeLayout;
import org.neo4j.kernel.impl.index.schema.ZonedTimeLayout;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueType;

@RunWith(value=Parameterized.class)
public class NativeIndexAccessorTest<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndexAccessorTests<KEY, VALUE> {
    private static final IndexSpecificSpaceFillingCurveSettingsCache spaceFillingCurveSettings = new IndexSpecificSpaceFillingCurveSettingsCache(new ConfiguredSpaceFillingCurveSettingsCache(Config.defaults()), Collections.emptyMap());
    private static final StandardConfiguration configuration = new StandardConfiguration();
    private final AccessorFactory<KEY, VALUE> accessorFactory;
    private final ValueType[] supportedTypes;
    private final IndexLayoutFactory<KEY, VALUE> indexLayoutFactory;
    private final IndexCapability indexCapability;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"Number", NativeIndexAccessorTest.numberAccessorFactory(), RandomValues.typesOfGroup((ValueGroup)ValueGroup.NUMBER), NumberLayoutNonUnique::new, NumberIndexProvider.CAPABILITY}, {"String", NativeIndexAccessorTest.stringAccessorFactory(), RandomValues.typesOfGroup((ValueGroup)ValueGroup.TEXT), StringLayout::new, StringIndexProvider.CAPABILITY}, {"Date", NativeIndexAccessorTest.temporalAccessorFactory(ValueGroup.DATE), RandomValues.typesOfGroup((ValueGroup)ValueGroup.DATE), DateLayout::new, TemporalIndexProvider.CAPABILITY}, {"DateTime", NativeIndexAccessorTest.temporalAccessorFactory(ValueGroup.ZONED_DATE_TIME), RandomValues.typesOfGroup((ValueGroup)ValueGroup.ZONED_DATE_TIME), ZonedDateTimeLayout::new, TemporalIndexProvider.CAPABILITY}, {"Duration", NativeIndexAccessorTest.temporalAccessorFactory(ValueGroup.DURATION), RandomValues.typesOfGroup((ValueGroup)ValueGroup.DURATION), DurationLayout::new, TemporalIndexProvider.CAPABILITY}, {"LocalDateTime", NativeIndexAccessorTest.temporalAccessorFactory(ValueGroup.LOCAL_DATE_TIME), RandomValues.typesOfGroup((ValueGroup)ValueGroup.LOCAL_DATE_TIME), LocalDateTimeLayout::new, TemporalIndexProvider.CAPABILITY}, {"LocalTime", NativeIndexAccessorTest.temporalAccessorFactory(ValueGroup.LOCAL_TIME), RandomValues.typesOfGroup((ValueGroup)ValueGroup.LOCAL_TIME), LocalTimeLayout::new, TemporalIndexProvider.CAPABILITY}, {"LocalDateTime", NativeIndexAccessorTest.temporalAccessorFactory(ValueGroup.LOCAL_DATE_TIME), RandomValues.typesOfGroup((ValueGroup)ValueGroup.LOCAL_DATE_TIME), LocalDateTimeLayout::new, TemporalIndexProvider.CAPABILITY}, {"Time", NativeIndexAccessorTest.temporalAccessorFactory(ValueGroup.ZONED_TIME), RandomValues.typesOfGroup((ValueGroup)ValueGroup.ZONED_TIME), ZonedTimeLayout::new, TemporalIndexProvider.CAPABILITY}, {"Generic", NativeIndexAccessorTest.genericAccessorFactory(), ValueType.values(), () -> new GenericLayout(1, spaceFillingCurveSettings), GenericNativeIndexProvider.CAPABILITY});
    }

    public NativeIndexAccessorTest(String name, AccessorFactory<KEY, VALUE> accessorFactory, ValueType[] supportedTypes, IndexLayoutFactory<KEY, VALUE> indexLayoutFactory, IndexCapability indexCapability) {
        this.accessorFactory = accessorFactory;
        this.supportedTypes = supportedTypes;
        this.indexLayoutFactory = indexLayoutFactory;
        this.indexCapability = indexCapability;
    }

    @Override
    NativeIndexAccessor<KEY, VALUE> makeAccessor() throws IOException {
        return this.accessorFactory.create(this.pageCache, (FileSystemAbstraction)this.fs, this.getIndexFile(), this.layout, RecoveryCleanupWorkCollector.immediate(), this.monitor, this.indexDescriptor, this.indexDirectoryStructure);
    }

    @Override
    IndexCapability indexCapability() {
        return this.indexCapability;
    }

    @Override
    ValueCreatorUtil<KEY, VALUE> createValueCreatorUtil() {
        return new ValueCreatorUtil(TestIndexDescriptorFactory.forLabel(42, 666).withId(0L), this.supportedTypes, 0.1);
    }

    @Override
    IndexLayout<KEY, VALUE> createLayout() {
        return this.indexLayoutFactory.create();
    }

    private static AccessorFactory<NumberIndexKey, NativeIndexValue> numberAccessorFactory() {
        return (pageCache, fs, storeFile, layout, recoveryCleanupWorkCollector, monitor, descriptor, directory) -> new NumberIndexAccessor(pageCache, fs, storeFile, layout, recoveryCleanupWorkCollector, monitor, descriptor);
    }

    private static AccessorFactory<StringIndexKey, NativeIndexValue> stringAccessorFactory() {
        return (pageCache, fs, storeFile, layout, recoveryCleanupWorkCollector, monitor, descriptor, directory) -> new StringIndexAccessor(pageCache, fs, storeFile, layout, recoveryCleanupWorkCollector, monitor, descriptor);
    }

    private static <TK extends NativeIndexSingleValueKey<TK>> AccessorFactory<TK, NativeIndexValue> temporalAccessorFactory(ValueGroup temporalValueGroup) {
        return (pageCache, fs, storeFile, layout, cleanup, monitor, descriptor, directory) -> {
            TemporalIndexFiles.FileLayout fileLayout = new TemporalIndexFiles.FileLayout(storeFile, layout, temporalValueGroup);
            return new TemporalIndexAccessor.PartAccessor(pageCache, fs, fileLayout, cleanup, monitor, descriptor);
        };
    }

    private static AccessorFactory<GenericKey, NativeIndexValue> genericAccessorFactory() {
        return (pageCache, fs, storeFile, layout, cleanup, monitor, descriptor, directory) -> new GenericNativeIndexAccessor(pageCache, fs, storeFile, layout, cleanup, monitor, descriptor, spaceFillingCurveSettings, directory, (SpaceFillingCurveConfiguration)configuration);
    }

    @FunctionalInterface
    private static interface AccessorFactory<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> {
        public NativeIndexAccessor<KEY, VALUE> create(PageCache var1, FileSystemAbstraction var2, File var3, IndexLayout<KEY, VALUE> var4, RecoveryCleanupWorkCollector var5, IndexProvider.Monitor var6, StoreIndexDescriptor var7, IndexDirectoryStructure var8) throws IOException;
    }
}

