/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.schema.DateLayout;
import org.neo4j.kernel.impl.index.schema.DurationLayout;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexLayoutFactory;
import org.neo4j.kernel.impl.index.schema.LocalDateTimeLayout;
import org.neo4j.kernel.impl.index.schema.LocalTimeLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulatorTests;
import org.neo4j.kernel.impl.index.schema.NativeIndexSingleValueKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.NumberIndexKey;
import org.neo4j.kernel.impl.index.schema.NumberIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NumberLayoutNonUnique;
import org.neo4j.kernel.impl.index.schema.SimpleIndexDirectoryStructures;
import org.neo4j.kernel.impl.index.schema.StringIndexPopulator;
import org.neo4j.kernel.impl.index.schema.StringLayout;
import org.neo4j.kernel.impl.index.schema.TemporalIndexFiles;
import org.neo4j.kernel.impl.index.schema.TemporalIndexPopulator;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeLayout;
import org.neo4j.kernel.impl.index.schema.ZonedTimeLayout;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueType;

public class NativeIndexPopulatorTest {
    private static final IndexSpecificSpaceFillingCurveSettingsCache spaceFillingCurveSettings = new IndexSpecificSpaceFillingCurveSettingsCache(new ConfiguredSpaceFillingCurveSettingsCache(Config.defaults()), new HashMap());
    private static final StandardConfiguration configuration = new StandardConfiguration();

    private static Collection<Object[]> allPopulators() {
        return Arrays.asList({"Number", NativeIndexPopulatorTest.numberPopulatorFactory(), RandomValues.typesOfGroup((ValueGroup)ValueGroup.NUMBER), NumberLayoutNonUnique::new}, {"String", StringIndexPopulator::new, RandomValues.typesOfGroup((ValueGroup)ValueGroup.TEXT), StringLayout::new}, {"Date", NativeIndexPopulatorTest.temporalPopulatorFactory(ValueGroup.DATE), RandomValues.typesOfGroup((ValueGroup)ValueGroup.DATE), DateLayout::new}, {"DateTime", NativeIndexPopulatorTest.temporalPopulatorFactory(ValueGroup.ZONED_DATE_TIME), RandomValues.typesOfGroup((ValueGroup)ValueGroup.ZONED_DATE_TIME), ZonedDateTimeLayout::new}, {"Duration", NativeIndexPopulatorTest.temporalPopulatorFactory(ValueGroup.DURATION), RandomValues.typesOfGroup((ValueGroup)ValueGroup.DURATION), DurationLayout::new}, {"LocalDateTime", NativeIndexPopulatorTest.temporalPopulatorFactory(ValueGroup.LOCAL_DATE_TIME), RandomValues.typesOfGroup((ValueGroup)ValueGroup.LOCAL_DATE_TIME), LocalDateTimeLayout::new}, {"LocalTime", NativeIndexPopulatorTest.temporalPopulatorFactory(ValueGroup.LOCAL_TIME), RandomValues.typesOfGroup((ValueGroup)ValueGroup.LOCAL_TIME), LocalTimeLayout::new}, {"LocalDateTime", NativeIndexPopulatorTest.temporalPopulatorFactory(ValueGroup.LOCAL_DATE_TIME), RandomValues.typesOfGroup((ValueGroup)ValueGroup.LOCAL_DATE_TIME), LocalDateTimeLayout::new}, {"Time", NativeIndexPopulatorTest.temporalPopulatorFactory(ValueGroup.ZONED_TIME), RandomValues.typesOfGroup((ValueGroup)ValueGroup.ZONED_TIME), ZonedTimeLayout::new}, {"Generic", NativeIndexPopulatorTest.genericPopulatorFactory(), ValueType.values(), () -> new GenericLayout(1, spaceFillingCurveSettings)});
    }

    private static PopulatorFactory<NumberIndexKey, NativeIndexValue> numberPopulatorFactory() {
        return NumberIndexPopulator::new;
    }

    private static <TK extends NativeIndexSingleValueKey<TK>> PopulatorFactory<TK, NativeIndexValue> temporalPopulatorFactory(ValueGroup temporalValueGroup) {
        return (pageCache, fs, storeFile, layout, monitor, descriptor) -> {
            TemporalIndexFiles.FileLayout fileLayout = new TemporalIndexFiles.FileLayout(storeFile, layout, temporalValueGroup);
            return new TemporalIndexPopulator.PartPopulator(pageCache, fs, fileLayout, monitor, descriptor);
        };
    }

    private static PopulatorFactory<GenericKey, NativeIndexValue> genericPopulatorFactory() {
        return (pageCache, fs, storeFile, layout, monitor, descriptor) -> new GenericNativeIndexPopulator(pageCache, fs, storeFile, layout, monitor, descriptor, spaceFillingCurveSettings, SimpleIndexDirectoryStructures.onIndexFile(storeFile), (SpaceFillingCurveConfiguration)configuration, false, false);
    }

    @RunWith(value=Parameterized.class)
    public static class NonUniqueTest<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
    extends NativeIndexPopulatorTests.NonUnique<KEY, VALUE> {
        @Parameterized.Parameter
        public String name;
        @Parameterized.Parameter(value=1)
        public PopulatorFactory<KEY, VALUE> populatorFactory;
        @Parameterized.Parameter(value=2)
        public ValueType[] supportedTypes;
        @Parameterized.Parameter(value=3)
        public IndexLayoutFactory<KEY, VALUE> indexLayoutFactory;
        private static final StoreIndexDescriptor nonUniqueDescriptor = TestIndexDescriptorFactory.forLabel(42, 666).withId(0L);

        @Parameterized.Parameters(name="{index} {0}")
        public static Collection<Object[]> data() {
            return NativeIndexPopulatorTest.allPopulators();
        }

        @Override
        NativeIndexPopulator<KEY, VALUE> createPopulator() throws IOException {
            return this.populatorFactory.create(this.pageCache, (FileSystemAbstraction)this.fs, this.getIndexFile(), this.layout, this.monitor, this.indexDescriptor);
        }

        @Override
        ValueCreatorUtil<KEY, VALUE> createValueCreatorUtil() {
            return new ValueCreatorUtil(nonUniqueDescriptor, this.supportedTypes, 0.1);
        }

        @Override
        IndexLayout<KEY, VALUE> createLayout() {
            return this.indexLayoutFactory.create();
        }
    }

    @RunWith(value=Parameterized.class)
    public static class UniqueTest<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
    extends NativeIndexPopulatorTests.Unique<KEY, VALUE> {
        @Parameterized.Parameter
        public String name;
        @Parameterized.Parameter(value=1)
        public PopulatorFactory<KEY, VALUE> populatorFactory;
        @Parameterized.Parameter(value=2)
        public ValueType[] supportedTypes;
        @Parameterized.Parameter(value=3)
        public IndexLayoutFactory<KEY, VALUE> indexLayoutFactory;
        private static final StoreIndexDescriptor uniqueDescriptor = TestIndexDescriptorFactory.uniqueForLabel(42, 666).withId(0L);

        @Parameterized.Parameters(name="{index} {0}")
        public static Collection<Object[]> data() {
            return NativeIndexPopulatorTest.allPopulators();
        }

        @Override
        NativeIndexPopulator<KEY, VALUE> createPopulator() throws IOException {
            return this.populatorFactory.create(this.pageCache, (FileSystemAbstraction)this.fs, this.getIndexFile(), this.layout, this.monitor, this.indexDescriptor);
        }

        @Override
        ValueCreatorUtil<KEY, VALUE> createValueCreatorUtil() {
            return new ValueCreatorUtil(uniqueDescriptor, this.supportedTypes, 0.0);
        }

        @Override
        IndexLayout<KEY, VALUE> createLayout() {
            return this.indexLayoutFactory.create();
        }
    }

    @FunctionalInterface
    private static interface PopulatorFactory<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> {
        public NativeIndexPopulator<KEY, VALUE> create(PageCache var1, FileSystemAbstraction var2, File var3, IndexLayout<KEY, VALUE> var4, IndexProvider.Monitor var5, StoreIndexDescriptor var6) throws IOException;
    }
}

