/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexAccessor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexTestHelp;
import org.neo4j.kernel.impl.index.schema.fusion.FusionVersion;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class FusionIndexAccessorTest {
    private FusionIndexAccessor fusionIndexAccessor;
    private final long indexId = 0L;
    private final FusionIndexProvider.DropAction dropAction = (FusionIndexProvider.DropAction)Mockito.mock(FusionIndexProvider.DropAction.class);
    private EnumMap<IndexSlot, IndexAccessor> accessors;
    private IndexAccessor[] aliveAccessors;
    private StoreIndexDescriptor indexDescriptor = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{42})).withId(0L);
    @Rule
    public RandomRule random = new RandomRule();
    @Parameterized.Parameter
    public static FusionVersion fusionVersion;

    @Parameterized.Parameters(name="{0}")
    public static FusionVersion[] versions() {
        return new FusionVersion[]{FusionVersion.v00, FusionVersion.v10, FusionVersion.v20};
    }

    @Before
    public void setup() {
        this.initiateMocks();
    }

    private void initiateMocks() {
        IndexSlot[] activeSlots = fusionVersion.aliveSlots();
        this.accessors = new EnumMap(IndexSlot.class);
        FusionIndexTestHelp.fill(this.accessors, IndexAccessor.EMPTY);
        this.aliveAccessors = new IndexAccessor[activeSlots.length];
        block7: for (int i = 0; i < activeSlots.length; ++i) {
            IndexAccessor mock;
            this.aliveAccessors[i] = mock = (IndexAccessor)Mockito.mock(IndexAccessor.class);
            switch (activeSlots[i]) {
                case STRING: {
                    this.accessors.put(IndexSlot.STRING, mock);
                    continue block7;
                }
                case NUMBER: {
                    this.accessors.put(IndexSlot.NUMBER, mock);
                    continue block7;
                }
                case SPATIAL: {
                    this.accessors.put(IndexSlot.SPATIAL, mock);
                    continue block7;
                }
                case TEMPORAL: {
                    this.accessors.put(IndexSlot.TEMPORAL, mock);
                    continue block7;
                }
                case LUCENE: {
                    this.accessors.put(IndexSlot.LUCENE, mock);
                    continue block7;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        this.fusionIndexAccessor = new FusionIndexAccessor(fusionVersion.slotSelector(), new InstanceSelector(this.accessors), this.indexDescriptor, this.dropAction);
    }

    private void resetMocks() {
        for (IndexAccessor accessor : this.aliveAccessors) {
            Mockito.reset((Object[])new IndexAccessor[]{accessor});
        }
    }

    @Test
    public void dropMustDropAll() {
        this.fusionIndexAccessor.drop();
        for (IndexAccessor accessor : this.aliveAccessors) {
            ((IndexAccessor)Mockito.verify((Object)accessor, (VerificationMode)VerificationModeFactory.times((int)1))).drop();
        }
        ((FusionIndexProvider.DropAction)Mockito.verify((Object)this.dropAction)).drop(0L);
    }

    @Test
    public void dropMustThrowIfDropAnyFail() {
        for (IndexAccessor accessor : this.aliveAccessors) {
            FusionIndexAccessorTest.verifyFailOnSingleDropFailure(accessor, this.fusionIndexAccessor);
        }
    }

    @Test
    public void fusionIndexIsDirtyWhenAnyIsDirty() {
        for (IndexAccessor dirtyAccessor : this.aliveAccessors) {
            for (IndexAccessor aliveAccessor : this.aliveAccessors) {
                Mockito.when((Object)aliveAccessor.isDirty()).thenReturn((Object)(aliveAccessor == dirtyAccessor ? 1 : 0));
            }
            Assert.assertTrue((boolean)this.fusionIndexAccessor.isDirty());
        }
    }

    private static void verifyFailOnSingleDropFailure(IndexAccessor failingAccessor, FusionIndexAccessor fusionIndexAccessor) {
        UncheckedIOException expectedFailure = new UncheckedIOException(new IOException("fail"));
        ((IndexAccessor)Mockito.doThrow((Throwable[])new Throwable[]{expectedFailure}).when((Object)failingAccessor)).drop();
        try {
            fusionIndexAccessor.drop();
            Assert.fail((String)"Should have failed");
        }
        catch (UncheckedIOException e) {
            Assert.assertSame((Object)expectedFailure, (Object)e);
        }
        ((IndexAccessor)Mockito.doAnswer(invocation -> null).when((Object)failingAccessor)).drop();
    }

    @Test
    public void dropMustThrowIfAllFail() {
        ArrayList<UncheckedIOException> exceptions = new ArrayList<UncheckedIOException>();
        for (IndexAccessor indexAccessor : this.aliveAccessors) {
            UncheckedIOException exception = new UncheckedIOException(new IOException(indexAccessor.getClass().getSimpleName() + " fail"));
            exceptions.add(exception);
            ((IndexAccessor)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)indexAccessor)).drop();
        }
        try {
            this.fusionIndexAccessor.drop();
            Assert.fail((String)"Should have failed");
        }
        catch (UncheckedIOException e) {
            Assert.assertThat(exceptions, (Matcher)CoreMatchers.hasItem((Object)e));
        }
    }

    @Test
    public void closeMustCloseAll() {
        this.fusionIndexAccessor.close();
        for (IndexAccessor accessor : this.aliveAccessors) {
            ((IndexAccessor)Mockito.verify((Object)accessor, (VerificationMode)VerificationModeFactory.times((int)1))).close();
        }
    }

    @Test
    public void closeMustThrowIfOneThrow() throws Exception {
        for (int i = 0; i < this.aliveAccessors.length; ++i) {
            IndexAccessor accessor = this.aliveAccessors[i];
            FusionIndexTestHelp.verifyFusionCloseThrowOnSingleCloseThrow((AutoCloseable)accessor, (AutoCloseable)this.fusionIndexAccessor);
            this.initiateMocks();
        }
    }

    @Test
    public void closeMustCloseOthersIfOneThrow() throws Exception {
        for (int i = 0; i < this.aliveAccessors.length; ++i) {
            IndexAccessor accessor = this.aliveAccessors[i];
            FusionIndexTestHelp.verifyOtherIsClosedOnSingleThrow((AutoCloseable)accessor, (AutoCloseable)this.fusionIndexAccessor, (AutoCloseable[])ArrayUtil.without((Object[])this.aliveAccessors, (Object[])new IndexAccessor[]{accessor}));
            this.initiateMocks();
        }
    }

    @Test
    public void closeMustThrowIfAllFail() throws Exception {
        FusionIndexTestHelp.verifyFusionCloseThrowIfAllThrow((AutoCloseable)this.fusionIndexAccessor, (AutoCloseable[])this.aliveAccessors);
    }

    @Test
    public void allEntriesReaderMustCombineResultFromAll() {
        List[] ids = new List[this.aliveAccessors.length];
        long lastId = 0L;
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = Arrays.asList(lastId++, lastId++);
        }
        this.mockAllEntriesReaders(ids);
        Set result = Iterables.asSet((Iterable)this.fusionIndexAccessor.newAllEntriesReader());
        for (List part : ids) {
            FusionIndexAccessorTest.assertResultContainsAll(result, part);
        }
    }

    @Test
    public void allEntriesReaderMustCombineResultFromAllEmpty() {
        List[] ids = new List[this.aliveAccessors.length];
        for (int j = 0; j < ids.length; ++j) {
            ids[j] = Collections.emptyList();
        }
        this.mockAllEntriesReaders(ids);
        Set result = Iterables.asSet((Iterable)this.fusionIndexAccessor.newAllEntriesReader());
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void allEntriesReaderMustCombineResultFromAllAccessors() {
        Object[] parts = new List[this.aliveAccessors.length];
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = new ArrayList();
        }
        for (long i = 0L; i < 10L; ++i) {
            ((List)this.random.among(parts)).add(i);
        }
        this.mockAllEntriesReaders((List<Long>[])parts);
        Set result = Iterables.asSet((Iterable)this.fusionIndexAccessor.newAllEntriesReader());
        for (Object part : parts) {
            FusionIndexAccessorTest.assertResultContainsAll(result, (List<Long>)part);
        }
    }

    @Test
    public void allEntriesReaderMustCloseAll() throws Exception {
        BoundedIterable[] allEntriesReaders = (BoundedIterable[])Arrays.stream(this.aliveAccessors).map(accessor -> FusionIndexAccessorTest.mockSingleAllEntriesReader(accessor, Arrays.asList(new Long[0]))).toArray(BoundedIterable[]::new);
        this.fusionIndexAccessor.newAllEntriesReader().close();
        for (BoundedIterable allEntriesReader : allEntriesReaders) {
            ((BoundedIterable)Mockito.verify((Object)allEntriesReader, (VerificationMode)VerificationModeFactory.times((int)1))).close();
        }
    }

    @Test
    public void allEntriesReaderMustCloseOthersIfOneThrow() throws Exception {
        for (int i = 0; i < this.aliveAccessors.length; ++i) {
            Object[] allEntriesReaders = (BoundedIterable[])Arrays.stream(this.aliveAccessors).map(accessor -> FusionIndexAccessorTest.mockSingleAllEntriesReader(accessor, Arrays.asList(new Long[0]))).toArray(BoundedIterable[]::new);
            BoundedIterable fusionAllEntriesReader = this.fusionIndexAccessor.newAllEntriesReader();
            FusionIndexTestHelp.verifyOtherIsClosedOnSingleThrow((AutoCloseable)allEntriesReaders[i], (AutoCloseable)fusionAllEntriesReader, (AutoCloseable[])ArrayUtil.without((Object[])allEntriesReaders, (Object[])new BoundedIterable[]{allEntriesReaders[i]}));
            this.resetMocks();
        }
    }

    @Test
    public void allEntriesReaderMustThrowIfOneThrow() throws Exception {
        for (IndexAccessor failingAccessor : this.aliveAccessors) {
            BoundedIterable<Long> failingReader = null;
            for (IndexAccessor aliveAccessor : this.aliveAccessors) {
                BoundedIterable<Long> reader = FusionIndexAccessorTest.mockSingleAllEntriesReader(aliveAccessor, Collections.emptyList());
                if (aliveAccessor != failingAccessor) continue;
                failingReader = reader;
            }
            BoundedIterable fusionAllEntriesReader = this.fusionIndexAccessor.newAllEntriesReader();
            FusionIndexTestHelp.verifyFusionCloseThrowOnSingleCloseThrow(failingReader, (AutoCloseable)fusionAllEntriesReader);
        }
    }

    @Test
    public void allEntriesReaderMustReportUnknownMaxCountIfAnyReportUnknownMaxCount() {
        for (int i = 0; i < this.aliveAccessors.length; ++i) {
            for (int j = 0; j < this.aliveAccessors.length; ++j) {
                if (j == i) {
                    FusionIndexAccessorTest.mockSingleAllEntriesReaderWithUnknownMaxCount(this.aliveAccessors[j], Collections.emptyList());
                    continue;
                }
                FusionIndexAccessorTest.mockSingleAllEntriesReader(this.aliveAccessors[j], Collections.emptyList());
            }
            BoundedIterable fusionAllEntriesReader = this.fusionIndexAccessor.newAllEntriesReader();
            Assert.assertThat((Object)fusionAllEntriesReader.maxCount(), (Matcher)CoreMatchers.is((Object)-1L));
        }
    }

    @Test
    public void allEntriesReaderMustReportFusionMaxCountOfAll() {
        long lastId = 0L;
        for (IndexAccessor accessor : this.aliveAccessors) {
            FusionIndexAccessorTest.mockSingleAllEntriesReader(accessor, Arrays.asList(lastId++, lastId++));
        }
        BoundedIterable fusionAllEntriesReader = this.fusionIndexAccessor.newAllEntriesReader();
        Assert.assertThat((Object)fusionAllEntriesReader.maxCount(), (Matcher)CoreMatchers.is((Object)lastId));
    }

    @Test
    public void shouldFailValueValidationIfAnyPartFail() {
        IllegalArgumentException failure = new IllegalArgumentException("failing");
        for (int i = 0; i < this.aliveAccessors.length; ++i) {
            for (int j = 0; j < this.aliveAccessors.length; ++j) {
                if (i == j) {
                    ((IndexAccessor)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)this.aliveAccessors[i])).validateBeforeCommit((Value[])ArgumentMatchers.any(Value[].class));
                    continue;
                }
                ((IndexAccessor)Mockito.doAnswer(invocation -> null).when((Object)this.aliveAccessors[i])).validateBeforeCommit((Value[])ArgumentMatchers.any(Value[].class));
            }
            try {
                this.fusionIndexAccessor.validateBeforeCommit(new Value[]{Values.stringValue((String)"something")});
                continue;
            }
            catch (IllegalArgumentException e) {
                Assert.assertSame((Object)failure, (Object)e);
            }
        }
    }

    @Test
    public void shouldSucceedValueValidationIfAllSucceed() {
        this.fusionIndexAccessor.validateBeforeCommit(new Value[]{Values.stringValue((String)"test value")});
    }

    @Test
    public void shouldInstantiateReadersLazily() {
        IndexReader fusionReader = this.fusionIndexAccessor.newReader();
        for (int j = 0; j < this.aliveAccessors.length; ++j) {
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.aliveAccessors[j]});
        }
    }

    @Test
    public void shouldInstantiateUpdatersLazily() {
        IndexUpdater updater = this.fusionIndexAccessor.newUpdater(IndexUpdateMode.ONLINE);
        for (int j = 0; j < this.aliveAccessors.length; ++j) {
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.aliveAccessors[j]});
        }
    }

    private static void assertResultContainsAll(Set<Long> result, List<Long> expectedEntries) {
        for (long expectedEntry : expectedEntries) {
            Assert.assertTrue((String)("Expected to contain " + expectedEntry + ", but was " + result), (boolean)result.contains(expectedEntry));
        }
    }

    private static BoundedIterable<Long> mockSingleAllEntriesReader(IndexAccessor targetAccessor, List<Long> entries) {
        BoundedIterable<Long> allEntriesReader = FusionIndexAccessorTest.mockedAllEntriesReader(entries);
        Mockito.when((Object)targetAccessor.newAllEntriesReader()).thenReturn(allEntriesReader);
        return allEntriesReader;
    }

    private static BoundedIterable<Long> mockedAllEntriesReader(List<Long> entries) {
        return FusionIndexAccessorTest.mockedAllEntriesReader(true, entries);
    }

    private static void mockSingleAllEntriesReaderWithUnknownMaxCount(IndexAccessor targetAccessor, List<Long> entries) {
        BoundedIterable<Long> allEntriesReader = FusionIndexAccessorTest.mockedAllEntriesReaderUnknownMaxCount(entries);
        Mockito.when((Object)targetAccessor.newAllEntriesReader()).thenReturn(allEntriesReader);
    }

    private static BoundedIterable<Long> mockedAllEntriesReaderUnknownMaxCount(List<Long> entries) {
        return FusionIndexAccessorTest.mockedAllEntriesReader(false, entries);
    }

    private static BoundedIterable<Long> mockedAllEntriesReader(boolean knownMaxCount, List<Long> entries) {
        BoundedIterable mockedAllEntriesReader = (BoundedIterable)Mockito.mock(BoundedIterable.class);
        Mockito.when((Object)mockedAllEntriesReader.maxCount()).thenReturn((Object)(knownMaxCount ? (long)entries.size() : -1L));
        Mockito.when((Object)mockedAllEntriesReader.iterator()).thenReturn(entries.iterator());
        return mockedAllEntriesReader;
    }

    private void mockAllEntriesReaders(List<Long> ... entries) {
        for (int i = 0; i < entries.length; ++i) {
            FusionIndexAccessorTest.mockSingleAllEntriesReader(this.aliveAccessors[i], entries[i]);
        }
    }
}

