/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.helpers.StubNodeCursor;
import org.neo4j.internal.kernel.api.helpers.StubPropertyCursor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorPredicates;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingProvidersService;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.newapi.IndexTxStateUpdater;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

public class IndexTxStateUpdaterTest {
    private static final int labelId1 = 10;
    private static final int labelId2 = 11;
    private static final int unIndexedLabelId = 12;
    private static final int propId1 = 20;
    private static final int propId2 = 21;
    private static final int propId3 = 22;
    private static final int newPropId = 23;
    private static final int unIndexedPropId = 24;
    private TransactionState txState;
    private IndexTxStateUpdater indexTxUpdater;
    private IndexDescriptor indexOn1_1 = TestIndexDescriptorFactory.forLabel(10, 20);
    private IndexDescriptor indexOn2_new = TestIndexDescriptorFactory.forLabel(11, 23);
    private IndexDescriptor uniqueOn1_2 = TestIndexDescriptorFactory.uniqueForLabel(10, 21);
    private IndexDescriptor indexOn1_1_new = TestIndexDescriptorFactory.forLabel(10, 20, 23);
    private IndexDescriptor uniqueOn2_2_3 = TestIndexDescriptorFactory.uniqueForLabel(11, 21, 22);
    private List<IndexDescriptor> indexes = Arrays.asList(this.indexOn1_1, this.indexOn2_new, this.uniqueOn1_2, this.indexOn1_1_new, this.uniqueOn2_2_3);
    private StubNodeCursor node;
    private StubPropertyCursor propertyCursor;

    @Before
    public void setup() throws IndexNotFoundKernelException {
        this.txState = (TransactionState)Mockito.mock(TransactionState.class);
        StorageReader storageReader = (StorageReader)Mockito.mock(StorageReader.class);
        Mockito.when((Object)storageReader.indexesGetAll()).thenAnswer(x -> this.indexes.iterator());
        Mockito.when((Object)storageReader.indexesGetForLabel(ArgumentMatchers.anyInt())).thenAnswer(x -> {
            Integer argument = (Integer)x.getArgument(0);
            return Iterators.filter((Predicate)SchemaDescriptorPredicates.hasLabel((int)argument), this.indexes.iterator());
        });
        Mockito.when((Object)storageReader.indexesGetRelatedToProperty(ArgumentMatchers.anyInt())).thenAnswer(x -> {
            Integer argument = (Integer)x.getArgument(0);
            return Iterators.filter((Predicate)SchemaDescriptorPredicates.hasProperty((int)argument), this.indexes.iterator());
        });
        HashMap<Integer, Value> map = new HashMap<Integer, Value>();
        map.put(20, Values.of((Object)"hi1"));
        map.put(21, Values.of((Object)"hi2"));
        map.put(22, Values.of((Object)"hi3"));
        this.node = new StubNodeCursor().withNode(0L, new long[]{10L, 11L}, map);
        this.node.next();
        this.propertyCursor = new StubPropertyCursor();
        Read readOps = (Read)Mockito.mock(Read.class);
        Mockito.when((Object)readOps.txState()).thenReturn((Object)this.txState);
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy((SchemaDescriptor)ArgumentMatchers.any(SchemaDescriptor.class))).thenReturn((Object)indexProxy);
        this.indexTxUpdater = new IndexTxStateUpdater(storageReader, readOps, (IndexingProvidersService)indexingService);
    }

    @Test
    public void shouldNotUpdateIndexesOnChangedIrrelevantLabel() {
        this.indexTxUpdater.onLabelChange(12, (NodeCursor)this.node, (PropertyCursor)this.propertyCursor, IndexTxStateUpdater.LabelChangeType.ADDED_LABEL);
        this.indexTxUpdater.onLabelChange(12, (NodeCursor)this.node, (PropertyCursor)this.propertyCursor, IndexTxStateUpdater.LabelChangeType.REMOVED_LABEL);
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.never())).indexDoUpdateEntry((SchemaDescriptor)ArgumentMatchers.any(), (long)ArgumentMatchers.anyInt(), (ValueTuple)ArgumentMatchers.any(), (ValueTuple)ArgumentMatchers.any());
    }

    @Test
    public void shouldUpdateIndexesOnAddedLabel() {
        this.indexTxUpdater.onLabelChange(10, (NodeCursor)this.node, (PropertyCursor)this.propertyCursor, IndexTxStateUpdater.LabelChangeType.ADDED_LABEL);
        this.verifyIndexUpdate(this.indexOn1_1.schema(), this.node.nodeReference(), null, this.values("hi1"));
        this.verifyIndexUpdate(this.uniqueOn1_2.schema(), this.node.nodeReference(), null, this.values("hi2"));
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.times((int)2))).indexDoUpdateEntry((SchemaDescriptor)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (ValueTuple)ArgumentMatchers.isNull(), (ValueTuple)ArgumentMatchers.any());
    }

    @Test
    public void shouldUpdateIndexesOnRemovedLabel() {
        this.indexTxUpdater.onLabelChange(11, (NodeCursor)this.node, (PropertyCursor)this.propertyCursor, IndexTxStateUpdater.LabelChangeType.REMOVED_LABEL);
        this.verifyIndexUpdate(this.uniqueOn2_2_3.schema(), this.node.nodeReference(), this.values("hi2", "hi3"), null);
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.times((int)1))).indexDoUpdateEntry((SchemaDescriptor)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (ValueTuple)ArgumentMatchers.any(), (ValueTuple)ArgumentMatchers.isNull());
    }

    @Test
    public void shouldNotUpdateIndexesOnChangedIrrelevantProperty() {
        this.indexTxUpdater.onPropertyAdd((NodeCursor)this.node, (PropertyCursor)this.propertyCursor, 24, Values.of((Object)"whAt"));
        this.indexTxUpdater.onPropertyRemove((NodeCursor)this.node, (PropertyCursor)this.propertyCursor, 24, Values.of((Object)"whAt"));
        this.indexTxUpdater.onPropertyChange((NodeCursor)this.node, (PropertyCursor)this.propertyCursor, 24, Values.of((Object)"whAt"), Values.of((Object)"whAt2"));
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.never())).indexDoUpdateEntry((SchemaDescriptor)ArgumentMatchers.any(), (long)ArgumentMatchers.anyInt(), (ValueTuple)ArgumentMatchers.any(), (ValueTuple)ArgumentMatchers.any());
    }

    @Test
    public void shouldUpdateIndexesOnAddedProperty() {
        this.indexTxUpdater.onPropertyAdd((NodeCursor)this.node, (PropertyCursor)this.propertyCursor, 23, Values.of((Object)"newHi"));
        this.verifyIndexUpdate(this.indexOn2_new.schema(), this.node.nodeReference(), null, this.values("newHi"));
        this.verifyIndexUpdate(this.indexOn1_1_new.schema(), this.node.nodeReference(), null, this.values("hi1", "newHi"));
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.times((int)2))).indexDoUpdateEntry((SchemaDescriptor)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (ValueTuple)ArgumentMatchers.isNull(), (ValueTuple)ArgumentMatchers.any());
    }

    @Test
    public void shouldUpdateIndexesOnRemovedProperty() {
        this.indexTxUpdater.onPropertyRemove((NodeCursor)this.node, (PropertyCursor)this.propertyCursor, 21, Values.of((Object)"hi2"));
        this.verifyIndexUpdate(this.uniqueOn1_2.schema(), this.node.nodeReference(), this.values("hi2"), null);
        this.verifyIndexUpdate(this.uniqueOn2_2_3.schema(), this.node.nodeReference(), this.values("hi2", "hi3"), null);
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.times((int)2))).indexDoUpdateEntry((SchemaDescriptor)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (ValueTuple)ArgumentMatchers.any(), (ValueTuple)ArgumentMatchers.isNull());
    }

    @Test
    public void shouldUpdateIndexesOnChangesProperty() {
        this.indexTxUpdater.onPropertyChange((NodeCursor)this.node, (PropertyCursor)this.propertyCursor, 21, Values.of((Object)"hi2"), Values.of((Object)"new2"));
        this.verifyIndexUpdate(this.uniqueOn1_2.schema(), this.node.nodeReference(), this.values("hi2"), this.values("new2"));
        this.verifyIndexUpdate(this.uniqueOn2_2_3.schema(), this.node.nodeReference(), this.values("hi2", "hi3"), this.values("new2", "hi3"));
        ((TransactionState)Mockito.verify((Object)this.txState, (VerificationMode)Mockito.times((int)2))).indexDoUpdateEntry((SchemaDescriptor)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (ValueTuple)ArgumentMatchers.any(), (ValueTuple)ArgumentMatchers.any());
    }

    private ValueTuple values(Object ... values) {
        return ValueTuple.of((Object[])values);
    }

    private void verifyIndexUpdate(SchemaDescriptor schema, long nodeId, ValueTuple before, ValueTuple after) {
        ((TransactionState)Mockito.verify((Object)this.txState)).indexDoUpdateEntry((SchemaDescriptor)ArgumentMatchers.eq((Object)schema), ArgumentMatchers.eq((long)nodeId), (ValueTuple)ArgumentMatchers.eq((Object)before), (ValueTuple)ArgumentMatchers.eq((Object)after));
    }
}

