/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyCreator;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyTraverser;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordPropertyCursor;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.unsafe.batchinsert.internal.DirectRecordAccessSet;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;

public class RecordPropertyCursorTest {
    @Rule
    public final PageCacheAndDependenciesRule storage = new PageCacheAndDependenciesRule();
    @Rule
    public final RandomRule random = new RandomRule().withConfiguration((RandomValues.Configuration)new RandomValues.Default(){

        public int stringMaxLength() {
            return 10000;
        }
    });
    private NeoStores neoStores;
    private PropertyCreator creator;
    private NodeRecord owner;

    @Before
    public void setup() {
        this.neoStores = new StoreFactory(this.storage.directory().databaseLayout(), Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.storage.fileSystem()), this.storage.pageCache(), this.storage.fileSystem(), (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY).openAllNeoStores(true);
        this.creator = new PropertyCreator(this.neoStores.getPropertyStore(), new PropertyTraverser());
        this.owner = (NodeRecord)this.neoStores.getNodeStore().newRecord();
    }

    @After
    public void closeStore() {
        this.neoStores.close();
    }

    @Test
    public void shouldReadPropertyChain() {
        Value[] values = this.createValues();
        long firstPropertyId = this.storeValuesAsPropertyChain(this.creator, this.owner, values);
        this.assertPropertyChain(values, firstPropertyId, this.createCursor());
    }

    @Test
    public void shouldReuseCursor() {
        Value[] valuesA = this.createValues();
        long firstPropertyIdA = this.storeValuesAsPropertyChain(this.creator, this.owner, valuesA);
        Value[] valuesB = this.createValues();
        long firstPropertyIdB = this.storeValuesAsPropertyChain(this.creator, this.owner, valuesB);
        RecordPropertyCursor cursor = this.createCursor();
        this.assertPropertyChain(valuesA, firstPropertyIdA, cursor);
        this.assertPropertyChain(valuesB, firstPropertyIdB, cursor);
    }

    @Test
    public void closeShouldBeIdempotent() {
        RecordPropertyCursor cursor = this.createCursor();
        cursor.close();
        cursor.close();
    }

    private RecordPropertyCursor createCursor() {
        return new RecordPropertyCursor(this.neoStores.getPropertyStore());
    }

    private void assertPropertyChain(Value[] values, long firstPropertyId, RecordPropertyCursor cursor) {
        Map<Integer, Value> expectedValues = this.asMap(values);
        cursor.init(firstPropertyId);
        while (cursor.next()) {
            Assert.assertEquals((Object)expectedValues.remove(cursor.propertyKey()), (Object)cursor.propertyValue());
        }
        Assert.assertTrue((boolean)expectedValues.isEmpty());
    }

    private Value[] createValues() {
        int numberOfProperties = this.random.nextInt(1, 20);
        Value[] values = new Value[numberOfProperties];
        for (int key = 0; key < numberOfProperties; ++key) {
            values[key] = this.random.nextValue();
        }
        return values;
    }

    private long storeValuesAsPropertyChain(PropertyCreator creator, NodeRecord owner, Value[] values) {
        DirectRecordAccessSet access = new DirectRecordAccessSet(this.neoStores);
        long firstPropertyId = creator.createPropertyChain((PrimitiveRecord)owner, this.blocksOf(creator, values), access.getPropertyRecords());
        access.close();
        return firstPropertyId;
    }

    private Map<Integer, Value> asMap(Value[] values) {
        HashMap<Integer, Value> map = new HashMap<Integer, Value>();
        for (int key = 0; key < values.length; ++key) {
            map.put(key, values[key]);
        }
        return map;
    }

    private Iterator<PropertyBlock> blocksOf(final PropertyCreator creator, Value[] values) {
        return new IteratorWrapper<PropertyBlock, Value>(Iterators.iterator((Object[])values)){
            int key;

            protected PropertyBlock underlyingObjectToObject(Value value) {
                return creator.encodePropertyValue(this.key++, value);
            }
        };
    }
}

