/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;
import org.neo4j.kernel.impl.util.monitoring.SilentProgressReporter;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.recovery.CorruptedLogsTruncator;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.recovery.RecoveryApplier;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.kernel.recovery.RecoveryService;
import org.neo4j.kernel.recovery.RecoveryStartInformation;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class PhysicalLogicalTransactionStoreTest {
    private static final DatabaseHealth DATABASE_HEALTH = (DatabaseHealth)Mockito.mock(DatabaseHealth.class);
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final TestDirectory dir = TestDirectory.testDirectory();
    private File databaseDirectory;
    private Monitors monitors = new Monitors();

    @Before
    public void setup() {
        this.databaseDirectory = this.dir.databaseDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void extractTransactionFromLogFilesSkippingLastLogFileWithoutHeader() throws IOException {
        SimpleTransactionIdStore transactionIdStore = new SimpleTransactionIdStore();
        TransactionMetadataCache positionCache = new TransactionMetadataCache();
        byte[] additionalHeader = new byte[]{1, 2, 5};
        int masterId = 2;
        int authorId = 1;
        long timeStarted = 12345L;
        long latestCommittedTxWhenStarted = 4545L;
        long timeCommitted = 12355L;
        LifeSupport life = new LifeSupport();
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.dir.databaseLayout(), (FileSystemAbstraction)this.fileSystemRule.get()).withTransactionIdStore((TransactionIdStore)transactionIdStore).withLogVersionRepository((LogVersionRepository)Mockito.mock(LogVersionRepository.class)).build();
        life.add((Lifecycle)logFiles);
        life.start();
        try {
            this.addATransactionAndRewind(life, logFiles, positionCache, transactionIdStore, additionalHeader, 2, authorId, 12345L, latestCommittedTxWhenStarted, timeCommitted);
        }
        finally {
            life.shutdown();
        }
        ((DefaultFileSystemAbstraction)this.fileSystemRule.get()).create(logFiles.getLogFileForVersion(logFiles.getHighestLogVersion() + 1L)).close();
        positionCache.clear();
        PhysicalLogicalTransactionStore store = new PhysicalLogicalTransactionStore(logFiles, positionCache, (LogEntryReader)new VersionAwareLogEntryReader(), this.monitors, true);
        this.verifyTransaction(transactionIdStore, positionCache, additionalHeader, 2, authorId, 12345L, latestCommittedTxWhenStarted, timeCommitted, (LogicalTransactionStore)store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldOpenCleanStore() throws Exception {
        SimpleTransactionIdStore transactionIdStore = new SimpleTransactionIdStore();
        TransactionMetadataCache positionCache = new TransactionMetadataCache();
        LifeSupport life = new LifeSupport();
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.dir.databaseLayout(), (FileSystemAbstraction)this.fileSystemRule.get()).withTransactionIdStore((TransactionIdStore)transactionIdStore).withLogVersionRepository((LogVersionRepository)Mockito.mock(LogVersionRepository.class)).build();
        life.add((Lifecycle)logFiles);
        life.add((Lifecycle)new BatchingTransactionAppender(logFiles, LogRotation.NO_ROTATION, positionCache, (TransactionIdStore)transactionIdStore, IdOrderingQueue.BYPASS, DATABASE_HEALTH));
        try {
            life.start();
        }
        finally {
            life.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldOpenAndRecoverExistingData() throws Exception {
        SimpleTransactionIdStore transactionIdStore = new SimpleTransactionIdStore();
        TransactionMetadataCache positionCache = new TransactionMetadataCache();
        byte[] additionalHeader = new byte[]{1, 2, 5};
        int masterId = 2;
        int authorId = 1;
        long timeStarted = 12345L;
        long latestCommittedTxWhenStarted = 4545L;
        long timeCommitted = 12355L;
        LifeSupport life = new LifeSupport();
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.dir.databaseLayout(), (FileSystemAbstraction)this.fileSystemRule.get()).withTransactionIdStore((TransactionIdStore)transactionIdStore).withLogVersionRepository((LogVersionRepository)Mockito.mock(LogVersionRepository.class)).build();
        life.start();
        life.add((Lifecycle)logFiles);
        try {
            this.addATransactionAndRewind(life, logFiles, positionCache, transactionIdStore, additionalHeader, 2, authorId, 12345L, latestCommittedTxWhenStarted, timeCommitted);
        }
        finally {
            life.shutdown();
        }
        life = new LifeSupport();
        life.add((Lifecycle)logFiles);
        final AtomicBoolean recoveryRequired = new AtomicBoolean();
        final FakeRecoveryVisitor visitor = new FakeRecoveryVisitor(additionalHeader, 2, authorId, 12345L, timeCommitted, latestCommittedTxWhenStarted);
        PhysicalLogicalTransactionStore txStore = new PhysicalLogicalTransactionStore(logFiles, positionCache, (LogEntryReader)new VersionAwareLogEntryReader(), this.monitors, true);
        life.add((Lifecycle)new BatchingTransactionAppender(logFiles, LogRotation.NO_ROTATION, positionCache, (TransactionIdStore)transactionIdStore, IdOrderingQueue.BYPASS, DATABASE_HEALTH));
        CorruptedLogsTruncator logPruner = new CorruptedLogsTruncator(this.databaseDirectory, logFiles, this.fileSystemRule.get());
        life.add((Lifecycle)new Recovery(new RecoveryService((LogicalTransactionStore)txStore){
            final /* synthetic */ LogicalTransactionStore val$txStore;
            {
                this.val$txStore = logicalTransactionStore;
            }

            public void startRecovery() {
                recoveryRequired.set(true);
            }

            public RecoveryApplier getRecoveryApplier(TransactionApplicationMode mode) {
                return mode == TransactionApplicationMode.REVERSE_RECOVERY ? (RecoveryApplier)Mockito.mock(RecoveryApplier.class) : visitor;
            }

            public RecoveryStartInformation getRecoveryStartInformation() {
                return new RecoveryStartInformation(LogPosition.start((long)0L), 1L);
            }

            public TransactionCursor getTransactions(LogPosition position) throws IOException {
                return this.val$txStore.getTransactions(position);
            }

            public TransactionCursor getTransactionsInReverseOrder(LogPosition position) throws IOException {
                return this.val$txStore.getTransactionsInReverseOrder(position);
            }

            public void transactionsRecovered(CommittedTransactionRepresentation lastRecoveredTransaction, LogPosition positionAfterLastRecoveredTransaction) {
            }
        }, logPruner, (RecoveryMonitor)Mockito.mock(RecoveryMonitor.class), (ProgressReporter)SilentProgressReporter.INSTANCE, false));
        try {
            life.start();
        }
        finally {
            life.shutdown();
        }
        Assert.assertEquals((long)1L, (long)visitor.getVisitedTransactions());
        Assert.assertTrue((boolean)recoveryRequired.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldExtractMetadataFromExistingTransaction() throws Exception {
        SimpleTransactionIdStore transactionIdStore = new SimpleTransactionIdStore();
        TransactionMetadataCache positionCache = new TransactionMetadataCache();
        byte[] additionalHeader = new byte[]{1, 2, 5};
        int masterId = 2;
        int authorId = 1;
        long timeStarted = 12345L;
        long latestCommittedTxWhenStarted = 4545L;
        long timeCommitted = 12355L;
        LifeSupport life = new LifeSupport();
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.dir.databaseLayout(), (FileSystemAbstraction)this.fileSystemRule.get()).withTransactionIdStore((TransactionIdStore)transactionIdStore).withLogVersionRepository((LogVersionRepository)Mockito.mock(LogVersionRepository.class)).build();
        life.start();
        life.add((Lifecycle)logFiles);
        try {
            this.addATransactionAndRewind(life, logFiles, positionCache, transactionIdStore, additionalHeader, 2, authorId, 12345L, latestCommittedTxWhenStarted, timeCommitted);
        }
        finally {
            life.shutdown();
        }
        life = new LifeSupport();
        life.add((Lifecycle)logFiles);
        PhysicalLogicalTransactionStore store = new PhysicalLogicalTransactionStore(logFiles, positionCache, (LogEntryReader)new VersionAwareLogEntryReader(), this.monitors, true);
        life.start();
        try {
            this.verifyTransaction(transactionIdStore, positionCache, additionalHeader, 2, authorId, 12345L, latestCommittedTxWhenStarted, timeCommitted, (LogicalTransactionStore)store);
        }
        finally {
            life.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldThrowNoSuchTransactionExceptionIfMetadataNotFound() throws Exception {
        LogFiles logFiles = (LogFiles)Mockito.mock(LogFiles.class);
        TransactionMetadataCache cache = new TransactionMetadataCache();
        LifeSupport life = new LifeSupport();
        PhysicalLogicalTransactionStore txStore = new PhysicalLogicalTransactionStore(logFiles, cache, (LogEntryReader)new VersionAwareLogEntryReader(), this.monitors, true);
        try {
            life.start();
            try {
                txStore.getMetadataFor(10L);
                Assert.fail((String)"Should have thrown");
            }
            catch (NoSuchTransactionException noSuchTransactionException) {
                // empty catch block
            }
        }
        finally {
            life.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldThrowNoSuchTransactionExceptionIfLogFileIsMissing() throws Exception {
        LogFile logFile = (LogFile)Mockito.mock(LogFile.class);
        LogFiles logFiles = (LogFiles)Mockito.mock(LogFiles.class);
        Mockito.when((Object)logFiles.getLogFile()).thenReturn((Object)logFile);
        Mockito.when((Object)logFile.getReader((LogPosition)ArgumentMatchers.any(LogPosition.class))).thenThrow(new Throwable[]{new FileNotFoundException()});
        TransactionMetadataCache cache = new TransactionMetadataCache();
        cache.cacheTransactionMetadata(10L, new LogPosition(2L, 130L), 1, 1, 100L, System.currentTimeMillis());
        LifeSupport life = new LifeSupport();
        PhysicalLogicalTransactionStore txStore = new PhysicalLogicalTransactionStore(logFiles, cache, (LogEntryReader)new VersionAwareLogEntryReader(), this.monitors, true);
        try {
            life.start();
            try {
                txStore.getTransactions(10L);
                Assert.fail();
            }
            catch (NoSuchTransactionException noSuchTransactionException) {
                // empty catch block
            }
        }
        finally {
            life.shutdown();
        }
    }

    private void addATransactionAndRewind(LifeSupport life, LogFiles logFiles, TransactionMetadataCache positionCache, TransactionIdStore transactionIdStore, byte[] additionalHeader, int masterId, int authorId, long timeStarted, long latestCommittedTxWhenStarted, long timeCommitted) throws IOException {
        TransactionAppender appender = (TransactionAppender)life.add((Lifecycle)new BatchingTransactionAppender(logFiles, LogRotation.NO_ROTATION, positionCache, transactionIdStore, IdOrderingQueue.BYPASS, DATABASE_HEALTH));
        PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(this.singleCreateNodeCommand());
        transaction.setHeader(additionalHeader, masterId, authorId, timeStarted, latestCommittedTxWhenStarted, timeCommitted, -1);
        appender.append(new TransactionToApply((TransactionRepresentation)transaction), LogAppendEvent.NULL);
    }

    private Collection<StorageCommand> singleCreateNodeCommand() {
        ArrayList<StorageCommand> commands = new ArrayList<StorageCommand>();
        long id = 0L;
        NodeRecord before = new NodeRecord(id);
        NodeRecord after = new NodeRecord(id);
        after.setInUse(true);
        commands.add((StorageCommand)new Command.NodeCommand(before, after));
        return commands;
    }

    private void verifyTransaction(TransactionIdStore transactionIdStore, TransactionMetadataCache positionCache, byte[] additionalHeader, int masterId, int authorId, long timeStarted, long latestCommittedTxWhenStarted, long timeCommitted, LogicalTransactionStore store) throws IOException {
        TransactionMetadataCache.TransactionMetadata expectedMetadata;
        try (TransactionCursor cursor = store.getTransactions(2L);){
            boolean hasNext = cursor.next();
            Assert.assertTrue((boolean)hasNext);
            CommittedTransactionRepresentation tx = (CommittedTransactionRepresentation)cursor.get();
            TransactionRepresentation transaction = tx.getTransactionRepresentation();
            Assert.assertArrayEquals((byte[])additionalHeader, (byte[])transaction.additionalHeader());
            Assert.assertEquals((long)masterId, (long)transaction.getMasterId());
            Assert.assertEquals((long)authorId, (long)transaction.getAuthorId());
            Assert.assertEquals((long)timeStarted, (long)transaction.getTimeStarted());
            Assert.assertEquals((long)timeCommitted, (long)transaction.getTimeCommitted());
            Assert.assertEquals((long)latestCommittedTxWhenStarted, (long)transaction.getLatestCommittedTxWhenStarted());
            expectedMetadata = new TransactionMetadataCache.TransactionMetadata(masterId, authorId, tx.getStartEntry().getStartPosition(), tx.getStartEntry().checksum(), timeCommitted);
        }
        positionCache.clear();
        TransactionMetadataCache.TransactionMetadata actualMetadata = store.getMetadataFor(transactionIdStore.getLastCommittedTransactionId());
        Assert.assertEquals((Object)expectedMetadata, (Object)actualMetadata);
    }

    private static class FakeRecoveryVisitor
    implements RecoveryApplier {
        private final byte[] additionalHeader;
        private final int masterId;
        private final int authorId;
        private final long timeStarted;
        private final long timeCommitted;
        private final long latestCommittedTxWhenStarted;
        private int visitedTransactions;

        FakeRecoveryVisitor(byte[] additionalHeader, int masterId, int authorId, long timeStarted, long timeCommitted, long latestCommittedTxWhenStarted) {
            this.additionalHeader = additionalHeader;
            this.masterId = masterId;
            this.authorId = authorId;
            this.timeStarted = timeStarted;
            this.timeCommitted = timeCommitted;
            this.latestCommittedTxWhenStarted = latestCommittedTxWhenStarted;
        }

        public boolean visit(CommittedTransactionRepresentation tx) {
            TransactionRepresentation transaction = tx.getTransactionRepresentation();
            Assert.assertArrayEquals((byte[])this.additionalHeader, (byte[])transaction.additionalHeader());
            Assert.assertEquals((long)this.masterId, (long)transaction.getMasterId());
            Assert.assertEquals((long)this.authorId, (long)transaction.getAuthorId());
            Assert.assertEquals((long)this.timeStarted, (long)transaction.getTimeStarted());
            Assert.assertEquals((long)this.timeCommitted, (long)transaction.getTimeCommitted());
            Assert.assertEquals((long)this.latestCommittedTxWhenStarted, (long)transaction.getLatestCommittedTxWhenStarted());
            ++this.visitedTransactions;
            return false;
        }

        int getVisitedTransactions() {
            return this.visitedTransactions;
        }

        public void close() {
        }
    }
}

