/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.Flushable;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerImpl;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.kernel.impl.transaction.tracing.CheckPointTracer;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.test.ThreadTestUtils;
import org.neo4j.util.concurrent.BinaryLatch;

public class CheckPointerImplTest {
    private static final SimpleTriggerInfo INFO = new SimpleTriggerInfo("test");
    private final TransactionIdStore txIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
    private final CheckPointThreshold threshold = (CheckPointThreshold)Mockito.mock(CheckPointThreshold.class);
    private final StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
    private final LogPruning logPruning = (LogPruning)Mockito.mock(LogPruning.class);
    private final TransactionAppender appender = (TransactionAppender)Mockito.mock(TransactionAppender.class);
    private final DatabaseHealth health = (DatabaseHealth)Mockito.mock(DatabaseHealth.class);
    private final CheckPointTracer tracer = (CheckPointTracer)Mockito.mock(CheckPointTracer.class, (Answer)Mockito.RETURNS_MOCKS);
    private IOLimiter limiter = (IOLimiter)Mockito.mock(IOLimiter.class);
    private final long initialTransactionId = 2L;
    private final long transactionId = 42L;
    private final LogPosition logPosition = new LogPosition(16L, 233L);

    @Test
    public void shouldNotFlushIfItIsNotNeeded() throws Throwable {
        CheckPointerImpl checkPointing = this.checkPointer();
        Mockito.when((Object)this.threshold.isCheckPointingNeeded(ArgumentMatchers.anyLong(), (Consumer)ArgumentMatchers.any(TriggerInfo.class))).thenReturn((Object)false);
        checkPointing.start();
        long txId = checkPointing.checkPointIfNeeded((TriggerInfo)INFO);
        Assert.assertEquals((long)-1L, (long)txId);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.storageEngine});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.tracer});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.appender});
    }

    @Test
    public void shouldFlushIfItIsNeeded() throws Throwable {
        CheckPointerImpl checkPointing = this.checkPointer();
        Mockito.when((Object)this.threshold.isCheckPointingNeeded(ArgumentMatchers.anyLong(), (Consumer)ArgumentMatchers.eq((Object)INFO))).thenReturn((Object)true, (Object[])new Boolean[]{false});
        this.mockTxIdStore();
        checkPointing.start();
        long txId = checkPointing.checkPointIfNeeded((TriggerInfo)INFO);
        Assert.assertEquals((long)42L, (long)txId);
        ((StorageEngine)Mockito.verify((Object)this.storageEngine, (VerificationMode)Mockito.times((int)1))).flushAndForce(this.limiter);
        ((DatabaseHealth)Mockito.verify((Object)this.health, (VerificationMode)Mockito.times((int)2))).assertHealthy(IOException.class);
        ((TransactionAppender)Mockito.verify((Object)this.appender, (VerificationMode)Mockito.times((int)1))).checkPoint((LogPosition)ArgumentMatchers.eq((Object)this.logPosition), (LogCheckPointEvent)ArgumentMatchers.any(LogCheckPointEvent.class));
        ((CheckPointThreshold)Mockito.verify((Object)this.threshold, (VerificationMode)Mockito.times((int)1))).initialize(2L);
        ((CheckPointThreshold)Mockito.verify((Object)this.threshold, (VerificationMode)Mockito.times((int)1))).checkPointHappened(42L);
        ((CheckPointThreshold)Mockito.verify((Object)this.threshold, (VerificationMode)Mockito.times((int)1))).isCheckPointingNeeded(42L, (Consumer)INFO);
        ((LogPruning)Mockito.verify((Object)this.logPruning, (VerificationMode)Mockito.times((int)1))).pruneLogs(this.logPosition.getLogVersion());
        ((CheckPointTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).beginCheckPoint();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.storageEngine, this.health, this.appender, this.threshold, this.tracer});
    }

    @Test
    public void shouldForceCheckPointAlways() throws Throwable {
        CheckPointerImpl checkPointing = this.checkPointer();
        Mockito.when((Object)this.threshold.isCheckPointingNeeded(ArgumentMatchers.anyLong(), (Consumer)ArgumentMatchers.eq((Object)INFO))).thenReturn((Object)false);
        this.mockTxIdStore();
        checkPointing.start();
        long txId = checkPointing.forceCheckPoint((TriggerInfo)INFO);
        Assert.assertEquals((long)42L, (long)txId);
        ((StorageEngine)Mockito.verify((Object)this.storageEngine, (VerificationMode)Mockito.times((int)1))).flushAndForce(this.limiter);
        ((DatabaseHealth)Mockito.verify((Object)this.health, (VerificationMode)Mockito.times((int)2))).assertHealthy(IOException.class);
        ((TransactionAppender)Mockito.verify((Object)this.appender, (VerificationMode)Mockito.times((int)1))).checkPoint((LogPosition)ArgumentMatchers.eq((Object)this.logPosition), (LogCheckPointEvent)ArgumentMatchers.any(LogCheckPointEvent.class));
        ((CheckPointThreshold)Mockito.verify((Object)this.threshold, (VerificationMode)Mockito.times((int)1))).initialize(2L);
        ((CheckPointThreshold)Mockito.verify((Object)this.threshold, (VerificationMode)Mockito.times((int)1))).checkPointHappened(42L);
        ((CheckPointThreshold)Mockito.verify((Object)this.threshold, (VerificationMode)Mockito.never())).isCheckPointingNeeded(42L, (Consumer)INFO);
        ((LogPruning)Mockito.verify((Object)this.logPruning, (VerificationMode)Mockito.times((int)1))).pruneLogs(this.logPosition.getLogVersion());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.tracer});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.storageEngine, this.health, this.appender, this.threshold, this.tracer});
    }

    @Test
    public void shouldCheckPointAlwaysWhenThereIsNoRunningCheckPoint() throws Throwable {
        CheckPointerImpl checkPointing = this.checkPointer();
        Mockito.when((Object)this.threshold.isCheckPointingNeeded(ArgumentMatchers.anyLong(), (Consumer)ArgumentMatchers.eq((Object)INFO))).thenReturn((Object)false);
        this.mockTxIdStore();
        checkPointing.start();
        long txId = checkPointing.tryCheckPoint((TriggerInfo)INFO);
        Assert.assertEquals((long)42L, (long)txId);
        ((StorageEngine)Mockito.verify((Object)this.storageEngine, (VerificationMode)Mockito.times((int)1))).flushAndForce(this.limiter);
        ((DatabaseHealth)Mockito.verify((Object)this.health, (VerificationMode)Mockito.times((int)2))).assertHealthy(IOException.class);
        ((TransactionAppender)Mockito.verify((Object)this.appender, (VerificationMode)Mockito.times((int)1))).checkPoint((LogPosition)ArgumentMatchers.eq((Object)this.logPosition), (LogCheckPointEvent)ArgumentMatchers.any(LogCheckPointEvent.class));
        ((CheckPointThreshold)Mockito.verify((Object)this.threshold, (VerificationMode)Mockito.times((int)1))).initialize(2L);
        ((CheckPointThreshold)Mockito.verify((Object)this.threshold, (VerificationMode)Mockito.times((int)1))).checkPointHappened(42L);
        ((CheckPointThreshold)Mockito.verify((Object)this.threshold, (VerificationMode)Mockito.never())).isCheckPointingNeeded(42L, (Consumer)INFO);
        ((LogPruning)Mockito.verify((Object)this.logPruning, (VerificationMode)Mockito.times((int)1))).pruneLogs(this.logPosition.getLogVersion());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.tracer});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.storageEngine, this.health, this.appender, this.threshold, this.tracer});
    }

    @Test
    public void forceCheckPointShouldWaitTheCurrentCheckPointingToCompleteBeforeRunning() throws Throwable {
        ReentrantLock lock = new ReentrantLock();
        Lock spyLock = (Lock)Mockito.spy((Object)lock);
        ((Lock)Mockito.doAnswer(invocation -> {
            ((TransactionAppender)Mockito.verify((Object)this.appender)).checkPoint((LogPosition)ArgumentMatchers.any(LogPosition.class), (LogCheckPointEvent)ArgumentMatchers.any(LogCheckPointEvent.class));
            Mockito.reset((Object[])new TransactionAppender[]{this.appender});
            invocation.callRealMethod();
            return null;
        }).when((Object)spyLock)).unlock();
        CheckPointerImpl checkPointing = this.checkPointer(this.mutex(spyLock));
        this.mockTxIdStore();
        CountDownLatch startSignal = new CountDownLatch(2);
        CountDownLatch completed = new CountDownLatch(2);
        checkPointing.start();
        CheckPointerThread checkPointerThread = new CheckPointerThread(checkPointing, startSignal, completed);
        Thread forceCheckPointThread = new Thread(() -> {
            try {
                startSignal.countDown();
                startSignal.await();
                checkPointing.forceCheckPoint((TriggerInfo)INFO);
                completed.countDown();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
        checkPointerThread.start();
        forceCheckPointThread.start();
        completed.await();
        ((Lock)Mockito.verify((Object)spyLock, (VerificationMode)Mockito.times((int)2))).lock();
        ((Lock)Mockito.verify((Object)spyLock, (VerificationMode)Mockito.times((int)2))).unlock();
    }

    private StoreCopyCheckPointMutex mutex(final Lock lock) {
        return new StoreCopyCheckPointMutex(new ReadWriteLock(){

            @Override
            public Lock writeLock() {
                return lock;
            }

            @Override
            public Lock readLock() {
                throw new UnsupportedOperationException();
            }
        });
    }

    @Test
    public void tryCheckPointShouldWaitTheCurrentCheckPointingToCompleteNoRunCheckPointButUseTheTxIdOfTheEarlierRun() throws Throwable {
        Lock lock = (Lock)Mockito.mock(Lock.class);
        CheckPointerImpl checkPointing = this.checkPointer(this.mutex(lock));
        this.mockTxIdStore();
        checkPointing.forceCheckPoint((TriggerInfo)INFO);
        ((TransactionAppender)Mockito.verify((Object)this.appender)).checkPoint((LogPosition)ArgumentMatchers.eq((Object)this.logPosition), (LogCheckPointEvent)ArgumentMatchers.any(LogCheckPointEvent.class));
        Mockito.reset((Object[])new TransactionAppender[]{this.appender});
        checkPointing.tryCheckPoint((TriggerInfo)INFO);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.appender});
    }

    @Test
    public void mustUseIoLimiterFromFlushing() throws Throwable {
        this.limiter = new IOLimiter(){

            public long maybeLimitIO(long previousStamp, int recentlyCompletedIOs, Flushable flushable) {
                return 42L;
            }

            public boolean isLimited() {
                return true;
            }
        };
        Mockito.when((Object)this.threshold.isCheckPointingNeeded(ArgumentMatchers.anyLong(), (Consumer)ArgumentMatchers.eq((Object)INFO))).thenReturn((Object)true, (Object[])new Boolean[]{false});
        this.mockTxIdStore();
        CheckPointerImpl checkPointing = this.checkPointer();
        checkPointing.start();
        checkPointing.checkPointIfNeeded((TriggerInfo)INFO);
        ((StorageEngine)Mockito.verify((Object)this.storageEngine)).flushAndForce(this.limiter);
    }

    @Test
    public void mustFlushAsFastAsPossibleDuringForceCheckPoint() throws Exception {
        final AtomicBoolean doneDisablingLimits = new AtomicBoolean();
        this.limiter = new IOLimiter(){

            public long maybeLimitIO(long previousStamp, int recentlyCompletedIOs, Flushable flushable) {
                return 0L;
            }

            public void enableLimit() {
                doneDisablingLimits.set(true);
            }

            public boolean isLimited() {
                return doneDisablingLimits.get();
            }
        };
        this.mockTxIdStore();
        CheckPointerImpl checkPointer = this.checkPointer();
        checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
        Assert.assertTrue((boolean)doneDisablingLimits.get());
    }

    @Test
    public void mustFlushAsFastAsPossibleDuringTryCheckPoint() throws Exception {
        final AtomicBoolean doneDisablingLimits = new AtomicBoolean();
        this.limiter = new IOLimiter(){

            public long maybeLimitIO(long previousStamp, int recentlyCompletedIOs, Flushable flushable) {
                return 0L;
            }

            public void enableLimit() {
                doneDisablingLimits.set(true);
            }

            public boolean isLimited() {
                return doneDisablingLimits.get();
            }
        };
        this.mockTxIdStore();
        CheckPointerImpl checkPointer = this.checkPointer();
        checkPointer.tryCheckPoint((TriggerInfo)INFO);
        Assert.assertTrue((boolean)doneDisablingLimits.get());
    }

    private void verifyAsyncActionCausesConcurrentFlushingRush(ThrowingConsumer<CheckPointerImpl, IOException> asyncAction) throws Exception {
        final AtomicLong limitDisableCounter = new AtomicLong();
        AtomicLong observedRushCount = new AtomicLong();
        BinaryLatch backgroundCheckPointStartedLatch = new BinaryLatch();
        final BinaryLatch forceCheckPointStartLatch = new BinaryLatch();
        this.limiter = new IOLimiter(){

            public long maybeLimitIO(long previousStamp, int recentlyCompletedIOs, Flushable flushable) {
                return 0L;
            }

            public void disableLimit() {
                limitDisableCounter.getAndIncrement();
                forceCheckPointStartLatch.release();
            }

            public void enableLimit() {
                limitDisableCounter.getAndDecrement();
            }

            public boolean isLimited() {
                return limitDisableCounter.get() != 0L;
            }
        };
        this.mockTxIdStore();
        CheckPointerImpl checkPointer = this.checkPointer();
        ((StorageEngine)Mockito.doAnswer(invocation -> {
            backgroundCheckPointStartedLatch.release();
            forceCheckPointStartLatch.await();
            long newValue = limitDisableCounter.get();
            observedRushCount.set(newValue);
            return null;
        }).when((Object)this.storageEngine)).flushAndForce(this.limiter);
        Future forceCheckPointer = ThreadTestUtils.forkFuture(() -> {
            backgroundCheckPointStartedLatch.await();
            asyncAction.accept((Object)checkPointer);
            return null;
        });
        Mockito.when((Object)this.threshold.isCheckPointingNeeded(ArgumentMatchers.anyLong(), (Consumer)ArgumentMatchers.eq((Object)INFO))).thenReturn((Object)true);
        checkPointer.checkPointIfNeeded((TriggerInfo)INFO);
        forceCheckPointer.get();
        Assert.assertThat((Object)observedRushCount.get(), (Matcher)Matchers.is((Object)1L));
    }

    @Test(timeout=5000L)
    public void mustRequestFastestPossibleFlushWhenForceCheckPointIsCalledDuringBackgroundCheckPoint() throws Exception {
        this.verifyAsyncActionCausesConcurrentFlushingRush((ThrowingConsumer<CheckPointerImpl, IOException>)((ThrowingConsumer)checkPointer -> checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("async"))));
    }

    @Test(timeout=5000L)
    public void mustRequestFastestPossibleFlushWhenTryCheckPointIsCalledDuringBackgroundCheckPoint() throws Exception {
        this.verifyAsyncActionCausesConcurrentFlushingRush((ThrowingConsumer<CheckPointerImpl, IOException>)((ThrowingConsumer)checkPointer -> checkPointer.tryCheckPoint((TriggerInfo)new SimpleTriggerInfo("async"))));
    }

    private CheckPointerImpl checkPointer(StoreCopyCheckPointMutex mutex) {
        return new CheckPointerImpl(this.txIdStore, this.threshold, this.storageEngine, this.logPruning, this.appender, this.health, (LogProvider)NullLogProvider.getInstance(), this.tracer, this.limiter, mutex);
    }

    private CheckPointerImpl checkPointer() {
        return this.checkPointer(new StoreCopyCheckPointMutex());
    }

    private void mockTxIdStore() {
        long[] triggerCommittedTransaction = new long[]{42L, this.logPosition.getLogVersion(), this.logPosition.getByteOffset()};
        Mockito.when((Object)this.txIdStore.getLastClosedTransaction()).thenReturn((Object)triggerCommittedTransaction);
        Mockito.when((Object)this.txIdStore.getLastClosedTransactionId()).thenReturn((Object)2L, (Object[])new Long[]{42L, 42L});
    }

    private static class CheckPointerThread
    extends Thread {
        private final CheckPointerImpl checkPointing;
        private final CountDownLatch startSignal;
        private final CountDownLatch completed;

        CheckPointerThread(CheckPointerImpl checkPointing, CountDownLatch startSignal, CountDownLatch completed) {
            this.checkPointing = checkPointing;
            this.startSignal = startSignal;
            this.completed = completed;
        }

        @Override
        public void run() {
            try {
                this.startSignal.countDown();
                this.startSignal.await();
                this.checkPointing.forceCheckPoint((TriggerInfo)INFO);
                this.completed.countDown();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

