/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.watcher;

import org.junit.Test;
import org.neo4j.kernel.impl.util.watcher.DefaultFileDeletionEventListener;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;

public class DefaultFileDeletionEventListenerTest {
    @Test
    public void notificationInLogAboutFileDeletion() {
        AssertableLogProvider internalLogProvider = new AssertableLogProvider(false);
        DefaultFileDeletionEventListener listener = this.buildListener(internalLogProvider);
        listener.fileDeleted("testFile.db");
        listener.fileDeleted("anotherDirectory");
        internalLogProvider.assertContainsMessageContaining("'testFile.db' which belongs to the store was deleted while database was running.");
        internalLogProvider.assertContainsMessageContaining("'anotherDirectory' which belongs to the store was deleted while database was running.");
    }

    @Test
    public void noNotificationForTransactionLogs() {
        AssertableLogProvider internalLogProvider = new AssertableLogProvider(false);
        DefaultFileDeletionEventListener listener = this.buildListener(internalLogProvider);
        listener.fileDeleted("neostore.transaction.db.0");
        listener.fileDeleted("neostore.transaction.db.1");
        internalLogProvider.assertNoLoggingOccurred();
    }

    private DefaultFileDeletionEventListener buildListener(AssertableLogProvider internalLogProvider) {
        SimpleLogService logService = new SimpleLogService((LogProvider)NullLogProvider.getInstance(), (LogProvider)internalLogProvider);
        return new DefaultFileDeletionEventListener((LogService)logService, filename -> filename.startsWith("neostore.transaction.db"));
    }
}

