/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.recovery.CorruptedLogsTruncator;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.test.rule.fs.FileSystemRule;

public class CorruptedLogsTruncatorTest {
    private static final int SINGLE_LOG_FILE_SIZE = 25;
    private static final int TOTAL_NUMBER_OF_LOG_FILES = 12;
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final FileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final LifeRule life = new LifeRule();
    private File databaseDirectory;
    private LogFiles logFiles;
    private CorruptedLogsTruncator logPruner;

    @Before
    public void setUp() throws Exception {
        this.databaseDirectory = this.testDirectory.databaseDir();
        SimpleLogVersionRepository logVersionRepository = new SimpleLogVersionRepository();
        SimpleTransactionIdStore transactionIdStore = new SimpleTransactionIdStore();
        this.logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((File)this.databaseDirectory, (FileSystemAbstraction)this.fileSystemRule).withRotationThreshold(25L).withLogVersionRepository((LogVersionRepository)logVersionRepository).withTransactionIdStore((TransactionIdStore)transactionIdStore).build();
        this.life.add((Lifecycle)this.logFiles);
        this.logPruner = new CorruptedLogsTruncator(this.databaseDirectory, this.logFiles, (FileSystemAbstraction)this.fileSystemRule);
    }

    @Test
    public void doNotPruneEmptyLogs() throws IOException {
        this.logPruner.truncate(LogPosition.start((long)0L));
        Assert.assertTrue((boolean)FileUtils.isEmptyDirectory((File)this.databaseDirectory));
    }

    @Test
    public void doNotPruneNonCorruptedLogs() throws IOException {
        this.life.start();
        this.generateTransactionLogFiles(this.logFiles);
        long highestLogVersion = this.logFiles.getHighestLogVersion();
        long fileSizeBeforePrune = this.logFiles.getHighestLogFile().length();
        LogPosition endOfLogsPosition = new LogPosition(highestLogVersion, fileSizeBeforePrune);
        Assert.assertEquals((long)11L, (long)highestLogVersion);
        this.logPruner.truncate(endOfLogsPosition);
        Assert.assertEquals((long)12L, (long)this.logFiles.logFiles().length);
        Assert.assertEquals((long)fileSizeBeforePrune, (long)this.logFiles.getHighestLogFile().length());
        Assert.assertTrue((boolean)ArrayUtil.isEmpty((Object[])this.databaseDirectory.listFiles(File::isDirectory)));
    }

    @Test
    public void pruneAndArchiveLastLog() throws IOException {
        this.life.start();
        this.generateTransactionLogFiles(this.logFiles);
        long highestLogVersion = this.logFiles.getHighestLogVersion();
        File highestLogFile = this.logFiles.getHighestLogFile();
        long fileSizeBeforePrune = highestLogFile.length();
        int bytesToPrune = 5;
        long byteOffset = fileSizeBeforePrune - (long)bytesToPrune;
        LogPosition prunePosition = new LogPosition(highestLogVersion, byteOffset);
        this.logPruner.truncate(prunePosition);
        Assert.assertEquals((long)12L, (long)this.logFiles.logFiles().length);
        Assert.assertEquals((long)byteOffset, (long)highestLogFile.length());
        File corruptedLogsDirectory = new File(this.databaseDirectory, "corrupted-neostore.transaction.db");
        Assert.assertTrue((boolean)corruptedLogsDirectory.exists());
        File[] files = corruptedLogsDirectory.listFiles();
        Assert.assertEquals((long)1L, (long)files.length);
        File corruptedLogsArchive = files[0];
        this.checkArchiveName(highestLogVersion, byteOffset, corruptedLogsArchive);
        try (ZipFile zipFile = new ZipFile(corruptedLogsArchive);){
            Assert.assertEquals((long)1L, (long)zipFile.size());
            this.checkEntryNameAndSize(zipFile, highestLogFile.getName(), bytesToPrune);
        }
    }

    @Test
    public void pruneAndArchiveMultipleLogs() throws IOException {
        this.life.start();
        this.generateTransactionLogFiles(this.logFiles);
        long highestCorrectLogFileIndex = 5L;
        File highestCorrectLogFile = this.logFiles.getLogFileForVersion(highestCorrectLogFileIndex);
        long fileSizeBeforePrune = highestCorrectLogFile.length();
        int bytesToPrune = 7;
        long byteOffset = fileSizeBeforePrune - (long)bytesToPrune;
        LogPosition prunePosition = new LogPosition(highestCorrectLogFileIndex, byteOffset);
        this.life.shutdown();
        this.logPruner.truncate(prunePosition);
        this.life.start();
        Assert.assertEquals((long)6L, (long)this.logFiles.logFiles().length);
        Assert.assertEquals((long)byteOffset, (long)highestCorrectLogFile.length());
        File corruptedLogsDirectory = new File(this.databaseDirectory, "corrupted-neostore.transaction.db");
        Assert.assertTrue((boolean)corruptedLogsDirectory.exists());
        File[] files = corruptedLogsDirectory.listFiles();
        Assert.assertEquals((long)1L, (long)files.length);
        File corruptedLogsArchive = files[0];
        this.checkArchiveName(highestCorrectLogFileIndex, byteOffset, corruptedLogsArchive);
        try (ZipFile zipFile = new ZipFile(corruptedLogsArchive);){
            Assert.assertEquals((long)7L, (long)zipFile.size());
            this.checkEntryNameAndSize(zipFile, highestCorrectLogFile.getName(), bytesToPrune);
            long nextLogFileIndex = highestCorrectLogFileIndex + 1L;
            int lastFileIndex = 11;
            for (long index = nextLogFileIndex; index < (long)lastFileIndex; ++index) {
                this.checkEntryNameAndSize(zipFile, "neostore.transaction.db." + index, 25);
            }
            this.checkEntryNameAndSize(zipFile, "neostore.transaction.db." + lastFileIndex, 24);
        }
    }

    private void checkEntryNameAndSize(ZipFile zipFile, String entryName, int expectedSize) throws IOException {
        ZipEntry entry = zipFile.getEntry(entryName);
        InputStream inputStream = zipFile.getInputStream(entry);
        int entryBytes = 0;
        while (inputStream.read() >= 0) {
            ++entryBytes;
        }
        Assert.assertEquals((long)expectedSize, (long)entryBytes);
    }

    private void checkArchiveName(long highestLogVersion, long byteOffset, File corruptedLogsArchive) {
        String name = corruptedLogsArchive.getName();
        Assert.assertTrue((boolean)name.startsWith("corrupted-neostore.transaction.db-" + highestLogVersion + "-" + byteOffset));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)name, (String)"zip"));
    }

    private void generateTransactionLogFiles(LogFiles logFiles) throws IOException {
        LogFile logFile = logFiles.getLogFile();
        FlushablePositionAwareChannel writer = logFile.getWriter();
        for (byte i = 0; i < 107; i = (byte)(i + 1)) {
            writer.put(i);
            writer.prepareForFlush();
            if (!logFile.rotationNeeded()) continue;
            logFile.rotate();
        }
    }
}

