/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.LonelyProcessingStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class LonelyProcessingStepTest {
    @ClassRule
    public static SuppressOutput mute = SuppressOutput.suppressAll();

    @Test(timeout=10000L)
    public void issuePanicBeforeCompletionOnError() throws InterruptedException {
        ArrayList stepsPipeline = new ArrayList();
        FaultyLonelyProcessingStepTest faultyStep = new FaultyLonelyProcessingStepTest(stepsPipeline);
        stepsPipeline.add((Step<?>)faultyStep);
        faultyStep.receive(1L, null);
        faultyStep.awaitCompleted();
        Assert.assertTrue((boolean)faultyStep.endOfUpstreamCalled);
        Assert.assertTrue((String)"On upstream end step should be already on panic in case of exception", (boolean)faultyStep.isPanicOnEndUpstream());
        Assert.assertTrue((boolean)faultyStep.isPanic());
        Assert.assertFalse((boolean)faultyStep.stillWorking());
        Assert.assertTrue((boolean)faultyStep.isCompleted());
    }

    private class FaultyLonelyProcessingStepTest
    extends LonelyProcessingStep {
        private volatile boolean endOfUpstreamCalled;
        private volatile boolean panicOnEndUpstream;

        FaultyLonelyProcessingStepTest(List<Step<?>> pipeLine) {
            super((StageControl)new StageExecution("Faulty", null, Configuration.DEFAULT, pipeLine, 0), "Faulty", Configuration.DEFAULT, new StatsProvider[0]);
        }

        protected void process() {
            throw new RuntimeException("Process exception");
        }

        public void endOfUpstream() {
            this.endOfUpstreamCalled = true;
            this.panicOnEndUpstream = this.isPanic();
            super.endOfUpstream();
        }

        private boolean isPanicOnEndUpstream() {
            return this.panicOnEndUpstream;
        }
    }
}

