/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema.constraints;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.internal.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.NodeExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.UniquenessConstraintDescriptor;

public class ConstraintDescriptorFactoryTest {
    private static final int LABEL_ID = 0;
    private static final int REL_TYPE_ID = 0;

    @Test
    public void shouldCreateExistsConstraintDescriptors() {
        NodeExistenceConstraintDescriptor desc = ConstraintDescriptorFactory.existsForLabel((int)0, (int[])new int[]{1});
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)ConstraintDescriptor.Type.EXISTS));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1})));
        desc = ConstraintDescriptorFactory.existsForRelType((int)0, (int[])new int[]{1});
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)ConstraintDescriptor.Type.EXISTS));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptorFactory.forRelType((int)0, (int[])new int[]{1})));
    }

    @Test
    public void shouldCreateUniqueConstraintDescriptors() {
        UniquenessConstraintDescriptor desc = ConstraintDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{1});
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)ConstraintDescriptor.Type.UNIQUE));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1})));
    }

    @Test
    public void shouldCreateNodeKeyConstraintDescriptors() {
        NodeKeyConstraintDescriptor desc = ConstraintDescriptorFactory.nodeKeyForLabel((int)0, (int[])new int[]{1});
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)ConstraintDescriptor.Type.UNIQUE_EXISTS));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1})));
    }

    @Test
    public void shouldCreateConstraintDescriptorsFromSchema() {
        UniquenessConstraintDescriptor desc = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1}));
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)ConstraintDescriptor.Type.UNIQUE));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1})));
        desc = ConstraintDescriptorFactory.nodeKeyForSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1}));
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)ConstraintDescriptor.Type.UNIQUE_EXISTS));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1})));
        desc = ConstraintDescriptorFactory.existsForSchema((RelationTypeSchemaDescriptor)SchemaDescriptorFactory.forRelType((int)0, (int[])new int[]{1}));
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)ConstraintDescriptor.Type.EXISTS));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptorFactory.forRelType((int)0, (int[])new int[]{1})));
    }

    @Test
    public void shouldCreateEqualDescriptors() {
        UniquenessConstraintDescriptor desc1 = ConstraintDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{1});
        UniquenessConstraintDescriptor desc2 = ConstraintDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{1});
        SchemaTestUtil.assertEquality(desc1, desc2);
        desc1 = ConstraintDescriptorFactory.existsForLabel((int)0, (int[])new int[]{1});
        desc2 = ConstraintDescriptorFactory.existsForLabel((int)0, (int[])new int[]{1});
        SchemaTestUtil.assertEquality(desc1, desc2);
        desc1 = ConstraintDescriptorFactory.existsForRelType((int)0, (int[])new int[]{1});
        desc2 = ConstraintDescriptorFactory.existsForRelType((int)0, (int[])new int[]{1});
        SchemaTestUtil.assertEquality(desc1, desc2);
    }

    @Test
    public void shouldGiveNiceUserDescriptions() {
        MatcherAssert.assertThat((Object)ConstraintDescriptorFactory.existsForLabel((int)1, (int[])new int[]{2}).userDescription(SchemaTestUtil.simpleNameLookup), (Matcher)Matchers.equalTo((Object)"Constraint( EXISTS, :Label1(property2) )"));
        MatcherAssert.assertThat((Object)ConstraintDescriptorFactory.existsForRelType((int)1, (int[])new int[]{3}).userDescription(SchemaTestUtil.simpleNameLookup), (Matcher)Matchers.equalTo((Object)"Constraint( EXISTS, -[:RelType1(property3)]- )"));
        MatcherAssert.assertThat((Object)ConstraintDescriptorFactory.uniqueForLabel((int)2, (int[])new int[]{4}).userDescription(SchemaTestUtil.simpleNameLookup), (Matcher)Matchers.equalTo((Object)"Constraint( UNIQUE, :Label2(property4) )"));
    }
}

