/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import inet.ipaddr.IPAddressString;
import java.io.File;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Settings;

class SettingsTest {
    private static BiFunction<File, Function<String, String>, File> isFile = (path, settings) -> {
        if (path.exists() && !path.isFile()) {
            throw new IllegalArgumentException(String.format("%s must point to a file, not a directory", path.toString()));
        }
        return path;
    };

    SettingsTest() {
    }

    @Test
    void parsesAbsolutePaths() {
        File absolutePath = new File("some/path").getAbsoluteFile();
        File thePath = (File)Settings.PATH.apply(absolutePath.toString());
        Assertions.assertEquals((Object)absolutePath, (Object)thePath);
    }

    @Test
    void doesntAllowRelativePaths() {
        File relativePath = new File("some/path");
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            File cfr_ignored_0 = (File)Settings.PATH.apply(relativePath.toString());
        });
    }

    @Test
    void pathSettingsProvideDefaultValues() {
        File theDefault = new File("/some/path").getAbsoluteFile();
        Setting setting = Settings.pathSetting((String)"some.setting", (String)theDefault.getAbsolutePath());
        MatcherAssert.assertThat((Object)Config.defaults().get(setting), (Matcher)Matchers.is((Object)theDefault));
    }

    @Test
    void pathSettingsAreNullIfThereIsNoValueAndNoDefault() {
        Setting setting = Settings.pathSetting((String)"some.setting", (String)Settings.NO_DEFAULT);
        MatcherAssert.assertThat((Object)Config.defaults().get(setting), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    void shouldHaveAUsefulToStringWhichIsUsedAsTheValidValuesInDocumentation() {
        MatcherAssert.assertThat((Object)Settings.pathSetting((String)"", (String)Settings.NO_DEFAULT).toString(), (Matcher)Matchers.containsString((String)"A filesystem path"));
    }

    @Test
    void testInteger() {
        Setting setting = Settings.setting((String)"foo", (Function)Settings.INTEGER, (String)"3");
        MatcherAssert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "4"}))), (Matcher)CoreMatchers.equalTo((Object)4));
        Assertions.assertThrows(InvalidSettingException.class, () -> {
            Integer cfr_ignored_0 = (Integer)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "bar"})));
        });
    }

    @Test
    void testList() {
        Setting setting = Settings.setting((String)"foo", (Function)Settings.list((String)",", (Function)Settings.INTEGER), (String)"1,2,3,4");
        MatcherAssert.assertThat((Object)((List)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])))).toString(), (Matcher)CoreMatchers.equalTo((Object)"[1, 2, 3, 4]"));
        Setting setting2 = Settings.setting((String)"foo", (Function)Settings.list((String)",", (Function)Settings.INTEGER), (String)"1,2,3,4,");
        MatcherAssert.assertThat((Object)((List)setting2.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])))).toString(), (Matcher)CoreMatchers.equalTo((Object)"[1, 2, 3, 4]"));
        Setting setting3 = Settings.setting((String)"foo", (Function)Settings.list((String)",", (Function)Settings.INTEGER), (String)"");
        MatcherAssert.assertThat((Object)((List)setting3.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])))).toString(), (Matcher)CoreMatchers.equalTo((Object)"[]"));
        Setting setting4 = Settings.setting((String)"foo", (Function)Settings.list((String)",", (Function)Settings.INTEGER), (String)"1,    2,3, 4,   5  ");
        MatcherAssert.assertThat((Object)((List)setting4.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])))).toString(), (Matcher)CoreMatchers.equalTo((Object)"[1, 2, 3, 4, 5]"));
        Setting setting5 = Settings.setting((String)"foo", (Function)Settings.list((String)",", (Function)Settings.INTEGER), (String)"1,    2,3, 4,   ");
        MatcherAssert.assertThat((Object)((List)setting5.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])))).toString(), (Matcher)CoreMatchers.equalTo((Object)"[1, 2, 3, 4]"));
    }

    @Test
    void testStringList() {
        Setting setting1 = Settings.setting((String)"apa", (Function)Settings.STRING_LIST, (String)"foo,bar,baz");
        Assertions.assertEquals(Arrays.asList("foo", "bar", "baz"), (Object)setting1.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0]))));
        Setting setting2 = Settings.setting((String)"apa", (Function)Settings.STRING_LIST, (String)"foo,  bar, BAZ   ");
        Assertions.assertEquals(Arrays.asList("foo", "bar", "BAZ"), (Object)setting2.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0]))));
        Setting setting3 = Settings.setting((String)"apa", (Function)Settings.STRING_LIST, (String)"");
        Assertions.assertEquals(Collections.emptyList(), (Object)setting3.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0]))));
    }

    @Test
    void testPowerOf2() {
        Setting setting = Settings.buildSetting((String)"foo", (Function)Settings.LONG, (String)"2").constraint(Settings.powerOf2()).build();
        MatcherAssert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "256"}))), (Matcher)CoreMatchers.equalTo((Object)256L));
        Assertions.assertThrows(InvalidSettingException.class, () -> {
            Long cfr_ignored_0 = (Long)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "255"})));
        });
    }

    @Test
    void testMin() {
        Setting setting = Settings.buildSetting((String)"foo", (Function)Settings.INTEGER, (String)"3").constraint(Settings.min((Comparable)Integer.valueOf(2))).build();
        MatcherAssert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "4"}))), (Matcher)CoreMatchers.equalTo((Object)4));
        Assertions.assertThrows(InvalidSettingException.class, () -> {
            Integer cfr_ignored_0 = (Integer)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "1"})));
        });
    }

    @Test
    void exceptDoesNotAllowForbiddenValues() {
        Setting restrictedSetting = Settings.buildSetting((String)"foo", (Function)Settings.STRING, (String)"test").constraint(Settings.except((String[])new String[]{"a", "b", "c"})).build();
        Assertions.assertEquals((Object)"test", (Object)restrictedSetting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0]))));
        Assertions.assertEquals((Object)"d", (Object)restrictedSetting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "d"}))));
        Assertions.assertThrows(InvalidSettingException.class, () -> {
            String cfr_ignored_0 = (String)restrictedSetting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "a"})));
        });
        Assertions.assertThrows(InvalidSettingException.class, () -> {
            String cfr_ignored_0 = (String)restrictedSetting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "b"})));
        });
        InvalidSettingException exception = (InvalidSettingException)Assertions.assertThrows(InvalidSettingException.class, () -> {
            String cfr_ignored_0 = (String)restrictedSetting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "c"})));
        });
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"not allowed value is: c"));
    }

    @Test
    void testMax() {
        Setting setting = Settings.buildSetting((String)"foo", (Function)Settings.INTEGER, (String)"3").constraint(Settings.max((Comparable)Integer.valueOf(5))).build();
        MatcherAssert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "4"}))), (Matcher)CoreMatchers.equalTo((Object)4));
        Assertions.assertThrows(InvalidSettingException.class, () -> {
            Integer cfr_ignored_0 = (Integer)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "7"})));
        });
    }

    @Test
    void testRange() {
        Setting setting = Settings.buildSetting((String)"foo", (Function)Settings.INTEGER, (String)"3").constraint(Settings.range((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(5))).build();
        MatcherAssert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "4"}))), (Matcher)CoreMatchers.equalTo((Object)4));
        Assertions.assertThrows(InvalidSettingException.class, () -> {
            Integer cfr_ignored_0 = (Integer)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "1"})));
        });
        Assertions.assertThrows(InvalidSettingException.class, () -> {
            Integer cfr_ignored_0 = (Integer)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "6"})));
        });
    }

    @Test
    void testMatches() {
        Setting setting = Settings.buildSetting((String)"foo", (Function)Settings.STRING, (String)"abc").constraint(Settings.matches((String)"a*b*c*")).build();
        MatcherAssert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "aaabbbccc"}))), (Matcher)CoreMatchers.equalTo((Object)"aaabbbccc"));
        Assertions.assertThrows(InvalidSettingException.class, () -> {
            String cfr_ignored_0 = (String)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "cba"})));
        });
    }

    @Test
    void testDurationWithBrokenDefault() {
        Setting setting = Settings.buildSetting((String)"foo.bar", (Function)Settings.DURATION, (String)"1s").constraint(Settings.min((Comparable)((Comparable)Settings.DURATION.apply("3s")))).build();
        Assertions.assertThrows(InvalidSettingException.class, () -> {
            Duration cfr_ignored_0 = (Duration)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])));
        });
    }

    @Test
    void testDurationWithValueNotWithinConstraint() {
        Setting setting = Settings.buildSetting((String)"foo.bar", (Function)Settings.DURATION, (String)"3s").constraint(Settings.min((Comparable)((Comparable)Settings.DURATION.apply("3s")))).build();
        Assertions.assertThrows(InvalidSettingException.class, () -> {
            Duration cfr_ignored_0 = (Duration)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo.bar", "2s"})));
        });
    }

    @Test
    void testDuration() {
        Setting setting = Settings.buildSetting((String)"foo.bar", (Function)Settings.DURATION, (String)"3s").constraint(Settings.min((Comparable)((Comparable)Settings.DURATION.apply("3s")))).build();
        MatcherAssert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo.bar", "4s"}))), (Matcher)CoreMatchers.equalTo((Object)Duration.ofSeconds(4L)));
    }

    @Test
    void badDurationMissingNumber() {
        Setting setting = Settings.buildSetting((String)"foo.bar", (Function)Settings.DURATION).build();
        InvalidSettingException exception = (InvalidSettingException)Assertions.assertThrows(InvalidSettingException.class, () -> {
            Duration cfr_ignored_0 = (Duration)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo.bar", "ms"})));
        });
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"Missing numeric value"));
    }

    @Test
    void badDurationInvalidUnit() {
        Setting setting = Settings.buildSetting((String)"foo.bar", (Function)Settings.DURATION).build();
        InvalidSettingException exception = (InvalidSettingException)Assertions.assertThrows(InvalidSettingException.class, () -> {
            Duration cfr_ignored_0 = (Duration)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo.bar", "2gigaseconds"})));
        });
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"Unrecognized unit 'gigaseconds'"));
    }

    @Test
    void testCidrIp() {
        Setting setting = Settings.buildSetting((String)"foo.bar", (Function)Settings.CIDR_IP).build();
        Assertions.assertEquals((Object)new IPAddressString("1.1.1.0/8"), (Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo.bar", "1.1.1.0/8"}))));
        Assertions.assertThrows(InvalidSettingException.class, () -> {
            IPAddressString cfr_ignored_0 = (IPAddressString)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo.bar", "garbage"})));
        });
    }

    @Test
    void testCidrIpList() {
        Setting setting = Settings.setting((String)"foo.bar", (Function)Settings.list((String)",", (Function)Settings.CIDR_IP), (String)"");
        Assertions.assertEquals(Arrays.asList(new IPAddressString("1.1.1.0/8")), (Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo.bar", "1.1.1.0/8"}))));
        Assertions.assertEquals(Arrays.asList(new IPAddressString("1.1.1.0/8"), new IPAddressString("124.0.255.255/1")), (Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo.bar", "1.1.1.0/8,124.0.255.255/1"}))));
        Assertions.assertEquals(Arrays.asList(new Object[0]), (Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo.bar", ""}))));
        Assertions.assertThrows(InvalidSettingException.class, () -> {
            List cfr_ignored_0 = (List)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo.bar", "garbage"})));
        });
    }

    @Test
    void testDefault() {
        Setting setting = Settings.setting((String)"foo", (Function)Settings.INTEGER, (String)"3");
        MatcherAssert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0]))), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    void testPaths() {
        File directory = new File("myDirectory");
        Setting config = Settings.buildSetting((String)"config", (Function)Settings.PATH, (String)new File(directory, "config.properties").getAbsolutePath()).constraint(isFile).build();
        MatcherAssert.assertThat((Object)((File)config.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])))).getAbsolutePath(), (Matcher)CoreMatchers.equalTo((Object)new File(directory, "config.properties").getAbsolutePath()));
    }

    @Test
    void testInheritOneLevel() {
        Setting root = Settings.setting((String)"root", (Function)Settings.INTEGER, (String)"4");
        Setting setting = Settings.buildSetting((String)"foo", (Function)Settings.INTEGER).inherits(root).build();
        MatcherAssert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"foo", "1"}))), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0]))), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    void testInheritHierarchy() {
        Setting a = Settings.setting((String)"A", (Function)Settings.STRING, (String)"A");
        Setting b = Settings.buildSetting((String)"B", (Function)Settings.STRING, (String)"B").inherits(a).build();
        Setting c = Settings.buildSetting((String)"C", (Function)Settings.STRING, (String)"C").inherits(b).build();
        Setting d = Settings.buildSetting((String)"D", (Function)Settings.STRING).inherits(b).build();
        Setting e = Settings.buildSetting((String)"E", (Function)Settings.STRING).inherits(d).build();
        MatcherAssert.assertThat((Object)c.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"C", "X"}))), (Matcher)CoreMatchers.equalTo((Object)"X"));
        MatcherAssert.assertThat((Object)c.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"B", "X"}))), (Matcher)CoreMatchers.equalTo((Object)"X"));
        MatcherAssert.assertThat((Object)c.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"A", "X"}))), (Matcher)CoreMatchers.equalTo((Object)"X"));
        MatcherAssert.assertThat((Object)c.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{"A", "Y", "B", "X"}))), (Matcher)CoreMatchers.equalTo((Object)"X"));
        MatcherAssert.assertThat((Object)d.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0]))), (Matcher)CoreMatchers.equalTo((Object)"B"));
        MatcherAssert.assertThat((Object)e.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0]))), (Matcher)CoreMatchers.equalTo((Object)"B"));
    }

    @Test
    void testLogicalLogRotationThreshold() {
        Setting setting = GraphDatabaseSettings.logical_log_rotation_threshold;
        long defaultValue = (Long)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[0])));
        long megaValue = (Long)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{setting.name(), "10M"})));
        long gigaValue = (Long)setting.apply(SettingsTest.map(MapUtil.stringMap((String[])new String[]{setting.name(), "10g"})));
        MatcherAssert.assertThat((Object)defaultValue, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        Assertions.assertEquals((long)0xA00000L, (long)megaValue);
        Assertions.assertEquals((long)0x280000000L, (long)gigaValue);
    }

    @Test
    void testNormalizedRelativeURI() {
        Setting uri = Settings.setting((String)"mySetting", (Function)Settings.NORMALIZED_RELATIVE_URI, (String)"http://localhost:7474///db///data///");
        MatcherAssert.assertThat((Object)((URI)uri.apply(always -> null)).toString(), (Matcher)CoreMatchers.equalTo((Object)"/db/data"));
    }

    @Test
    void onlySingleInheritanceShouldBeAllowed() {
        Setting a = Settings.setting((String)"A", (Function)Settings.STRING, (String)"A");
        Setting b = Settings.setting((String)"B", (Function)Settings.STRING, (String)"B");
        Assertions.assertThrows(AssertionError.class, () -> Settings.buildSetting((String)"C", (Function)Settings.STRING, (String)"C").inherits(a).inherits(b).build());
    }

    private static <From, To> Function<From, To> map(Map<From, To> map) {
        return map::get;
    }
}

