/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.IOException;
import org.eclipse.collections.api.map.primitive.MutableObjectIntMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectIntHashMap;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.storageengine.api.CommandReader;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class IndexDefineCommandTest {
    @Test
    public void testIndexCommandCreationEnforcesLimit() {
        IndexDefineCommand idc = new IndexDefineCommand();
        int count = 65534;
        for (int i = 0; i < count; ++i) {
            idc.getOrAssignKeyId("key" + i);
            idc.getOrAssignIndexNameId("index" + i);
        }
        try {
            idc.getOrAssignKeyId("dropThatOverflows");
            Assert.fail((String)("IndexDefineCommand should not allow more than " + count + " indexes per transaction"));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            idc.getOrAssignIndexNameId("dropThatOverflows");
            Assert.fail((String)("IndexDefineCommand should not allow more than " + count + " keys per transaction"));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldWriteIndexDefineCommandIfMapWithinShortRange() throws IOException {
        InMemoryClosableChannel channel = new InMemoryClosableChannel(10000);
        IndexDefineCommand command = this.initIndexDefineCommand(300);
        command.serialize((WritableChannel)channel);
        CommandReader commandReader = new RecordStorageCommandReaderFactory().byVersion(LogEntryVersion.CURRENT.byteCode());
        IndexDefineCommand read = (IndexDefineCommand)commandReader.read((ReadableChannel)channel);
        Assert.assertEquals((Object)command.getIndexNameIdRange(), (Object)read.getIndexNameIdRange());
        Assert.assertEquals((Object)command.getKeyIdRange(), (Object)read.getKeyIdRange());
    }

    @Test
    public void shouldFailToWriteIndexDefineCommandIfMapIsLargerThanShort() throws IOException {
        InMemoryClosableChannel channel = new InMemoryClosableChannel(1000);
        IndexDefineCommand command = new IndexDefineCommand();
        MutableObjectIntMap<String> largeMap = this.initMap(65536);
        command.init(largeMap, largeMap);
        Assert.assertTrue((boolean)this.serialize(channel, command));
    }

    private boolean serialize(InMemoryClosableChannel channel, IndexDefineCommand command) throws IOException {
        try {
            command.serialize((WritableChannel)channel);
        }
        catch (AssertionError e) {
            return true;
        }
        return false;
    }

    private IndexDefineCommand initIndexDefineCommand(int nbrOfEntries) {
        IndexDefineCommand command = new IndexDefineCommand();
        MutableObjectIntMap<String> indexNames = this.initMap(nbrOfEntries);
        MutableObjectIntMap<String> keys = this.initMap(nbrOfEntries);
        command.init(indexNames, keys);
        return command;
    }

    private MutableObjectIntMap<String> initMap(int nbrOfEntries) {
        ObjectIntHashMap toReturn = new ObjectIntHashMap();
        while (nbrOfEntries-- > 0) {
            toReturn.put((Object)("key" + nbrOfEntries), nbrOfEntries);
        }
        return toReturn;
    }
}

