/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeBuilder;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.index.labelscan.LabelScanKey;
import org.neo4j.kernel.impl.index.labelscan.LabelScanLayout;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValue;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValueIterator;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanStoreIT;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanWriter;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;

public class NativeLabelScanWriterTest {
    private static final int LABEL_COUNT = 5;
    private static final int NODE_COUNT = 10000;
    private static final Comparator<LabelScanKey> KEY_COMPARATOR = new LabelScanLayout();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory();
    @Rule
    public final RandomRule random = new RandomRule();
    private PageCache pageCache;
    private GBPTree<LabelScanKey, LabelScanValue> tree;

    @Before
    public void openTree() {
        this.pageCache = this.pageCacheRule.getPageCache(this.directory.getFileSystem());
        this.tree = new GBPTreeBuilder(this.pageCache, this.directory.file("file"), (Layout)new LabelScanLayout()).build();
    }

    @After
    public void closeTree() throws IOException {
        this.tree.close();
    }

    @Test
    public void shouldAddAndRemoveLabels() throws Exception {
        long[] expected = new long[10000];
        try (NativeLabelScanWriter writer = new NativeLabelScanWriter(Integer.max(5, 100), NativeLabelScanWriter.EMPTY);){
            writer.initialize(this.tree.writer());
            for (int i = 0; i < 30000; ++i) {
                NodeLabelUpdate update = this.randomUpdate(expected);
                writer.write(update);
            }
        }
        for (int i = 0; i < 5; ++i) {
            long[] expectedNodeIds = NativeLabelScanStoreIT.nodesWithLabel(expected, i);
            long[] actualNodeIds = PrimitiveLongCollections.asArray((LongIterator)new LabelScanValueIterator(this.tree.seek((Object)new LabelScanKey(i, 0L), (Object)new LabelScanKey(i, Long.MAX_VALUE)), new ArrayList(), -1L));
            Assert.assertArrayEquals((String)("For label " + i), (long[])expectedNodeIds, (long[])actualNodeIds);
        }
    }

    @Test
    public void shouldNotAcceptUnsortedLabels() throws Exception {
        boolean failed = false;
        try (NativeLabelScanWriter writer = new NativeLabelScanWriter(1, NativeLabelScanWriter.EMPTY);){
            writer.initialize(this.tree.writer());
            writer.write(NodeLabelUpdate.labelChanges((long)0L, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{2L, 1L}));
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("unsorted"));
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
    }

    @Test
    public void shouldRemoveTreeEmptyTreeEntries() throws IOException {
        long baseNodeId;
        int numberOfTreeEntries = 3;
        int numberOfNodesInEach = 5;
        int labelId = 1;
        long[] labels = new long[]{labelId};
        try (NativeLabelScanWriter writer = new NativeLabelScanWriter(Integer.max(5, 100), NativeLabelScanWriter.EMPTY);){
            writer.initialize(this.tree.writer());
            for (int i = 0; i < numberOfTreeEntries; ++i) {
                baseNodeId = i * 64;
                for (int j = 0; j < numberOfNodesInEach; ++j) {
                    writer.write(NodeLabelUpdate.labelChanges((long)(baseNodeId + (long)j), (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])labels));
                }
            }
        }
        this.assertTreeHasKeysRepresentingIdRanges(NativeLabelScanWriterTest.setOfRange(0L, numberOfTreeEntries));
        int treeEntryToRemoveFrom = 1;
        try (NativeLabelScanWriter writer = new NativeLabelScanWriter(Integer.max(5, 100), NativeLabelScanWriter.EMPTY);){
            writer.initialize(this.tree.writer());
            baseNodeId = treeEntryToRemoveFrom * 64;
            for (int i = 0; i < numberOfNodesInEach; ++i) {
                writer.write(NodeLabelUpdate.labelChanges((long)(baseNodeId + (long)i), (long[])labels, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY));
            }
        }
        MutableLongSet expected = NativeLabelScanWriterTest.setOfRange(0L, numberOfTreeEntries);
        expected.remove((long)treeEntryToRemoveFrom);
        this.assertTreeHasKeysRepresentingIdRanges(expected);
    }

    private NodeLabelUpdate randomUpdate(long[] expected) {
        int nodeId = this.random.nextInt(expected.length);
        long labels = expected[nodeId];
        long[] before = NativeLabelScanStoreIT.getLabels(labels);
        int changeCount = this.random.nextInt(4) + 1;
        for (int i = 0; i < changeCount; ++i) {
            labels = NativeLabelScanStoreIT.flipRandom(labels, 5, this.random.random());
        }
        expected[nodeId] = labels;
        return NodeLabelUpdate.labelChanges((long)nodeId, (long[])before, (long[])NativeLabelScanStoreIT.getLabels(labels));
    }

    private void assertTreeHasKeysRepresentingIdRanges(final MutableLongSet expected) throws IOException {
        this.tree.visit((GBPTreeVisitor)new GBPTreeVisitor.Adaptor<LabelScanKey, LabelScanValue>(){

            public void key(LabelScanKey labelScanKey, boolean isLeaf) {
                if (isLeaf) {
                    Assert.assertTrue((boolean)expected.remove(labelScanKey.idRange));
                }
            }
        });
        Assert.assertTrue((boolean)expected.isEmpty());
    }

    private static MutableLongSet setOfRange(long from, long to) {
        MutableLongSet set = LongSets.mutable.empty();
        for (long i = from; i < to; ++i) {
            set.add(i);
        }
        return set;
    }
}

