/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Future;
import java.util.function.LongPredicate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.BlockStorage;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.kernel.impl.index.schema.FileSystemIndexDropAction;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.IndexDropAction;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.UnsafeDirectByteBufferAllocator;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.memory.ThreadSafePeakMemoryAllocationTracker;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.test.Barrier;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.Race;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.test.rule.concurrent.OtherThreadRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class BlockBasedIndexPopulatorTest {
    private static final StoreIndexDescriptor INDEX_DESCRIPTOR = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{1})).withId(1L);
    @Rule
    public final PageCacheAndDependenciesRule storage = new PageCacheAndDependenciesRule();
    @Rule
    public final OtherThreadRule<Void> t2 = new OtherThreadRule("MERGER");
    @Rule
    public final OtherThreadRule<Void> t3 = new OtherThreadRule("CLOSER");
    private final TokenNameLookup tokenNameLookup = SchemaTestUtil.simpleNameLookup;
    private IndexDirectoryStructure directoryStructure;
    private File indexDir;
    private File indexFile;
    private FileSystemAbstraction fs;
    private IndexDropAction dropAction;

    @Before
    public void setup() {
        IndexProviderDescriptor providerDescriptor = new IndexProviderDescriptor("test", "v1");
        this.directoryStructure = IndexDirectoryStructure.directoriesByProvider((File)this.storage.directory().databaseDir()).forProvider(providerDescriptor);
        this.indexDir = this.directoryStructure.directoryForIndex(INDEX_DESCRIPTOR.getId());
        this.indexFile = new File(this.indexDir, "index");
        this.fs = this.storage.fileSystem();
        this.dropAction = new FileSystemIndexDropAction(this.fs, this.directoryStructure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAwaitMergeToBeFullyAbortedBeforeLeavingCloseMethod() throws Exception {
        TrappingMonitor monitor = new TrappingMonitor(ignore -> false);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator((BlockStorage.Monitor)monitor);
        boolean closed = false;
        try {
            populator.add(BlockBasedIndexPopulatorTest.batchOfUpdates());
            Future mergeFuture = this.t2.execute(OtherThreadExecutor.command(() -> populator.scanCompleted(PhaseTracker.nullInstance)));
            monitor.barrier.awaitUninterruptibly();
            Future closeFuture = this.t3.execute(OtherThreadExecutor.command(() -> populator.close(false)));
            this.t3.get().waitUntilWaiting();
            monitor.barrier.release();
            closeFuture.get();
            closed = true;
            Assert.assertTrue((boolean)mergeFuture.isDone());
        }
        finally {
            if (!closed) {
                populator.close(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldHandleBeingAbortedWhileMerging() throws Exception {
        TrappingMonitor monitor = new TrappingMonitor(numberOfBlocks -> numberOfBlocks == 2L);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator((BlockStorage.Monitor)monitor);
        boolean closed = false;
        try {
            populator.add(BlockBasedIndexPopulatorTest.batchOfUpdates());
            Future mergeFuture = this.t2.execute(OtherThreadExecutor.command(() -> populator.scanCompleted(PhaseTracker.nullInstance)));
            monitor.barrier.await();
            monitor.barrier.release();
            monitor.mergeFinishedBarrier.awaitUninterruptibly();
            Future closeFuture = this.t3.execute(OtherThreadExecutor.command(() -> populator.close(false)));
            this.t3.get().waitUntilWaiting();
            monitor.mergeFinishedBarrier.release();
            closeFuture.get();
            closed = true;
            mergeFuture.get();
        }
        finally {
            if (!closed) {
                populator.close(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldReportAccurateProgressThroughoutThePhases() throws Exception {
        TrappingMonitor monitor = new TrappingMonitor(numberOfBlocks -> numberOfBlocks == 1L);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator((BlockStorage.Monitor)monitor);
        try {
            populator.add(BlockBasedIndexPopulatorTest.batchOfUpdates());
            Future mergeFuture = this.t2.execute(OtherThreadExecutor.command(() -> populator.scanCompleted(PhaseTracker.nullInstance)));
            monitor.barrier.awaitUninterruptibly();
            Assert.assertEquals((float)0.5f, (float)populator.progress(PopulationProgress.DONE).getProgress(), (float)0.1f);
            monitor.barrier.release();
            monitor.mergeFinishedBarrier.awaitUninterruptibly();
            Assert.assertEquals((float)0.7f, (float)populator.progress(PopulationProgress.DONE).getProgress(), (float)0.1f);
            monitor.mergeFinishedBarrier.release();
            mergeFuture.get();
            Assert.assertEquals((float)1.0f, (float)populator.progress(PopulationProgress.DONE).getProgress(), (float)0.0f);
        }
        finally {
            populator.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCorrectlyDecideToAwaitMergeDependingOnProgress() throws Throwable {
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR);
        boolean closed = false;
        try {
            populator.add(BlockBasedIndexPopulatorTest.batchOfUpdates());
            Race race = new Race();
            race.addContestant(Race.throwing(() -> populator.scanCompleted(PhaseTracker.nullInstance)));
            race.addContestant(Race.throwing(() -> populator.close(false)));
            race.go();
            closed = true;
            EphemeralFileSystemAbstraction ephemeralFileSystem = (EphemeralFileSystemAbstraction)this.fs;
            ephemeralFileSystem.assertNoOpenFiles();
        }
        finally {
            if (!closed) {
                populator.close(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDeleteDirectoryOnDrop() throws Exception {
        TrappingMonitor monitor = new TrappingMonitor(ignore -> false);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator((BlockStorage.Monitor)monitor);
        boolean closed = false;
        try {
            populator.add(BlockBasedIndexPopulatorTest.batchOfUpdates());
            Future mergeFuture = this.t2.execute(OtherThreadExecutor.command(() -> populator.scanCompleted(PhaseTracker.nullInstance)));
            monitor.barrier.awaitUninterruptibly();
            Assert.assertTrue((boolean)this.fs.fileExists(this.indexDir));
            Assert.assertTrue((boolean)this.fs.isDirectory(this.indexDir));
            Assert.assertTrue((this.fs.listFiles(this.indexDir).length > 0 ? 1 : 0) != 0);
            Future dropFuture = this.t3.execute(OtherThreadExecutor.command(() -> populator.drop()));
            this.t3.get().waitUntilWaiting();
            monitor.barrier.release();
            dropFuture.get();
            closed = true;
            Assert.assertTrue((boolean)mergeFuture.isDone());
            Assert.assertFalse((boolean)this.fs.fileExists(this.indexDir));
        }
        finally {
            if (!closed) {
                populator.close(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDeallocateAllAllocatedMemoryOnClose() throws IndexEntryConflictException {
        ThreadSafePeakMemoryAllocationTracker memoryTracker = new ThreadSafePeakMemoryAllocationTracker((MemoryAllocationTracker)new LocalMemoryTracker());
        ByteBufferFactory bufferFactory = new ByteBufferFactory(() -> new UnsafeDirectByteBufferAllocator((MemoryAllocationTracker)memoryTracker), 100);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR, bufferFactory);
        boolean closed = false;
        try {
            Collection<IndexEntryUpdate<?>> updates = BlockBasedIndexPopulatorTest.batchOfUpdates();
            populator.add(updates);
            int nextId = updates.size();
            this.externalUpdates(populator, nextId, nextId + 10);
            long memoryBeforeScanCompleted = memoryTracker.usedDirectMemory();
            populator.scanCompleted(PhaseTracker.nullInstance);
            this.externalUpdates(populator, nextId += 10, nextId + 10);
            Assert.assertTrue((String)"expected some memory to have been temporarily allocated in scanCompleted", (memoryTracker.peakMemoryUsage() > memoryBeforeScanCompleted ? 1 : 0) != 0);
            populator.close(true);
            Assert.assertEquals((String)"expected all allocated memory to have been freed on close", (long)memoryBeforeScanCompleted, (long)memoryTracker.usedDirectMemory());
            closed = true;
            bufferFactory.close();
            Assert.assertEquals((long)0L, (long)memoryTracker.usedDirectMemory());
        }
        finally {
            if (!closed) {
                populator.close(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDeallocateAllAllocatedMemoryOnDrop() throws IndexEntryConflictException {
        ThreadSafePeakMemoryAllocationTracker memoryTracker = new ThreadSafePeakMemoryAllocationTracker((MemoryAllocationTracker)new LocalMemoryTracker());
        ByteBufferFactory bufferFactory = new ByteBufferFactory(() -> new UnsafeDirectByteBufferAllocator((MemoryAllocationTracker)memoryTracker), 100);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR, bufferFactory);
        boolean closed = false;
        try {
            Collection<IndexEntryUpdate<?>> updates = BlockBasedIndexPopulatorTest.batchOfUpdates();
            populator.add(updates);
            int nextId = updates.size();
            this.externalUpdates(populator, nextId, nextId + 10);
            long memoryBeforeScanCompleted = memoryTracker.usedDirectMemory();
            populator.scanCompleted(PhaseTracker.nullInstance);
            this.externalUpdates(populator, nextId += 10, nextId + 10);
            Assert.assertTrue((String)"expected some memory to have been temporarily allocated in scanCompleted", (memoryTracker.peakMemoryUsage() > memoryBeforeScanCompleted ? 1 : 0) != 0);
            populator.drop();
            closed = true;
            Assert.assertEquals((String)"expected all allocated memory to have been freed on drop", (long)memoryBeforeScanCompleted, (long)memoryTracker.usedDirectMemory());
            bufferFactory.close();
            Assert.assertEquals((long)0L, (long)memoryTracker.usedDirectMemory());
        }
        finally {
            if (!closed) {
                populator.close(true);
            }
        }
    }

    private void externalUpdates(BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator, int firstId, int lastId) throws IndexEntryConflictException {
        try (IndexUpdater updater = populator.newPopulatingUpdater();){
            for (int i = firstId; i < lastId; ++i) {
                updater.process(BlockBasedIndexPopulatorTest.add(i));
            }
        }
    }

    private BlockBasedIndexPopulator<GenericKey, NativeIndexValue> instantiatePopulator(BlockStorage.Monitor monitor) {
        return this.instantiatePopulator(monitor, ByteBufferFactory.heapBufferFactory((int)100));
    }

    private BlockBasedIndexPopulator<GenericKey, NativeIndexValue> instantiatePopulator(BlockStorage.Monitor monitor, ByteBufferFactory bufferFactory) {
        Config config = Config.defaults();
        ConfiguredSpaceFillingCurveSettingsCache settingsCache = new ConfiguredSpaceFillingCurveSettingsCache(config);
        IndexSpecificSpaceFillingCurveSettingsCache spatialSettings = new IndexSpecificSpaceFillingCurveSettingsCache(settingsCache, new HashMap());
        GenericLayout layout = new GenericLayout(1, spatialSettings);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = new BlockBasedIndexPopulator<GenericKey, NativeIndexValue>(this.storage.pageCache(), this.fs, this.indexFile, (IndexLayout)layout, IndexProvider.Monitor.EMPTY, INDEX_DESCRIPTOR, spatialSettings, this.directoryStructure, this.dropAction, false, bufferFactory, 2, monitor, this.tokenNameLookup){

            NativeIndexReader<GenericKey, NativeIndexValue> newReader() {
                throw new UnsupportedOperationException("Not needed in this test");
            }
        };
        populator.create();
        return populator;
    }

    private static Collection<IndexEntryUpdate<?>> batchOfUpdates() {
        ArrayList updates = new ArrayList();
        for (int i = 0; i < 50; ++i) {
            updates.add(BlockBasedIndexPopulatorTest.add(i));
        }
        return updates;
    }

    private static IndexEntryUpdate<StoreIndexDescriptor> add(int i) {
        return IndexEntryUpdate.add((long)i, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{Values.stringValue((String)("Value" + i))});
    }

    private static class TrappingMonitor
    extends BlockStorage.Monitor.Adapter {
        private final Barrier.Control barrier = new Barrier.Control();
        private final Barrier.Control mergeFinishedBarrier = new Barrier.Control();
        private final LongPredicate trapForMergeIterationFinished;

        TrappingMonitor(LongPredicate trapForMergeIterationFinished) {
            this.trapForMergeIterationFinished = trapForMergeIterationFinished;
        }

        public void mergedBlocks(long resultingBlockSize, long resultingEntryCount, long numberOfBlocks) {
            this.barrier.reached();
        }

        public void mergeIterationFinished(long numberOfBlocksBefore, long numberOfBlocksAfter) {
            if (this.trapForMergeIterationFinished.test(numberOfBlocksAfter)) {
                this.mergeFinishedBarrier.reached();
            }
        }
    }
}

