/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public class SpaceFillingCurveSettingsFactoryTest {
    @Test
    public void shouldGetDefaultSpaceFillingCurveSettingsForWGS84() {
        this.shouldGetSettingsFor(Config.defaults(), CoordinateReferenceSystem.WGS84, 2, 60, new Envelope(-180.0, 180.0, -90.0, 90.0));
    }

    @Test
    public void shouldGetDefaultSpaceFillingCurveSettingsForWGS84_3D() {
        this.shouldGetSettingsFor(Config.defaults(), CoordinateReferenceSystem.WGS84_3D, 3, 60, new Envelope(new double[]{-180.0, -90.0, -1000000.0}, new double[]{180.0, 90.0, 1000000.0}));
    }

    @Test
    public void shouldGetDefaultSpaceFillingCurveSettingsForCartesian() {
        this.shouldGetSettingsFor(Config.defaults(), CoordinateReferenceSystem.Cartesian, 2, 60, new Envelope(-1000000.0, 1000000.0, -1000000.0, 1000000.0));
    }

    @Test
    public void shouldGetDefaultSpaceFillingCurveSettingsForCartesian_3D() {
        this.shouldGetSettingsFor(Config.defaults(), CoordinateReferenceSystem.Cartesian_3D, 3, 60, new Envelope(new double[]{-1000000.0, -1000000.0, -1000000.0}, new double[]{1000000.0, 1000000.0, 1000000.0}));
    }

    @Test
    public void shouldGetModifiedSpaceFillingCurveSettingsForWGS84() {
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.WGS84;
        for (int maxBits = 30; maxBits <= 60; maxBits += 10) {
            for (int minx = -180; minx < 0; minx += 45) {
                for (int miny = -180; miny < 0; miny += 45) {
                    for (int width = 10; width < 90; width += 40) {
                        for (int height = 10; height < 90; height += 40) {
                            this.shouldGetCustomSettingsFor(crs, maxBits, new double[]{minx, miny}, new double[]{minx + width, miny + height});
                        }
                    }
                }
            }
        }
    }

    @Test
    public void shouldGetModifiedSpaceFillingCurveSettingsForWGS84_3D() {
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.WGS84_3D;
        this.shouldGetCustomSettingsFor(crs, 60, new double[]{-180.0, -90.0, -1000000.0}, new double[]{180.0, 90.0, 1000000.0});
        this.shouldGetCustomSettingsFor(crs, 30, new double[]{-180.0, -90.0, -1000000.0}, new double[]{180.0, 90.0, 1000000.0});
        this.shouldGetCustomSettingsFor(crs, 60, new double[]{0.0, -90.0, -1000000.0}, new double[]{180.0, 0.0, 1000000.0});
        this.shouldGetCustomSettingsFor(crs, 30, new double[]{0.0, -90.0, -1000000.0}, new double[]{180.0, 0.0, 1000000.0});
        this.shouldGetCustomSettingsFor(crs, 60, new double[]{-90.0, -45.0, -1000.0}, new double[]{90.0, 45.0, 1000.0});
        this.shouldGetCustomSettingsFor(crs, 30, new double[]{-90.0, -90.0, -1000.0}, new double[]{90.0, 45.0, 1000.0});
        this.shouldGetCustomSettingsFor(crs, 60, new double[]{-1000.0, -1000.0, -1000.0}, new double[]{1000.0, 1000.0, 1000.0});
        this.shouldGetCustomSettingsFor(crs, 30, new double[]{-1000.0, -1000.0, -1000.0}, new double[]{1000.0, 1000.0, 1000.0});
    }

    @Test
    public void shouldGetModifiedSpaceFillingCurveSettingsForCartesian() {
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.Cartesian;
        for (int maxBits = 30; maxBits <= 60; maxBits += 10) {
            for (int minx = -1000000; minx < 0; minx += 200000) {
                for (int miny = -1000000; miny < 0; miny += 2000000) {
                    for (int width = 100000; width < 1000000; width += 200000) {
                        for (int height = 100000; height < 1000000; height += 200000) {
                            this.shouldGetCustomSettingsFor(crs, maxBits, new double[]{minx, miny}, new double[]{minx + width, miny + height});
                        }
                    }
                }
            }
        }
    }

    @Test
    public void shouldGetModifiedSpaceFillingCurveSettingsForCartesian_3D() {
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.Cartesian_3D;
        this.shouldGetCustomSettingsFor(crs, 60, new double[]{-1000000.0, -1000000.0, -1000000.0}, new double[]{1000000.0, 1000000.0, 1000000.0});
        this.shouldGetCustomSettingsFor(crs, 30, new double[]{-1000000.0, -1000000.0, -1000000.0}, new double[]{1000000.0, 1000000.0, 1000000.0});
        this.shouldGetCustomSettingsFor(crs, 60, new double[]{0.0, -1000000.0, -1000000.0}, new double[]{1000000.0, 0.0, 1000000.0});
        this.shouldGetCustomSettingsFor(crs, 30, new double[]{0.0, -1000000.0, -1000000.0}, new double[]{1000000.0, 0.0, 1000000.0});
        this.shouldGetCustomSettingsFor(crs, 60, new double[]{-1000.0, -1000.0, -1000.0}, new double[]{1000.0, 1000.0, 1000.0});
        this.shouldGetCustomSettingsFor(crs, 30, new double[]{-1000.0, -1000.0, -1000.0}, new double[]{1000.0, 1000.0, 1000.0});
        this.shouldGetCustomSettingsFor(crs, 60, new double[]{-1.0E9, -1.0E9, -1.0E9}, new double[]{1.0E9, 1.0E9, 1.0E9});
        this.shouldGetCustomSettingsFor(crs, 30, new double[]{-1.0E9, -1.0E9, -1.0E9}, new double[]{1.0E9, 1.0E9, 1.0E9});
    }

    private void shouldGetCustomSettingsFor(CoordinateReferenceSystem crs, int maxBits, double[] min, double[] max) {
        String crsPrefix = "unsupported.dbms.db.spatial.crs." + crs.getName();
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("unsupported.dbms.index.spatial.curve.max_bits", Integer.toString(maxBits));
        for (int i = 0; i < min.length; ++i) {
            char var = "xyz".toCharArray()[i];
            settings.put(crsPrefix + "." + var + ".min", Double.toString(min[i]));
            settings.put(crsPrefix + "." + var + ".max", Double.toString(max[i]));
        }
        Config config = Config.defaults();
        config.augment(settings);
        this.shouldGetSettingsFor(config, crs, min.length, maxBits, new Envelope(min, max));
    }

    private void shouldGetSettingsFor(Config config, CoordinateReferenceSystem crs, int dimensions, int maxBits, Envelope envelope) {
        ConfiguredSpaceFillingCurveSettingsCache configuredSettings = new ConfiguredSpaceFillingCurveSettingsCache(config);
        SpaceFillingCurveSettings settings = configuredSettings.forCRS(crs);
        MatcherAssert.assertThat((String)("Expected " + dimensions + "D for " + crs.getName()), (Object)settings.getDimensions(), (Matcher)CoreMatchers.equalTo((Object)dimensions));
        int maxLevels = maxBits / dimensions;
        MatcherAssert.assertThat((String)("Expected maxLevels=" + maxLevels + " for " + crs.getName()), (Object)settings.getMaxLevels(), (Matcher)CoreMatchers.equalTo((Object)maxLevels));
        MatcherAssert.assertThat((String)"Should have normal geographic 2D extents", (Object)settings.indexExtents(), (Matcher)CoreMatchers.equalTo((Object)envelope));
    }
}

