/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.security.URLAccessRules;

class WebURLAccessRuleTest {
    WebURLAccessRuleTest() {
    }

    @Test
    void shouldThrowWhenUrlIsWithinBlockedRange() throws MalformedURLException {
        List<String> urlAddresses = Arrays.asList("http://localhost/test.csv", "https://localhost/test.csv", "ftp://localhost/test.csv", "http://[::1]/test.csv");
        for (String urlAddress : urlAddresses) {
            URL url = new URL(urlAddress);
            Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.cypher_ip_blocklist.name(), "127.0.0.0/8,0:0:0:0:0:0:0:1/8"}));
            URLAccessValidationError error = (URLAccessValidationError)Assertions.assertThrows(URLAccessValidationError.class, () -> URLAccessRules.webAccess().validate((Configuration)config, url));
            MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)CoreMatchers.containsString((String)"blocked via the configuration property unsupported.dbms.cypher_ip_blocklist"));
        }
    }

    @Test
    void validationShouldPassWhenUrlIsNotWithinBlockedRange() throws MalformedURLException, URLAccessValidationError {
        List<String> urlAddresses = Arrays.asList("http://localhost/test.csv", "https://localhost/test.csv", "ftp://localhost/test.csv", "http://[::1]/test.csv");
        for (String urlAddress : urlAddresses) {
            URL url = new URL(urlAddress);
            Config config = Config.defaults();
            URL result = URLAccessRules.webAccess().validate((Configuration)config, url);
            assert (result == url);
        }
    }

    @Test
    void shouldWorkWithNonRangeIps() throws MalformedURLException {
        URL url = new URL("http://localhost/test.csv");
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.cypher_ip_blocklist.name(), "127.0.0.1"}));
        URLAccessValidationError error = (URLAccessValidationError)Assertions.assertThrows(URLAccessValidationError.class, () -> URLAccessRules.webAccess().validate((Configuration)config, url));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)CoreMatchers.containsString((String)"blocked via the configuration property unsupported.dbms.cypher_ip_blocklist"));
    }

    @Test
    void shouldFailForInvalidIps() throws Exception {
        URL url = new URL("http://always.invalid/test.csv");
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.cypher_ip_blocklist.name(), "127.0.0.1"}));
        URLAccessValidationError error = (URLAccessValidationError)Assertions.assertThrows(URLAccessValidationError.class, () -> URLAccessRules.webAccess().validate((Configuration)config, url));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)CoreMatchers.containsString((String)"Unable to verify access to always.invalid"));
    }
}

