/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyCreator;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyDeleter;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyTraverser;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.unsafe.batchinsert.internal.DirectRecordAccessSet;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class, TestDirectoryExtension.class})
class PropertyDeleterTest {
    @Inject
    private TestDirectory directory;
    @Inject
    private RandomRule random;
    private final PropertyTraverser traverser = new PropertyTraverser();
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private PropertyCreator propertyCreator;
    private NeoStores neoStores;
    private PropertyDeleter deleter;
    private JobScheduler scheduler;
    private PageCache pageCache;
    private PropertyStore propertyStore;

    PropertyDeleterTest() {
    }

    private void startStore(boolean log) {
        this.scheduler = JobSchedulerFactory.createInitialisedScheduler();
        Config config = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (String)"8M");
        this.pageCache = new ConfiguringPageCacheFactory(this.directory.getFileSystem(), config, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, (Log)NullLog.getInstance(), EmptyVersionContextSupplier.EMPTY, this.scheduler).getOrCreatePageCache();
        this.neoStores = new StoreFactory(this.directory.databaseLayout(), config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.directory.getFileSystem()), this.pageCache, this.directory.getFileSystem(), (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY).openAllNeoStores(true);
        this.propertyStore = this.neoStores.getPropertyStore();
        this.propertyCreator = new PropertyCreator(this.propertyStore, new PropertyTraverser());
        this.deleter = new PropertyDeleter(this.traverser, this.neoStores, new TokenNameLookup(){

            public String labelGetName(int labelId) {
                return "" + labelId;
            }

            public String relationshipTypeGetName(int relationshipTypeId) {
                return "" + relationshipTypeId;
            }

            public String propertyKeyGetName(int propertyKeyId) {
                return "" + propertyKeyId;
            }
        }, (LogProvider)this.logProvider, Config.defaults((Setting)GraphDatabaseSettings.log_inconsistent_data_deletion, (String)("" + log)));
    }

    @AfterEach
    void stopStore() throws IOException {
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.neoStores, this.pageCache, this.scheduler});
    }

    @ValueSource(strings={"true", "false"})
    @ParameterizedTest
    void shouldHandlePropertyChainDeletionOnCycle(String log) {
        boolean doLog = Boolean.parseBoolean(log);
        this.startStore(doLog);
        NodeStore nodeStore = this.neoStores.getNodeStore();
        NodeRecord node = (NodeRecord)nodeStore.newRecord();
        node.setId(nodeStore.nextId());
        ArrayList<PropertyBlock> properties = new ArrayList<PropertyBlock>();
        for (int i = 0; i < 20; ++i) {
            properties.add(this.encodedValue(i, this.random.nextValue()));
        }
        DirectRecordAccessSet initialChanges = new DirectRecordAccessSet(this.neoStores);
        long firstPropId = this.propertyCreator.createPropertyChain((PrimitiveRecord)node, properties.iterator(), initialChanges.getPropertyRecords());
        node.setNextProp(firstPropId);
        initialChanges.close();
        ArrayList<Value> valuesInTheFirstTwoRecords = new ArrayList<Value>();
        PropertyRecord firstPropRecord = (PropertyRecord)this.propertyStore.getRecord(firstPropId, (AbstractBaseRecord)this.propertyStore.newRecord(), RecordLoad.NORMAL);
        this.readValuesFromPropertyRecord(firstPropRecord, valuesInTheFirstTwoRecords);
        long secondPropId = firstPropRecord.getNextProp();
        PropertyRecord secondPropRecord = (PropertyRecord)this.propertyStore.getRecord(secondPropId, (AbstractBaseRecord)this.propertyStore.newRecord(), RecordLoad.NORMAL);
        this.readValuesFromPropertyRecord(secondPropRecord, valuesInTheFirstTwoRecords);
        secondPropRecord.setNextProp(firstPropId);
        this.propertyStore.updateRecord(secondPropRecord);
        DirectRecordAccessSet changes = new DirectRecordAccessSet(this.neoStores);
        this.deleter.deletePropertyChain((PrimitiveRecord)node, changes.getPropertyRecords());
        changes.close();
        Assertions.assertEquals((long)Record.NO_NEXT_PROPERTY.longValue(), (long)node.getNextProp());
        Assertions.assertFalse((boolean)((PropertyRecord)this.propertyStore.getRecord(firstPropId, (AbstractBaseRecord)this.propertyStore.newRecord(), RecordLoad.CHECK)).inUse());
        Assertions.assertFalse((boolean)((PropertyRecord)this.propertyStore.getRecord(secondPropId, (AbstractBaseRecord)this.propertyStore.newRecord(), RecordLoad.CHECK)).inUse());
        if (doLog) {
            this.logProvider.formattedMessageMatcher().assertContains("Deleted inconsistent property chain with cycle");
            for (Value value : valuesInTheFirstTwoRecords) {
                this.logProvider.formattedMessageMatcher().assertContains(CoreMatchers.containsString((String)value.toString()));
            }
        } else {
            this.logProvider.formattedMessageMatcher().assertNotContains("Deleted inconsistent property chain with cycle");
        }
    }

    @ValueSource(strings={"true", "false"})
    @ParameterizedTest
    void shouldHandlePropertyChainDeletionOnUnusedRecord(String log) {
        boolean doLog = Boolean.parseBoolean(log);
        this.startStore(doLog);
        NodeStore nodeStore = this.neoStores.getNodeStore();
        NodeRecord node = (NodeRecord)nodeStore.newRecord();
        node.setId(nodeStore.nextId());
        ArrayList<PropertyBlock> properties = new ArrayList<PropertyBlock>();
        for (int i = 0; i < 20; ++i) {
            properties.add(this.encodedValue(i, this.random.nextValue()));
        }
        DirectRecordAccessSet initialChanges = new DirectRecordAccessSet(this.neoStores);
        long firstPropId = this.propertyCreator.createPropertyChain((PrimitiveRecord)node, properties.iterator(), initialChanges.getPropertyRecords());
        node.setNextProp(firstPropId);
        initialChanges.close();
        ArrayList<Value> valuesInTheFirstTwoRecords = new ArrayList<Value>();
        PropertyRecord firstPropRecord = (PropertyRecord)this.propertyStore.getRecord(firstPropId, (AbstractBaseRecord)this.propertyStore.newRecord(), RecordLoad.NORMAL);
        this.readValuesFromPropertyRecord(firstPropRecord, valuesInTheFirstTwoRecords);
        long secondPropId = firstPropRecord.getNextProp();
        PropertyRecord secondPropRecord = (PropertyRecord)this.propertyStore.getRecord(secondPropId, (AbstractBaseRecord)this.propertyStore.newRecord(), RecordLoad.NORMAL);
        this.readValuesFromPropertyRecord(secondPropRecord, valuesInTheFirstTwoRecords);
        long thirdPropId = secondPropRecord.getNextProp();
        PropertyRecord thirdPropRecord = (PropertyRecord)this.propertyStore.getRecord(thirdPropId, (AbstractBaseRecord)this.propertyStore.newRecord(), RecordLoad.NORMAL);
        thirdPropRecord.setInUse(false);
        this.propertyStore.updateRecord(thirdPropRecord);
        DirectRecordAccessSet changes = new DirectRecordAccessSet(this.neoStores);
        this.deleter.deletePropertyChain((PrimitiveRecord)node, changes.getPropertyRecords());
        changes.close();
        Assertions.assertEquals((long)Record.NO_NEXT_PROPERTY.longValue(), (long)node.getNextProp());
        Assertions.assertFalse((boolean)((PropertyRecord)this.propertyStore.getRecord(firstPropId, (AbstractBaseRecord)this.propertyStore.newRecord(), RecordLoad.CHECK)).inUse());
        Assertions.assertFalse((boolean)((PropertyRecord)this.propertyStore.getRecord(secondPropId, (AbstractBaseRecord)this.propertyStore.newRecord(), RecordLoad.CHECK)).inUse());
        if (doLog) {
            this.logProvider.formattedMessageMatcher().assertContains("Deleted inconsistent property chain with unused record");
        } else {
            this.logProvider.formattedMessageMatcher().assertNotContains("Deleted inconsistent property chain with unused record");
        }
    }

    @ValueSource(strings={"true", "false"})
    @ParameterizedTest
    void shouldHandlePropertyChainDeletionOnDynamicRecordCycle(String log) {
        boolean doLog = Boolean.parseBoolean(log);
        this.startStore(doLog);
        NodeStore nodeStore = this.neoStores.getNodeStore();
        NodeRecord node = (NodeRecord)nodeStore.newRecord();
        node.setId(nodeStore.nextId());
        List<PropertyBlock> properties = Collections.singletonList(this.encodedValue(0, (Value)this.random.randomValues().nextAsciiTextValue(1000, 1000)));
        DirectRecordAccessSet initialChanges = new DirectRecordAccessSet(this.neoStores);
        long firstPropId = this.propertyCreator.createPropertyChain((PrimitiveRecord)node, properties.iterator(), initialChanges.getPropertyRecords());
        node.setNextProp(firstPropId);
        initialChanges.close();
        PropertyRecord firstPropRecord = (PropertyRecord)this.propertyStore.getRecord(firstPropId, (AbstractBaseRecord)this.propertyStore.newRecord(), RecordLoad.NORMAL);
        PropertyBlock dynamicBlock = (PropertyBlock)firstPropRecord.iterator().next();
        this.createCycleIn(dynamicBlock);
        DirectRecordAccessSet changes = new DirectRecordAccessSet(this.neoStores);
        this.deleter.deletePropertyChain((PrimitiveRecord)node, changes.getPropertyRecords());
        changes.close();
        Assertions.assertEquals((long)Record.NO_NEXT_PROPERTY.longValue(), (long)node.getNextProp());
        if (doLog) {
            this.logProvider.formattedMessageMatcher().assertContains("Deleted inconsistent property chain");
        } else {
            this.logProvider.formattedMessageMatcher().assertNotContains("Deleted inconsistent property chain");
        }
    }

    @ValueSource(strings={"true", "false"})
    @ParameterizedTest
    void shouldHandlePropertyChainDeletionOnUnusedDynamicRecord(String log) {
        boolean doLog = Boolean.parseBoolean(log);
        this.startStore(doLog);
        NodeStore nodeStore = this.neoStores.getNodeStore();
        NodeRecord node = (NodeRecord)nodeStore.newRecord();
        node.setId(nodeStore.nextId());
        List<PropertyBlock> properties = Collections.singletonList(this.encodedValue(0, (Value)this.random.randomValues().nextAsciiTextValue(1000, 1000)));
        DirectRecordAccessSet initialChanges = new DirectRecordAccessSet(this.neoStores);
        long firstPropId = this.propertyCreator.createPropertyChain((PrimitiveRecord)node, properties.iterator(), initialChanges.getPropertyRecords());
        node.setNextProp(firstPropId);
        initialChanges.close();
        PropertyRecord firstPropRecord = (PropertyRecord)this.propertyStore.getRecord(firstPropId, (AbstractBaseRecord)this.propertyStore.newRecord(), RecordLoad.NORMAL);
        PropertyBlock dynamicBlock = (PropertyBlock)firstPropRecord.iterator().next();
        this.makeSomeUnusedIn(dynamicBlock);
        DirectRecordAccessSet changes = new DirectRecordAccessSet(this.neoStores);
        this.deleter.deletePropertyChain((PrimitiveRecord)node, changes.getPropertyRecords());
        changes.close();
        Assertions.assertEquals((long)Record.NO_NEXT_PROPERTY.longValue(), (long)node.getNextProp());
        if (doLog) {
            this.logProvider.formattedMessageMatcher().assertContains("Deleted inconsistent property chain with unused record");
        } else {
            this.logProvider.formattedMessageMatcher().assertNotContains("Deleted inconsistent property chain with unused record");
        }
    }

    @Test
    void shouldLogAsManyPropertiesAsPossibleEvenThoSomeDynamicChainsAreBroken() {
        this.startStore(true);
        NodeStore nodeStore = this.neoStores.getNodeStore();
        NodeRecord node = (NodeRecord)nodeStore.newRecord();
        node.setId(nodeStore.nextId());
        ArrayList<PropertyBlock> properties = new ArrayList<PropertyBlock>();
        Value value1 = this.randomValueWithMaxSingleDynamicRecord();
        Value value2 = this.randomValueWithMaxSingleDynamicRecord();
        TextValue bigValue1 = this.random.nextAlphaNumericTextValue(1000, 1000);
        Value bigValue2 = this.randomLargeLongArray();
        Value value3 = this.randomValueWithMaxSingleDynamicRecord();
        properties.add(this.encodedValue(0, value1));
        properties.add(this.encodedValue(1, value2));
        properties.add(this.encodedValue(2, (Value)bigValue1));
        properties.add(this.encodedValue(3, bigValue2));
        properties.add(this.encodedValue(4, value3));
        DirectRecordAccessSet initialChanges = new DirectRecordAccessSet(this.neoStores);
        long firstPropId = this.propertyCreator.createPropertyChain((PrimitiveRecord)node, properties.iterator(), initialChanges.getPropertyRecords());
        node.setNextProp(firstPropId);
        initialChanges.close();
        List<PropertyBlock> blocksWithDynamicValueRecords = this.getBlocksContainingDynamicValueRecords(firstPropId);
        this.makeSomeUnusedIn((PropertyBlock)this.random.among(blocksWithDynamicValueRecords));
        this.createCycleIn((PropertyBlock)this.random.among(blocksWithDynamicValueRecords));
        DirectRecordAccessSet changes = new DirectRecordAccessSet(this.neoStores);
        this.deleter.deletePropertyChain((PrimitiveRecord)node, changes.getPropertyRecords());
        changes.close();
        Assertions.assertEquals((long)Record.NO_NEXT_PROPERTY.longValue(), (long)node.getNextProp());
        this.logProvider.formattedMessageMatcher().assertContains("Deleted inconsistent property chain");
        this.logProvider.formattedMessageMatcher().assertContains(value1.toString());
        this.logProvider.formattedMessageMatcher().assertContains(value2.toString());
        this.logProvider.formattedMessageMatcher().assertContains(value3.toString());
    }

    private Value randomValueWithMaxSingleDynamicRecord() {
        Value value;
        PropertyBlock encoded;
        while ((encoded = this.encodedValue(0, value = this.random.nextValue())).getValueRecords().size() > 1) {
        }
        return value;
    }

    private List<PropertyBlock> getBlocksContainingDynamicValueRecords(long firstPropId) {
        long propId = firstPropId;
        ArrayList<PropertyBlock> blocks = new ArrayList<PropertyBlock>();
        try (PageCursor cursor = this.propertyStore.openPageCursorForReading(propId);){
            PropertyRecord record = this.propertyStore.newRecord();
            while (!Record.NO_NEXT_PROPERTY.is(propId)) {
                this.propertyStore.getRecordByCursor(propId, (AbstractBaseRecord)record, RecordLoad.NORMAL, cursor);
                this.propertyStore.ensureHeavy(record);
                for (PropertyBlock block : record) {
                    if (block.getValueRecords().size() <= 1) continue;
                    blocks.add(block);
                }
                propId = record.getNextProp();
            }
        }
        return blocks;
    }

    private void makeSomeUnusedIn(PropertyBlock dynamicBlock) {
        this.propertyStore.ensureHeavy(dynamicBlock);
        DynamicRecord valueRecord = (DynamicRecord)dynamicBlock.getValueRecords().get(this.random.nextInt(dynamicBlock.getValueRecords().size()));
        PropertyType type = valueRecord.getType();
        valueRecord.setInUse(false);
        DynamicStringStore dynamicStore = type == PropertyType.STRING ? this.propertyStore.getStringStore() : this.propertyStore.getArrayStore();
        dynamicStore.updateRecord((AbstractBaseRecord)valueRecord);
    }

    private void createCycleIn(PropertyBlock dynamicBlock) {
        this.propertyStore.ensureHeavy(dynamicBlock);
        int cycleEndIndex = this.random.nextInt(1, dynamicBlock.getValueRecords().size() - 1);
        int cycleStartIndex = this.random.nextInt(cycleEndIndex);
        DynamicRecord cycleEndRecord = (DynamicRecord)dynamicBlock.getValueRecords().get(cycleEndIndex);
        PropertyType type = cycleEndRecord.getType();
        cycleEndRecord.setNextBlock(((DynamicRecord)dynamicBlock.getValueRecords().get(cycleStartIndex)).getId());
        DynamicStringStore dynamicStore = type == PropertyType.STRING ? this.propertyStore.getStringStore() : this.propertyStore.getArrayStore();
        dynamicStore.updateRecord((AbstractBaseRecord)cycleEndRecord);
    }

    private Value randomLargeLongArray() {
        long[] array = new long[200];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.random.nextLong();
        }
        return Values.of((Object)array);
    }

    private PropertyBlock encodedValue(int key, Value value) {
        PropertyBlock block = new PropertyBlock();
        this.propertyStore.encodeValue(block, key, value);
        return block;
    }

    private void readValuesFromPropertyRecord(PropertyRecord record, List<Value> values) {
        for (PropertyBlock block : record) {
            values.add(block.getType().value(block, this.propertyStore));
        }
    }
}

