/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.InconsistentDataReadException;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyCreator;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyTraverser;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordPropertyCursor;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.unsafe.batchinsert.internal.DirectRecordAccessSet;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;

public class RecordPropertyCursorTest {
    @Rule
    public final PageCacheAndDependenciesRule storage = new PageCacheAndDependenciesRule();
    @Rule
    public final RandomRule random = new RandomRule().withConfiguration((RandomValues.Configuration)new RandomValues.Default(){

        public int stringMaxLength() {
            return 10000;
        }
    });
    private NeoStores neoStores;
    private PropertyCreator creator;
    private NodeRecord owner;

    @Before
    public void setup() {
        this.neoStores = new StoreFactory(this.storage.directory().databaseLayout(), Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.storage.fileSystem()), this.storage.pageCache(), this.storage.fileSystem(), (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY).openAllNeoStores(true);
        this.creator = new PropertyCreator(this.neoStores.getPropertyStore(), new PropertyTraverser());
        this.owner = (NodeRecord)this.neoStores.getNodeStore().newRecord();
    }

    @After
    public void closeStore() {
        this.neoStores.close();
    }

    @Test
    public void shouldReadPropertyChain() {
        Value[] values = this.createValues();
        long firstPropertyId = this.storeValuesAsPropertyChain(this.creator, this.owner, values);
        this.assertPropertyChain(values, firstPropertyId, this.createCursor());
    }

    @Test
    public void shouldReuseCursor() {
        Value[] valuesA = this.createValues();
        long firstPropertyIdA = this.storeValuesAsPropertyChain(this.creator, this.owner, valuesA);
        Value[] valuesB = this.createValues();
        long firstPropertyIdB = this.storeValuesAsPropertyChain(this.creator, this.owner, valuesB);
        RecordPropertyCursor cursor = this.createCursor();
        this.assertPropertyChain(valuesA, firstPropertyIdA, cursor);
        this.assertPropertyChain(valuesB, firstPropertyIdB, cursor);
    }

    @Test
    public void closeShouldBeIdempotent() {
        RecordPropertyCursor cursor = this.createCursor();
        cursor.close();
        cursor.close();
    }

    @Test
    public void shouldAbortChainTraversalOnLikelyCycle() {
        Value[] values = this.createValues(20);
        long firstProp = this.storeValuesAsPropertyChain(this.creator, this.owner, values);
        PropertyStore store = this.neoStores.getPropertyStore();
        PropertyRecord firstRecord = (PropertyRecord)store.getRecord(firstProp, (AbstractBaseRecord)store.newRecord(), RecordLoad.NORMAL);
        long secondProp = firstRecord.getNextProp();
        PropertyRecord secondRecord = (PropertyRecord)store.getRecord(secondProp, (AbstractBaseRecord)store.newRecord(), RecordLoad.NORMAL);
        secondRecord.setNextProp(firstProp);
        store.updateRecord(secondRecord);
        this.owner.setId(99L);
        RecordPropertyCursor cursor = this.createCursor();
        cursor.init(firstProp, this.owner.getId(), EntityType.NODE);
        InconsistentDataReadException e = (InconsistentDataReadException)Assertions.assertThrows(InconsistentDataReadException.class, () -> {
            while (cursor.next()) {
            }
        });
        Assert.assertEquals((Object)String.format("Aborting property reading due to detected chain cycle, starting at property record id:%d from owner NODE:%d", firstProp, this.owner.getId()), (Object)e.getMessage());
    }

    @Test
    public void shouldAbortChainTraversalOnLikelyDynamicValueCycle() {
        TextValue value = this.random.nextAlphaNumericTextValue(1000, 1000);
        long firstProp = this.storeValuesAsPropertyChain(this.creator, this.owner, new Value[]{value});
        PropertyStore store = this.neoStores.getPropertyStore();
        PropertyRecord propertyRecord = (PropertyRecord)store.getRecord(firstProp, (AbstractBaseRecord)store.newRecord(), RecordLoad.NORMAL);
        store.ensureHeavy(propertyRecord);
        PropertyBlock block = (PropertyBlock)propertyRecord.iterator().next();
        int cycleEndRecordIndex = this.random.nextInt(1, block.getValueRecords().size() - 1);
        DynamicRecord cycle = (DynamicRecord)block.getValueRecords().get(cycleEndRecordIndex);
        int cycleStartIndex = this.random.nextInt(cycleEndRecordIndex);
        cycle.setNextBlock(((DynamicRecord)block.getValueRecords().get(cycleStartIndex)).getId());
        store.getStringStore().updateRecord((AbstractBaseRecord)cycle);
        this.owner.setId(99L);
        RecordPropertyCursor cursor = this.createCursor();
        cursor.init(firstProp, this.owner.getId(), EntityType.NODE);
        InconsistentDataReadException e = (InconsistentDataReadException)Assertions.assertThrows(InconsistentDataReadException.class, () -> {
            while (cursor.next()) {
                cursor.propertyValue();
            }
        });
        Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Unable to read property value in"));
        Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)("owner NODE:" + this.owner.getId())));
    }

    private RecordPropertyCursor createCursor() {
        return new RecordPropertyCursor(this.neoStores.getPropertyStore());
    }

    private void assertPropertyChain(Value[] values, long firstPropertyId, RecordPropertyCursor cursor) {
        Map<Integer, Value> expectedValues = this.asMap(values);
        cursor.init(firstPropertyId, this.owner.getId(), EntityType.NODE);
        while (cursor.next()) {
            Assert.assertEquals((Object)expectedValues.remove(cursor.propertyKey()), (Object)cursor.propertyValue());
        }
        Assert.assertTrue((boolean)expectedValues.isEmpty());
    }

    private Value[] createValues() {
        return this.createValues(this.random.nextInt(1, 20));
    }

    private Value[] createValues(int numberOfProperties) {
        Value[] values = new Value[numberOfProperties];
        for (int key = 0; key < numberOfProperties; ++key) {
            values[key] = this.random.nextValue();
        }
        return values;
    }

    private long storeValuesAsPropertyChain(PropertyCreator creator, NodeRecord owner, Value[] values) {
        DirectRecordAccessSet access = new DirectRecordAccessSet(this.neoStores);
        long firstPropertyId = creator.createPropertyChain((PrimitiveRecord)owner, this.blocksOf(creator, values), access.getPropertyRecords());
        access.close();
        return firstPropertyId;
    }

    private Map<Integer, Value> asMap(Value[] values) {
        HashMap<Integer, Value> map = new HashMap<Integer, Value>();
        for (int key = 0; key < values.length; ++key) {
            map.put(key, values[key]);
        }
        return map;
    }

    private Iterator<PropertyBlock> blocksOf(final PropertyCreator creator, Value[] values) {
        return new IteratorWrapper<PropertyBlock, Value>(Iterators.iterator((Object[])values)){
            int key;

            protected PropertyBlock underlyingObjectToObject(Value value) {
                return creator.encodePropertyValue(this.key++, value);
            }
        };
    }
}

