/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.util.function.LongFunction;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.factory.primitive.LongObjectMaps;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyDeleter;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyTraverser;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RelationshipDeleter;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RelationshipGroupGetter;
import org.neo4j.kernel.impl.store.id.BatchingIdSequence;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RecordAccessSet;
import org.neo4j.kernel.impl.transaction.state.RecordChangeSet;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.lock.ResourceLocker;

class RelationshipDeleterTest {
    private static final long NULL = Record.NULL_REFERENCE.longValue();
    private RelationshipDeleter deleter;
    private MutableLongObjectMap<NodeRecord> nodeStore;
    private MutableLongObjectMap<RelationshipRecord> relationshipStore;
    private MutableLongObjectMap<RelationshipGroupRecord> groupStore;
    private RecordAccessSet recordChanges;
    private final ResourceLocker ignoreLocks = (tracer, resourceType, resourceIds) -> {};

    RelationshipDeleterTest() {
    }

    @BeforeEach
    void setUp() {
        RelationshipGroupGetter relationshipGroupGetter = new RelationshipGroupGetter((IdSequence)new BatchingIdSequence());
        PropertyTraverser propertyTraverser = new PropertyTraverser();
        PropertyDeleter propertyDeleter = new PropertyDeleter(propertyTraverser, null, null, (LogProvider)NullLogProvider.getInstance(), null);
        this.deleter = new RelationshipDeleter(relationshipGroupGetter, propertyDeleter);
        this.nodeStore = LongObjectMaps.mutable.empty();
        this.relationshipStore = LongObjectMaps.mutable.empty();
        this.groupStore = LongObjectMaps.mutable.empty();
        this.recordChanges = new RecordChangeSet(this.loader(this.nodeStore, NodeRecord::new), this.noLoader(), this.loader(this.relationshipStore, RelationshipRecord::new), this.loader(this.groupStore, RelationshipGroupRecord::new), this.noLoader(), this.noLoader(), this.noLoader(), this.noLoader());
    }

    @Test
    void shouldDecrementDegreeOnceOnFirstIfLoopOnSparseChain() {
        long startNode = 1L;
        long otherNode1 = 2L;
        long otherNode2 = 3L;
        long relA = 11L;
        long relB = 12L;
        long relC = 13L;
        int type = 0;
        this.nodeStore.put(startNode, (Object)new NodeRecord(startNode).initialize(true, NULL, false, relA, Record.NO_LABELS_FIELD.longValue()));
        this.nodeStore.put(otherNode1, (Object)new NodeRecord(otherNode1).initialize(true, NULL, false, relB, Record.NO_LABELS_FIELD.longValue()));
        this.nodeStore.put(otherNode2, (Object)new NodeRecord(otherNode2).initialize(true, NULL, false, relC, Record.NO_LABELS_FIELD.longValue()));
        this.relationshipStore.put(relA, (Object)new RelationshipRecord(relA).initialize(true, NULL, startNode, startNode, type, 3L, relB, 3L, relB, true, true));
        this.relationshipStore.put(relB, (Object)new RelationshipRecord(relB).initialize(true, NULL, startNode, otherNode1, type, relA, relC, 1L, NULL, false, true));
        this.relationshipStore.put(relC, (Object)new RelationshipRecord(relC).initialize(true, NULL, startNode, otherNode2, type, relB, NULL, 1L, NULL, false, true));
        this.deleter.relDelete(relB, this.recordChanges, this.ignoreLocks);
        RecordAccess.RecordProxy relAChange = this.recordChanges.getRelRecords().getIfLoaded(relA);
        Assertions.assertTrue((boolean)relAChange.isChanged());
        Assertions.assertEquals((long)2L, (long)((RelationshipRecord)relAChange.forReadingData()).getFirstPrevRel());
        Assertions.assertEquals((long)2L, (long)((RelationshipRecord)relAChange.forReadingData()).getSecondPrevRel());
    }

    @Test
    void shouldDecrementDegreeOnceOnFirstIfLoopOnDenseLoopChain() {
        long node = 1L;
        long groupG = 7L;
        long groupH = 8L;
        long relA = 11L;
        long relB = 12L;
        long relC = 13L;
        int type = 1;
        this.groupStore.put(groupG, (Object)new RelationshipGroupRecord(groupG).initialize(true, 0, NULL, NULL, NULL, node, groupH));
        this.groupStore.put(groupH, (Object)new RelationshipGroupRecord(groupH).initialize(true, type, NULL, NULL, relA, node, NULL));
        this.nodeStore.put(node, (Object)new NodeRecord(node).initialize(true, NULL, true, groupG, Record.NO_LABELS_FIELD.longValue()));
        this.relationshipStore.put(relA, (Object)new RelationshipRecord(relA).initialize(true, NULL, node, node, type, 3L, relB, 3L, relB, true, true));
        this.relationshipStore.put(relB, (Object)new RelationshipRecord(relB).initialize(true, NULL, node, node, type, relA, relC, relA, relC, false, false));
        this.relationshipStore.put(relC, (Object)new RelationshipRecord(relC).initialize(true, NULL, node, node, type, relB, NULL, relB, NULL, false, false));
        this.deleter.relDelete(relB, this.recordChanges, this.ignoreLocks);
        RecordAccess.RecordProxy relAChange = this.recordChanges.getRelRecords().getIfLoaded(relA);
        Assertions.assertTrue((boolean)relAChange.isChanged());
        Assertions.assertEquals((long)2L, (long)((RelationshipRecord)relAChange.forReadingData()).getFirstPrevRel());
        Assertions.assertEquals((long)2L, (long)((RelationshipRecord)relAChange.forReadingData()).getSecondPrevRel());
    }

    private <T extends AbstractBaseRecord, R> RecordAccess.Loader<T, R> noLoader() {
        return this.loader(LongObjectMaps.mutable.empty(), id -> {
            throw new IllegalStateException("Should not be needed");
        });
    }

    private <T extends AbstractBaseRecord, R> RecordAccess.Loader<T, R> loader(final MutableLongObjectMap<T> store, final LongFunction<T> factory) {
        return new RecordAccess.Loader<T, R>(){

            public T newUnused(long key, R additionalData) {
                AbstractBaseRecord record = (AbstractBaseRecord)factory.apply(key);
                record.setCreated();
                return record;
            }

            public T load(long key, R additionalData) {
                AbstractBaseRecord record = (AbstractBaseRecord)store.get(key);
                assert (record != null);
                return record;
            }

            public void ensureHeavy(T record) {
            }

            public T clone(T record) {
                return record.clone();
            }
        };
    }
}

