/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.function.Supplier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.neo4j.helpers.Exceptions;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.IntStoreHeader;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.format.FullyCoveringRecordKeys;
import org.neo4j.kernel.impl.store.format.LimitedRecordGenerators;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.RecordGenerators;
import org.neo4j.kernel.impl.store.format.RecordKey;
import org.neo4j.kernel.impl.store.format.RecordKeys;
import org.neo4j.kernel.impl.store.id.BatchingIdSequence;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.test.impl.EphemeralPageSwapperFactory;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.SuppressOutput;

public abstract class AbstractRecordFormatTest {
    private static final int PAGE_SIZE = 128;
    protected static final long TEST_ITERATIONS = 100000L;
    protected static final long TEST_TIME = 1000L;
    protected static final int DATA_SIZE = 100;
    protected static final long NULL = Record.NULL_REFERENCE.intValue();
    protected final RandomRule random = new RandomRule();
    private final EphemeralPageSwapperFactory swapperFactory = new EphemeralPageSwapperFactory();
    private final PageCacheRule pageCacheRule = new PageCacheRule(PageCacheRule.config().withPageSize(128));
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public final TestName name = new TestName();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.pageCacheRule).around((TestRule)this.random);
    protected PageCache pageCache;
    public RecordKeys keys = FullyCoveringRecordKeys.INSTANCE;
    protected final RecordFormats formats;
    private final int entityBits;
    private final int propertyBits;
    protected RecordGenerators generators;

    protected AbstractRecordFormatTest(RecordFormats formats, int entityBits, int propertyBits) {
        this.formats = formats;
        this.entityBits = entityBits;
        this.propertyBits = propertyBits;
    }

    @Before
    public void setupPageCache() {
        this.pageCache = this.pageCacheRule.getPageCache((PageSwapperFactory)this.swapperFactory);
    }

    @After
    public void clearSwappers() {
        this.swapperFactory.close();
    }

    @Before
    public void before() {
        this.generators = new LimitedRecordGenerators(this.random.randomValues(), this.entityBits, this.propertyBits, 40, 16, -1L);
    }

    @Test
    public void node() throws Exception {
        this.verifyWriteAndRead(() -> ((RecordFormats)this.formats).node(), this.generators::node, this.keys::node, true);
    }

    @Test
    public void relationship() throws Exception {
        this.verifyWriteAndRead(() -> ((RecordFormats)this.formats).relationship(), this.generators::relationship, this.keys::relationship, true);
    }

    @Test
    public void property() throws Exception {
        this.verifyWriteAndRead(() -> ((RecordFormats)this.formats).property(), this.generators::property, this.keys::property, false);
    }

    @Test
    public void relationshipGroup() throws Exception {
        this.verifyWriteAndRead(() -> ((RecordFormats)this.formats).relationshipGroup(), this.generators::relationshipGroup, this.keys::relationshipGroup, false);
    }

    @Test
    public void relationshipTypeToken() throws Exception {
        this.verifyWriteAndRead(() -> ((RecordFormats)this.formats).relationshipTypeToken(), this.generators::relationshipTypeToken, this.keys::relationshipTypeToken, false);
    }

    @Test
    public void propertyKeyToken() throws Exception {
        this.verifyWriteAndRead(() -> ((RecordFormats)this.formats).propertyKeyToken(), this.generators::propertyKeyToken, this.keys::propertyKeyToken, false);
    }

    @Test
    public void labelToken() throws Exception {
        this.verifyWriteAndRead(() -> ((RecordFormats)this.formats).labelToken(), this.generators::labelToken, this.keys::labelToken, false);
    }

    @Test
    public void dynamic() throws Exception {
        this.verifyWriteAndRead(() -> ((RecordFormats)this.formats).dynamic(), this.generators::dynamic, this.keys::dynamic, false);
    }

    private <R extends AbstractBaseRecord> void verifyWriteAndRead(Supplier<RecordFormat<R>> formatSupplier, Supplier<RecordGenerators.Generator<R>> generatorSupplier, Supplier<RecordKey<R>> keySupplier, boolean assertPostReadOffset) throws IOException {
        RecordFormat<R> format = formatSupplier.get();
        RecordKey<R> key = keySupplier.get();
        RecordGenerators.Generator<R> generator = generatorSupplier.get();
        int recordSize = format.getRecordSize((StoreHeader)new IntStoreHeader(100));
        BatchingIdSequence idSequence = new BatchingIdSequence(1L);
        try (PagedFile storeFile = this.pageCache.map(new File("store-" + this.name.getMethodName()), Math.max(recordSize, 64), new OpenOption[]{StandardOpenOption.CREATE});){
            long time = System.currentTimeMillis();
            long endTime = time + 1000L;
            for (long i = 0L; i < 100000L && System.currentTimeMillis() < endTime; ++i) {
                R written = generator.get(recordSize, format, this.random.nextLong(1L, format.getMaxId()));
                this.verifyWriteAndReadRecord(assertPostReadOffset, format, key, recordSize, idSequence, storeFile, i, written);
            }
        }
    }

    protected <R extends AbstractBaseRecord> R verifyWriteAndReadRecord(boolean assertPostReadOffset, RecordFormat<R> format, RecordKey<R> key, int recordSize, BatchingIdSequence idSequence, PagedFile storeFile, long i, R written) throws IOException {
        AbstractBaseRecord read = format.newRecord();
        AbstractBaseRecord read2 = format.newRecord();
        try {
            this.writeRecord(written, format, storeFile, recordSize, idSequence, true);
            this.readAndVerifyRecord(written, read, format, key, storeFile, recordSize, assertPostReadOffset);
            this.writeRecord(read, format, storeFile, recordSize, idSequence, false);
            this.readAndVerifyRecord(read, read2, format, key, storeFile, recordSize, assertPostReadOffset);
            idSequence.reset();
            return (R)read2;
        }
        catch (Throwable t) {
            StringBuilder sb = new StringBuilder(t.getMessage()).append(System.lineSeparator());
            sb.append("Initially written:         ").append(written).append(System.lineSeparator());
            sb.append("Read back:                 ").append(read).append(System.lineSeparator());
            sb.append("Wrote and read back again: ").append(read2).append(System.lineSeparator());
            sb.append("Seed:                      ").append(this.random.seed()).append(System.lineSeparator());
            sb.append("Iteration:                 ").append(i).append(System.lineSeparator());
            Exceptions.setMessage((Throwable)t, (String)sb.toString());
            throw t;
        }
    }

    private <R extends AbstractBaseRecord> void readAndVerifyRecord(R written, R read, RecordFormat<R> format, RecordKey<R> key, PagedFile storeFile, int recordSize, boolean assertPostReadOffset) throws IOException {
        try (PageCursor cursor = storeFile.io(0L, 1);){
            this.assertedNext(cursor);
            read.setId(written.getId());
            this.readRecord(read, format, cursor, recordSize, RecordLoad.NORMAL);
            this.assertWithinBounds(written, cursor, "reading");
            if (assertPostReadOffset) {
                Assert.assertEquals((String)"Cursor is positioned on first byte of next record after a read", (long)recordSize, (long)cursor.getOffset());
            }
            cursor.checkAndClearCursorException();
            Assert.assertEquals((Object)written.inUse(), (Object)read.inUse());
            if (written.inUse()) {
                Assert.assertEquals((long)written.getId(), (long)read.getId());
                Assert.assertEquals((Object)written.requiresSecondaryUnit(), (Object)read.requiresSecondaryUnit());
                if (written.requiresSecondaryUnit()) {
                    Assert.assertEquals((long)written.getSecondaryUnitId(), (long)read.getSecondaryUnitId());
                }
                key.assertRecordsEquals(written, read);
            }
        }
    }

    protected <R extends AbstractBaseRecord> void readRecord(R read, RecordFormat<R> format, PageCursor cursor, int recordSize, RecordLoad mode) throws IOException {
        cursor.mark();
        do {
            cursor.setOffsetToMark();
            format.read(read, cursor, mode, recordSize);
        } while (cursor.shouldRetry());
    }

    protected <R extends AbstractBaseRecord> void writeRecord(R record, RecordFormat<R> format, PagedFile storeFile, int recordSize, BatchingIdSequence idSequence, boolean prepare) throws IOException {
        try (PageCursor cursor = storeFile.io(0L, 2);){
            this.assertedNext(cursor);
            if (prepare && record.inUse()) {
                format.prepare(record, recordSize, (IdSequence)idSequence);
            }
            cursor.setOffset(0);
            format.write(record, cursor, recordSize);
            this.assertWithinBounds(record, cursor, "writing");
        }
    }

    private <R extends AbstractBaseRecord> void assertWithinBounds(R record, PageCursor cursor, String operation) {
        if (cursor.checkAndClearBoundsFlag()) {
            Assert.fail((String)("Out-of-bounds when " + operation + " record " + record));
        }
    }

    protected void assertedNext(PageCursor cursor) throws IOException {
        Assert.assertTrue((boolean)cursor.next());
    }
}

