/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.config.SettingGroup;
import org.neo4j.kernel.configuration.Connector;

public abstract class ConnectorValidator
implements SettingGroup<Object> {
    private static final Set<String> validTypes = Arrays.stream(Connector.ConnectorType.values()).map(Enum::name).collect(Collectors.toSet());
    static final String DEPRECATED_CONNECTOR_MSG = "Warning: connectors with names other than [http,https,bolt] are%ndeprecated and support for them will be removed in a future%nversion of Neo4j. Offending lines in neo4j.conf:%n%n%s";
    protected final Connector.ConnectorType type;

    public ConnectorValidator(@Nonnull Connector.ConnectorType type) {
        this.type = type;
    }

    public boolean owns(@Nonnull String key, @Nonnull Map<String, String> rawConfig) throws InvalidSettingException {
        String[] parts = key.split("\\.");
        if (parts.length < 2) {
            return false;
        }
        if (!parts[0].equals("dbms") || !parts[1].equals("connector")) {
            return false;
        }
        if (parts.length != 4) {
            throw new InvalidSettingException(String.format("Invalid connector setting: %s", key));
        }
        String groupKey = parts[2];
        String typeKey = String.join((CharSequence)".", parts[0], parts[1], groupKey, "type");
        String typeValue = rawConfig.get(typeKey);
        if (typeValue == null) {
            if (groupKey.equalsIgnoreCase("http") || groupKey.equalsIgnoreCase("https")) {
                typeValue = Connector.ConnectorType.HTTP.name();
            } else if (groupKey.equalsIgnoreCase("bolt")) {
                typeValue = Connector.ConnectorType.BOLT.name();
            }
        }
        if (typeValue == null) {
            throw new InvalidSettingException(String.format("Missing mandatory value for '%s'", typeKey));
        }
        if (!validTypes.contains(typeValue)) {
            throw new InvalidSettingException(String.format("'%s' must be one of %s; not '%s'", typeKey, String.join((CharSequence)", ", validTypes), typeValue));
        }
        return this.type.name().equals(typeValue);
    }

    @Nonnull
    public Stream<Map.Entry<String, String>> ownedEntries(@Nonnull Map<String, String> params) throws InvalidSettingException {
        return params.entrySet().stream().filter(it -> this.owns((String)it.getKey(), params));
    }

    @Nonnull
    public Map<String, String> validate(@Nonnull Map<String, String> rawConfig, @Nonnull Consumer<String> warningConsumer) throws InvalidSettingException {
        HashMap<String, String> result = new HashMap<String, String>();
        this.ownedEntries(rawConfig).forEach(s -> result.putAll(this.getSettingFor((String)s.getKey(), rawConfig).orElseThrow(() -> new InvalidSettingException(String.format("Invalid connector setting: %s", s.getKey()))).validate(rawConfig, warningConsumer)));
        this.warnAboutDeprecatedConnectors(result, warningConsumer);
        return result;
    }

    private void warnAboutDeprecatedConnectors(@Nonnull Map<String, String> connectorSettings, @Nonnull Consumer<String> warningConsumer) {
        HashSet nonDefaultConnectors = new HashSet();
        connectorSettings.entrySet().stream().map(Map.Entry::getKey).filter(settingKey -> {
            String name = settingKey.split("\\.")[2];
            return this.isDeprecatedConnectorName(name);
        }).forEach(nonDefaultConnectors::add);
        if (!nonDefaultConnectors.isEmpty()) {
            warningConsumer.accept(String.format(DEPRECATED_CONNECTOR_MSG, nonDefaultConnectors.stream().sorted().map(s -> String.format(">  %s%n", s)).collect(Collectors.joining())));
        }
    }

    protected boolean isDeprecatedConnectorName(String name) {
        return !name.equalsIgnoreCase("http") && !name.equalsIgnoreCase("https") && !name.equalsIgnoreCase("bolt");
    }

    @Nonnull
    public Map<String, Object> values(@Nonnull Map<String, String> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.ownedEntries(params).forEach(s -> result.putAll(this.getSettingFor((String)s.getKey(), params).orElseThrow(() -> new InvalidSettingException(String.format("Invalid connector setting: %s", s.getKey()))).values(params)));
        return result;
    }

    @Nonnull
    protected abstract Optional<Setting<Object>> getSettingFor(@Nonnull String var1, @Nonnull Map<String, String> var2);

    public List<Setting<Object>> settings(@Nonnull Map<String, String> params) {
        return this.ownedEntries(params).map(e -> this.getSettingFor((String)e.getKey(), params)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public boolean deprecated() {
        return false;
    }

    public Optional<String> replacement() {
        return Optional.empty();
    }

    public boolean internal() {
        return false;
    }

    public boolean secret() {
        return false;
    }

    public Optional<String> documentedDefaultValue() {
        return Optional.empty();
    }

    public String valueDescription() {
        return "a group of connector settings";
    }

    public Optional<String> description() {
        return Optional.empty();
    }

    public boolean dynamic() {
        return false;
    }
}

