/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.PropertyDeleter;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RelationshipConnection;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RelationshipCreator;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RelationshipGroupGetter;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.state.DirectionIdentifier;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RecordAccessSet;
import org.neo4j.kernel.impl.util.DirectionWrapper;
import org.neo4j.storageengine.api.lock.LockTracer;
import org.neo4j.storageengine.api.lock.ResourceLocker;
import org.neo4j.storageengine.api.lock.ResourceType;

class RelationshipDeleter {
    private final RelationshipGroupGetter relGroupGetter;
    private final PropertyDeleter propertyChainDeleter;

    RelationshipDeleter(RelationshipGroupGetter relGroupGetter, PropertyDeleter propertyChainDeleter) {
        this.relGroupGetter = relGroupGetter;
        this.propertyChainDeleter = propertyChainDeleter;
    }

    void relDelete(long id, RecordAccessSet recordChanges, ResourceLocker locks) {
        RelationshipRecord record = recordChanges.getRelRecords().getOrLoad(id, null).forChangingLinkage();
        this.propertyChainDeleter.deletePropertyChain(record, recordChanges.getPropertyRecords());
        this.disconnectRelationship(record, recordChanges, locks);
        this.updateNodesForDeletedRelationship(record, recordChanges, locks);
        record.setInUse(false);
        record.setType(-1);
    }

    private void disconnectRelationship(RelationshipRecord rel, RecordAccessSet recordChangeSet, ResourceLocker locks) {
        this.disconnect(rel, RelationshipConnection.START_NEXT, recordChangeSet.getRelRecords(), locks);
        this.disconnect(rel, RelationshipConnection.START_PREV, recordChangeSet.getRelRecords(), locks);
        this.disconnect(rel, RelationshipConnection.END_NEXT, recordChangeSet.getRelRecords(), locks);
        this.disconnect(rel, RelationshipConnection.END_PREV, recordChangeSet.getRelRecords(), locks);
    }

    private void disconnect(RelationshipRecord rel, RelationshipConnection pointer, RecordAccess<RelationshipRecord, Void> relChanges, ResourceLocker locks) {
        long otherRelId = pointer.otherSide().get(rel);
        if (otherRelId == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            return;
        }
        locks.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{otherRelId});
        RelationshipRecord otherRel = relChanges.getOrLoad(otherRelId, null).forChangingLinkage();
        boolean changed = false;
        long newId = pointer.get(rel);
        boolean newIsFirst = pointer.isFirstInChain(rel);
        if (otherRel.getFirstNode() == pointer.compareNode(rel)) {
            pointer.start().set(otherRel, newId, newIsFirst);
            changed = true;
        }
        if (otherRel.getSecondNode() == pointer.compareNode(rel)) {
            pointer.end().set(otherRel, newId, newIsFirst);
            changed = true;
        }
        if (!changed) {
            throw new InvalidRecordException(otherRel + " don't match " + rel);
        }
    }

    private void updateNodesForDeletedRelationship(RelationshipRecord rel, RecordAccessSet recordChanges, ResourceLocker locks) {
        RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> groupChange;
        boolean loop;
        RecordAccess.RecordProxy<NodeRecord, Object> startNodeChange = recordChanges.getNodeRecords().getOrLoad(rel.getFirstNode(), null);
        RecordAccess.RecordProxy<NodeRecord, Object> endNodeChange = recordChanges.getNodeRecords().getOrLoad(rel.getSecondNode(), null);
        NodeRecord startNode = recordChanges.getNodeRecords().getOrLoad(rel.getFirstNode(), null).forReadingLinkage();
        NodeRecord endNode = recordChanges.getNodeRecords().getOrLoad(rel.getSecondNode(), null).forReadingLinkage();
        boolean bl = loop = startNode.getId() == endNode.getId();
        if (!startNode.isDense()) {
            if (rel.isFirstInFirstChain()) {
                startNode = startNodeChange.forChangingLinkage();
                startNode.setNextRel(rel.getFirstNextRel());
            }
            this.decrementTotalRelationshipCount(startNode.getId(), rel, startNode.getNextRel(), recordChanges.getRelRecords(), locks);
        } else {
            groupChange = this.relGroupGetter.getRelationshipGroup(startNode, rel.getType(), recordChanges.getRelGroupRecords()).group();
            assert (groupChange != null) : "Relationship group " + rel.getType() + " should have existed here";
            RelationshipGroupRecord group = groupChange.forReadingData();
            DirectionWrapper dir = DirectionIdentifier.wrapDirection(rel, startNode);
            if (rel.isFirstInFirstChain()) {
                group = groupChange.forChangingData();
                dir.setNextRel(group, rel.getFirstNextRel());
                if (this.groupIsEmpty(group)) {
                    this.deleteGroup(startNodeChange, group, recordChanges.getRelGroupRecords());
                }
            }
            this.decrementTotalRelationshipCount(startNode.getId(), rel, dir.getNextRel(group), recordChanges.getRelRecords(), locks);
        }
        if (!endNode.isDense()) {
            if (rel.isFirstInSecondChain()) {
                endNode = endNodeChange.forChangingLinkage();
                endNode.setNextRel(rel.getSecondNextRel());
            }
            if (!loop) {
                this.decrementTotalRelationshipCount(endNode.getId(), rel, endNode.getNextRel(), recordChanges.getRelRecords(), locks);
            }
        } else {
            groupChange = this.relGroupGetter.getRelationshipGroup(endNode, rel.getType(), recordChanges.getRelGroupRecords()).group();
            DirectionWrapper dir = DirectionIdentifier.wrapDirection(rel, endNode);
            assert (groupChange != null || loop) : "Group has been deleted";
            if (groupChange != null && rel.isFirstInSecondChain()) {
                RelationshipGroupRecord group = groupChange.forChangingData();
                dir.setNextRel(group, rel.getSecondNextRel());
                if (this.groupIsEmpty(group)) {
                    this.deleteGroup(endNodeChange, group, recordChanges.getRelGroupRecords());
                }
            }
            if (!loop) {
                this.decrementTotalRelationshipCount(endNode.getId(), rel, dir.getNextRel(groupChange.forChangingData()), recordChanges.getRelRecords(), locks);
            }
        }
    }

    private void decrementTotalRelationshipCount(long nodeId, RelationshipRecord rel, long firstRelId, RecordAccess<RelationshipRecord, Void> relRecords, ResourceLocker locks) {
        RelationshipRecord firstRel;
        if (firstRelId == (long)Record.NO_PREV_RELATIONSHIP.intValue()) {
            return;
        }
        boolean firstInChain = this.relIsFirstInChain(nodeId, rel);
        if (!firstInChain) {
            locks.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{firstRelId});
        }
        if (nodeId == (firstRel = relRecords.getOrLoad(firstRelId, null).forChangingLinkage()).getFirstNode()) {
            firstRel.setFirstPrevRel(firstInChain ? (long)(RelationshipCreator.relCount(nodeId, rel) - 1) : firstRel.getFirstPrevRel() - 1L);
            firstRel.setFirstInFirstChain(true);
        }
        if (nodeId == firstRel.getSecondNode()) {
            firstRel.setSecondPrevRel(firstInChain ? (long)(RelationshipCreator.relCount(nodeId, rel) - 1) : firstRel.getSecondPrevRel() - 1L);
            firstRel.setFirstInSecondChain(true);
        }
    }

    private void deleteGroup(RecordAccess.RecordProxy<NodeRecord, Void> nodeChange, RelationshipGroupRecord group, RecordAccess<RelationshipGroupRecord, Integer> relGroupRecords) {
        long previous = group.getPrev();
        long next = group.getNext();
        if (previous == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            nodeChange.forChangingLinkage().setNextRel(next);
        } else {
            RelationshipGroupRecord previousRecord = relGroupRecords.getOrLoad(previous, null).forChangingLinkage();
            previousRecord.setNext(next);
        }
        if (next != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RelationshipGroupRecord nextRecord = relGroupRecords.getOrLoad(next, null).forChangingLinkage();
            nextRecord.setPrev(previous);
        }
        group.setInUse(false);
    }

    private boolean groupIsEmpty(RelationshipGroupRecord group) {
        return group.getFirstOut() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() && group.getFirstIn() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() && group.getFirstLoop() == (long)Record.NO_NEXT_RELATIONSHIP.intValue();
    }

    private boolean relIsFirstInChain(long nodeId, RelationshipRecord rel) {
        return nodeId == rel.getFirstNode() && rel.isFirstInFirstChain() || nodeId == rel.getSecondNode() && rel.isFirstInSecondChain();
    }
}

