/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.ResourceClosingIterator;

class ResourceIterableTest {
    ResourceIterableTest() {
    }

    @Test
    void streamShouldCloseSingleOnCompleted() {
        AtomicBoolean closed = new AtomicBoolean(false);
        ResourceIterator resourceIterator = ResourceClosingIterator.newResourceIterator((Iterator)Iterators.iterator((Object[])new Integer[]{1, 2, 3}), (Resource[])new Resource[]{() -> closed.set(true)});
        ResourceIterable iterable = () -> resourceIterator;
        List result = iterable.stream().collect(Collectors.toList());
        Assertions.assertEquals(Arrays.asList(1, 2, 3), result);
        Assertions.assertTrue((boolean)closed.get());
    }

    @Test
    void streamShouldCloseMultipleOnCompleted() {
        AtomicInteger closed = new AtomicInteger();
        Resource resource = closed::incrementAndGet;
        ResourceIterator resourceIterator = ResourceClosingIterator.newResourceIterator((Iterator)Iterators.iterator((Object[])new Integer[]{1, 2, 3}), (Resource[])new Resource[]{resource, resource});
        ResourceIterable iterable = () -> resourceIterator;
        List result = iterable.stream().collect(Collectors.toList());
        Assertions.assertEquals(Arrays.asList(1, 2, 3), result);
        Assertions.assertEquals((int)2, (int)closed.get(), (String)"two calls to close");
    }
}

