/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.helpers.Format;

class FormatTest {
    FormatTest() {
    }

    @Test
    void shouldDisplayBytes() {
        String format = Format.bytes((long)123L);
        Assertions.assertTrue((boolean)format.contains(String.valueOf(123)));
        Assertions.assertTrue((boolean)format.endsWith(" B"));
    }

    @Test
    void shouldDisplayKiloBytes() {
        String format = Format.bytes((long)1234L);
        Assertions.assertTrue((boolean)format.startsWith("1"));
        Assertions.assertTrue((boolean)format.endsWith(" kB"));
    }

    @Test
    void shouldDisplayMegaBytes() {
        String format = Format.bytes((long)1234567L);
        Assertions.assertTrue((boolean)format.startsWith("1"));
        Assertions.assertTrue((boolean)format.endsWith(" MB"));
    }

    @Test
    void shouldDisplayGigaBytes() {
        String format = Format.bytes((long)1234567890L);
        Assertions.assertTrue((boolean)format.startsWith("1"));
        Assertions.assertTrue((boolean)format.endsWith(" GB"));
    }

    @Test
    void shouldDisplayPlainCount() {
        String format = Format.count((long)10L);
        Assertions.assertTrue((boolean)format.startsWith("10"));
    }

    @Test
    void shouldDisplayThousandCount() {
        String format = Format.count((long)2000L);
        Assertions.assertTrue((boolean)format.startsWith("2"));
        Assertions.assertTrue((boolean)format.endsWith("k"));
    }

    @Test
    void shouldDisplayMillionCount() {
        String format = Format.count((long)2000000L);
        Assertions.assertTrue((boolean)format.startsWith("2"));
        Assertions.assertTrue((boolean)format.endsWith("M"));
    }

    @Test
    void shouldDisplayBillionCount() {
        String format = Format.count((long)2000000000L);
        Assertions.assertTrue((boolean)format.startsWith("2"));
        Assertions.assertTrue((boolean)format.endsWith("G"));
    }

    @Test
    void shouldDisplayTrillionCount() {
        String format = Format.count((long)4000000000000L);
        Assertions.assertTrue((boolean)format.startsWith("4"));
        Assertions.assertTrue((boolean)format.endsWith("T"));
    }

    @Test
    void displayDuration() {
        MatcherAssert.assertThat((Object)Format.duration((long)(TimeUnit.MINUTES.toMillis(1L) + TimeUnit.SECONDS.toMillis(2L))), (Matcher)Matchers.is((Object)"1m 2s"));
        MatcherAssert.assertThat((Object)Format.duration((long)42L), (Matcher)Matchers.is((Object)"42ms"));
        MatcherAssert.assertThat((Object)Format.duration((long)0L), (Matcher)Matchers.is((Object)"0ms"));
    }
}

