/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.Exceptions;

class TestExceptions {
    TestExceptions() {
    }

    @Test
    void canPeelExceptions() {
        LevelThreeException expected = new LevelThreeException("include", new LevelFourException(""));
        LevelOneException exception = new LevelOneException("", new LevelTwoException("", new LevelThreeException("", expected)));
        Throwable peeled = Exceptions.peel((Throwable)exception, item -> !(item instanceof LevelThreeException) || !item.getMessage().contains("include"));
        Assertions.assertEquals((Object)expected, (Object)peeled);
    }

    @Test
    void canPeelUsingConveniencePredicate() {
        LevelThreeException expected = new LevelThreeException("", new LevelFourException(""));
        ARuntimeException exception = new ARuntimeException(new AnotherRuntimeException(new LevelFourException("", expected)));
        Throwable peeled = Exceptions.peel((Throwable)exception, (Predicate)Predicates.instanceOfAny((Class[])new Class[]{RuntimeException.class, LevelFourException.class}));
        Assertions.assertEquals((Object)expected, (Object)peeled);
    }

    @Test
    void shouldDetectContainsOneOfSome() {
        ARuntimeException cause = new ARuntimeException(new AnotherRuntimeException(new NullPointerException("Some words")));
        Assertions.assertTrue((boolean)Exceptions.contains((Throwable)cause, (Class[])new Class[]{NullPointerException.class}));
        Assertions.assertTrue((boolean)Exceptions.contains((Throwable)cause, (String)"words", (Class[])new Class[]{NullPointerException.class}));
        Assertions.assertFalse((boolean)Exceptions.contains((Throwable)cause, (String)"not", (Class[])new Class[]{NullPointerException.class}));
    }

    @Test
    void shouldSetMessage() {
        String initialMessage = "Initial message";
        LevelOneException exception = new LevelOneException(initialMessage);
        String prependedMessage = "Prepend this: " + exception.getMessage();
        Exceptions.withMessage((Throwable)exception, (String)prependedMessage);
        Assertions.assertEquals((Object)prependedMessage, (Object)exception.getMessage());
    }

    private static class AnotherRuntimeException
    extends RuntimeException {
        AnotherRuntimeException(Throwable cause) {
            super(cause);
        }
    }

    private static class ARuntimeException
    extends RuntimeException {
        ARuntimeException(Throwable cause) {
            super(cause);
        }
    }

    private static class LevelFourException
    extends LevelThreeException {
        LevelFourException(String message) {
            super(message);
        }

        LevelFourException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class LevelThreeException
    extends LevelTwoException {
        LevelThreeException(String message) {
            super(message);
        }

        LevelThreeException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class LevelTwoException
    extends LevelOneException {
        LevelTwoException(String message) {
            super(message);
        }

        LevelTwoException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class LevelOneException
    extends Exception {
        LevelOneException(String message) {
            super(message);
        }

        LevelOneException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

