/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.index;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;

public class IndexPopulationFailedKernelExceptionTest {
    private static final TokenNameLookup TOKEN_NAME_LOOKUP = SchemaUtil.idTokenNameLookup;

    @Test
    public void shouldHandleMultiplePropertiesInConstructor1() {
        LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{42, 43, 44});
        IndexPopulationFailedKernelException index = new IndexPopulationFailedKernelException(descriptor.userDescription(TOKEN_NAME_LOOKUP), (Throwable)new RuntimeException());
        MatcherAssert.assertThat((Object)index.getUserMessage(TOKEN_NAME_LOOKUP), (Matcher)CoreMatchers.equalTo((Object)"Failed to populate index :label[0](property[42], property[43], property[44])"));
    }

    @Test
    public void shouldHandleMultiplePropertiesInConstructor2() {
        LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{42, 43, 44});
        IndexPopulationFailedKernelException index = new IndexPopulationFailedKernelException(descriptor.userDescription(TOKEN_NAME_LOOKUP), "an act of pure evil occurred");
        MatcherAssert.assertThat((Object)index.getUserMessage(TOKEN_NAME_LOOKUP), (Matcher)CoreMatchers.equalTo((Object)"Failed to populate index :label[0](property[42], property[43], property[44]), due to an act of pure evil occurred"));
    }
}

