/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StubResourceManager;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.proc.BasicContext;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.Key;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.builtinprocs.BuiltInDbmsProcedures;
import org.neo4j.kernel.builtinprocs.BuiltInProcedures;
import org.neo4j.kernel.builtinprocs.SpecialBuiltInProcedures;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.factory.Edition;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public class BuiltInProceduresTest {
    private static final Key<DependencyResolver> DEPENDENCY_RESOLVER = Key.key((String)"DependencyResolver", DependencyResolver.class);
    private static final Key<GraphDatabaseAPI> GRAPHDATABASEAPI = Key.key((String)"GraphDatabaseAPI", GraphDatabaseAPI.class);
    private static final Key<Log> LOG = Key.key((String)"Log", Log.class);
    private final List<IndexReference> indexes = new LinkedList<IndexReference>();
    private final List<IndexReference> uniqueIndexes = new LinkedList<IndexReference>();
    private final List<ConstraintDescriptor> constraints = new LinkedList<ConstraintDescriptor>();
    private final Map<Integer, String> labels = new HashMap<Integer, String>();
    private final Map<Integer, String> propKeys = new HashMap<Integer, String>();
    private final Map<Integer, String> relTypes = new HashMap<Integer, String>();
    private final Read read = (Read)Mockito.mock(Read.class);
    private final TokenRead tokens = (TokenRead)Mockito.mock(TokenRead.class);
    private final SchemaRead schemaRead = (SchemaRead)Mockito.mock(SchemaRead.class);
    private final Statement statement = (Statement)Mockito.mock(Statement.class);
    private final KernelTransaction tx = (KernelTransaction)Mockito.mock(KernelTransaction.class);
    private final DependencyResolver resolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
    private final GraphDatabaseAPI graphDatabaseAPI = (GraphDatabaseAPI)Mockito.mock(GraphDatabaseAPI.class);
    private final IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
    private final Log log = (Log)Mockito.mock(Log.class);
    private final Procedures procs = new Procedures();
    private final ResourceTracker resourceTracker = new StubResourceManager();

    @Before
    public void setup() throws Exception {
        this.procs.registerComponent(KernelTransaction.class, ctx -> (KernelTransaction)ctx.get(Context.KERNEL_TRANSACTION), false);
        this.procs.registerComponent(DependencyResolver.class, ctx -> (DependencyResolver)ctx.get(DEPENDENCY_RESOLVER), false);
        this.procs.registerComponent(GraphDatabaseAPI.class, ctx -> (GraphDatabaseAPI)ctx.get(GRAPHDATABASEAPI), false);
        this.procs.registerComponent(SecurityContext.class, ctx -> (SecurityContext)ctx.get(Context.SECURITY_CONTEXT), true);
        this.procs.registerComponent(Log.class, ctx -> (Log)ctx.get(LOG), false);
        this.procs.registerType(Node.class, (Neo4jTypes.AnyType)Neo4jTypes.NTNode);
        this.procs.registerType(Relationship.class, (Neo4jTypes.AnyType)Neo4jTypes.NTRelationship);
        this.procs.registerType(Path.class, (Neo4jTypes.AnyType)Neo4jTypes.NTPath);
        new SpecialBuiltInProcedures("1.3.37", Edition.enterprise.toString()).accept(this.procs);
        this.procs.registerProcedure(BuiltInProcedures.class);
        this.procs.registerProcedure(BuiltInDbmsProcedures.class);
        Mockito.when((Object)this.tx.acquireStatement()).thenReturn((Object)this.statement);
        Mockito.when((Object)this.tx.tokenRead()).thenReturn((Object)this.tokens);
        Mockito.when((Object)this.tx.dataRead()).thenReturn((Object)this.read);
        Mockito.when((Object)this.tx.schemaRead()).thenReturn((Object)this.schemaRead);
        Mockito.when((Object)this.tokens.propertyKeyGetAllTokens()).thenAnswer(BuiltInProceduresTest.asTokens(this.propKeys));
        Mockito.when((Object)this.tokens.labelsGetAllTokens()).thenAnswer(BuiltInProceduresTest.asTokens(this.labels));
        Mockito.when((Object)this.tokens.relationshipTypesGetAllTokens()).thenAnswer(BuiltInProceduresTest.asTokens(this.relTypes));
        Mockito.when((Object)this.schemaRead.indexesGetAll()).thenAnswer(i -> Iterators.concat((Iterator[])new Iterator[]{this.indexes.iterator(), this.uniqueIndexes.iterator()}));
        Mockito.when((Object)this.schemaRead.index((SchemaDescriptor)ArgumentMatchers.any(SchemaDescriptor.class))).thenAnswer(invocationOnMock -> {
            SchemaDescriptor schema = (SchemaDescriptor)invocationOnMock.getArgument(0);
            int label = schema.keyId();
            int prop = schema.getPropertyId();
            return this.getIndexReference(label, prop);
        });
        Mockito.when((Object)this.schemaRead.constraintsGetAll()).thenAnswer(i -> this.constraints.iterator());
        Mockito.when((Object)this.tokens.propertyKeyName(ArgumentMatchers.anyInt())).thenAnswer(invocation -> this.propKeys.get(invocation.getArgument(0)));
        Mockito.when((Object)this.tokens.nodeLabelName(ArgumentMatchers.anyInt())).thenAnswer(invocation -> this.labels.get(invocation.getArgument(0)));
        Mockito.when((Object)this.tokens.relationshipTypeName(ArgumentMatchers.anyInt())).thenAnswer(invocation -> this.relTypes.get(invocation.getArgument(0)));
        Mockito.when((Object)this.indexingService.getIndexId((SchemaDescriptor)ArgumentMatchers.any(SchemaDescriptor.class))).thenReturn((Object)42L);
        Mockito.when((Object)this.schemaRead.constraintsGetForRelationshipType(ArgumentMatchers.anyInt())).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.schemaRead.indexesGetForLabel(ArgumentMatchers.anyInt())).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.schemaRead.constraintsGetForLabel(ArgumentMatchers.anyInt())).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.read.countsForNode(ArgumentMatchers.anyInt())).thenReturn((Object)1L);
        Mockito.when((Object)this.read.countsForRelationship(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn((Object)1L);
        Mockito.when((Object)this.schemaRead.indexGetState((IndexReference)ArgumentMatchers.any(IndexReference.class))).thenReturn((Object)InternalIndexState.ONLINE);
    }

    @Test
    public void shouldListAllIndexes() throws Throwable {
        this.givenIndex("User", "name");
        MatcherAssert.assertThat(this.call("db.indexes", new Object[0]), (Matcher)Matchers.contains(BuiltInProceduresTest.record("INDEX ON :User(name)", "Unnamed index", Collections.singletonList("User"), Collections.singletonList("name"), "ONLINE", "node_label_property", 100.0, BuiltInProceduresTest.getIndexProviderDescriptorMap(IndexProvider.EMPTY.getProviderDescriptor()), 42L, "")));
    }

    @Test
    public void shouldListAllUniqueIndexes() throws Throwable {
        this.givenUniqueConstraint("User", "name");
        MatcherAssert.assertThat(this.call("db.indexes", new Object[0]), (Matcher)Matchers.contains(BuiltInProceduresTest.record("INDEX ON :User(name)", "Unnamed index", Collections.singletonList("User"), Collections.singletonList("name"), "ONLINE", "node_unique_property", 100.0, BuiltInProceduresTest.getIndexProviderDescriptorMap(IndexProvider.EMPTY.getProviderDescriptor()), 42L, "")));
    }

    @Test
    public void shouldListPropertyKeys() throws Throwable {
        this.givenPropertyKeys("name", "age");
        MatcherAssert.assertThat(this.call("db.propertyKeys", new Object[0]), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{BuiltInProceduresTest.record("age"), BuiltInProceduresTest.record("name")}));
    }

    @Test
    public void shouldListLabels() throws Throwable {
        this.givenLabels("Banana", "Fruit");
        MatcherAssert.assertThat(this.call("db.labels", new Object[0]), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{BuiltInProceduresTest.record("Banana"), BuiltInProceduresTest.record("Fruit")}));
    }

    @Test
    public void shouldListRelTypes() throws Throwable {
        this.givenRelationshipTypes("EATS", "SPROUTS");
        MatcherAssert.assertThat(this.call("db.relationshipTypes", new Object[0]), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{BuiltInProceduresTest.record("EATS"), BuiltInProceduresTest.record("SPROUTS")}));
    }

    @Test
    public void shouldListConstraints() throws Throwable {
        this.givenUniqueConstraint("User", "name");
        this.givenNodePropExistenceConstraint("User", "name");
        this.givenNodeKeys("User", "name");
        MatcherAssert.assertThat(this.call("db.constraints", new Object[0]), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{BuiltInProceduresTest.record("CONSTRAINT ON ( user:User ) ASSERT exists(user.name)"), BuiltInProceduresTest.record("CONSTRAINT ON ( user:User ) ASSERT user.name IS UNIQUE"), BuiltInProceduresTest.record("CONSTRAINT ON ( user:User ) ASSERT (user.name) IS NODE KEY")}));
    }

    @Test
    public void shouldEscapeLabelNameContainingColons() throws Throwable {
        this.givenUniqueConstraint("FOO:BAR", "x.y");
        this.givenNodePropExistenceConstraint("FOO:BAR", "x.y");
        List<Object[]> call = this.call("db.constraints", new Object[0]);
        MatcherAssert.assertThat(call, (Matcher)Matchers.contains((Matcher[])new Matcher[]{BuiltInProceduresTest.record("CONSTRAINT ON ( `foo:bar`:`FOO:BAR` ) ASSERT `foo:bar`.x.y IS UNIQUE"), BuiltInProceduresTest.record("CONSTRAINT ON ( `foo:bar`:`FOO:BAR` ) ASSERT exists(`foo:bar`.x.y)")}));
    }

    @Test
    public void shouldListCorrectBuiltinProcedures() throws Throwable {
        MatcherAssert.assertThat(this.call("dbms.procedures", new Object[0]), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{BuiltInProceduresTest.record("dbms.listConfig", "dbms.listConfig(searchString =  :: STRING?) :: (name :: STRING?, description :: STRING?, value :: STRING?, dynamic :: BOOLEAN?)", "List the currently active config of Neo4j.", "DBMS"), BuiltInProceduresTest.record("db.awaitIndex", "db.awaitIndex(index :: STRING?, timeOutSeconds = 300 :: INTEGER?) :: VOID", "Wait for an index to come online (for example: CALL db.awaitIndex(\":Person(name)\")).", "READ"), BuiltInProceduresTest.record("db.awaitIndexes", "db.awaitIndexes(timeOutSeconds = 300 :: INTEGER?) :: VOID", "Wait for all indexes to come online (for example: CALL db.awaitIndexes(\"500\")).", "READ"), BuiltInProceduresTest.record("db.constraints", "db.constraints() :: (description :: STRING?)", "List all constraints in the database.", "READ"), BuiltInProceduresTest.record("db.indexes", "db.indexes() :: (description :: STRING?, indexName :: STRING?, tokenNames :: LIST? OF STRING?, properties :: LIST? OF STRING?, state :: STRING?, type :: STRING?, progress :: FLOAT?, provider :: MAP?, id :: INTEGER?, failureMessage :: STRING?)", "List all indexes in the database.", "READ"), BuiltInProceduresTest.record("db.labels", "db.labels() :: (label :: STRING?)", "List all labels in the database.", "READ"), BuiltInProceduresTest.record("db.propertyKeys", "db.propertyKeys() :: (propertyKey :: STRING?)", "List all property keys in the database.", "READ"), BuiltInProceduresTest.record("db.relationshipTypes", "db.relationshipTypes() :: (relationshipType :: STRING?)", "List all relationship types in the database.", "READ"), BuiltInProceduresTest.record("db.resampleIndex", "db.resampleIndex(index :: STRING?) :: VOID", "Schedule resampling of an index (for example: CALL db.resampleIndex(\":Person(name)\")).", "READ"), BuiltInProceduresTest.record("db.resampleOutdatedIndexes", "db.resampleOutdatedIndexes() :: VOID", "Schedule resampling of all outdated indexes.", "READ"), BuiltInProceduresTest.record("db.schema", "db.schema() :: (nodes :: LIST? OF NODE?, relationships :: LIST? OF RELATIONSHIP?)", "Show the schema of the data.", "READ"), BuiltInProceduresTest.record("db.schema.visualization", "db.schema.visualization() :: (nodes :: LIST? OF NODE?, relationships :: LIST? OF RELATIONSHIP?)", "Visualize the schema of the data. Replaces db.schema.", "READ"), BuiltInProceduresTest.record("db.schema.nodeTypeProperties", "db.schema.nodeTypeProperties() :: (nodeType :: STRING?, nodeLabels :: LIST? OF STRING?, propertyName :: STRING?, propertyTypes :: LIST? OF STRING?, mandatory :: BOOLEAN?)", "Show the derived property schema of the nodes in tabular form.", "READ"), BuiltInProceduresTest.record("db.schema.relTypeProperties", "db.schema.relTypeProperties() :: (relType :: STRING?, propertyName :: STRING?, propertyTypes :: LIST? OF STRING?, mandatory :: BOOLEAN?)", "Show the derived property schema of the relationships in tabular form.", "READ"), BuiltInProceduresTest.record("db.index.explicit.searchNodes", "db.index.explicit.searchNodes(indexName :: STRING?, query :: ANY?) :: (node :: NODE?, weight :: FLOAT?)", "Search nodes in explicit index. Replaces `START n=node:nodes('key:foo*')`", "READ"), BuiltInProceduresTest.record("db.index.explicit.seekNodes", "db.index.explicit.seekNodes(indexName :: STRING?, key :: STRING?, value :: ANY?) :: (node :: NODE?)", "Get node from explicit index. Replaces `START n=node:nodes(key = 'A')`", "READ"), BuiltInProceduresTest.record("db.index.explicit.searchRelationships", "db.index.explicit.searchRelationships(indexName :: STRING?, query :: ANY?) :: (relationship :: RELATIONSHIP?, weight :: FLOAT?)", "Search relationship in explicit index. Replaces `START r=relationship:relIndex('key:foo*')`", "READ"), BuiltInProceduresTest.record("db.index.explicit.searchRelationshipsIn", "db.index.explicit.searchRelationshipsIn(indexName :: STRING?, in :: NODE?, query :: ANY?) :: (relationship :: RELATIONSHIP?, weight :: FLOAT?)", "Search relationship in explicit index, starting at the node 'in'.", "READ"), BuiltInProceduresTest.record("db.index.explicit.searchRelationshipsOut", "db.index.explicit.searchRelationshipsOut(indexName :: STRING?, out :: NODE?, query :: ANY?) :: (relationship :: RELATIONSHIP?, weight :: FLOAT?)", "Search relationship in explicit index, ending at the node 'out'.", "READ"), BuiltInProceduresTest.record("db.index.explicit.searchRelationshipsBetween", "db.index.explicit.searchRelationshipsBetween(indexName :: STRING?, in :: NODE?, out :: NODE?, query :: ANY?) :: (relationship :: RELATIONSHIP?, weight :: FLOAT?)", "Search relationship in explicit index, starting at the node 'in' and ending at 'out'.", "READ"), BuiltInProceduresTest.record("db.index.explicit.seekRelationships", "db.index.explicit.seekRelationships(indexName :: STRING?, key :: STRING?, value :: ANY?) :: (relationship :: RELATIONSHIP?)", "Get relationship from explicit index. Replaces `START r=relationship:relIndex(key = 'A')`", "READ"), BuiltInProceduresTest.record("db.index.explicit.auto.searchNodes", "db.index.explicit.auto.searchNodes(query :: ANY?) :: (node :: NODE?, weight :: FLOAT?)", "Search nodes in explicit automatic index. Replaces `START n=node:node_auto_index('key:foo*')`", "READ"), BuiltInProceduresTest.record("db.index.explicit.auto.seekNodes", "db.index.explicit.auto.seekNodes(key :: STRING?, value :: ANY?) :: (node :: NODE?)", "Get node from explicit automatic index. Replaces `START n=node:node_auto_index(key = 'A')`", "READ"), BuiltInProceduresTest.record("db.index.explicit.auto.searchRelationships", "db.index.explicit.auto.searchRelationships(query :: ANY?) :: (relationship :: RELATIONSHIP?, weight :: FLOAT?)", "Search relationship in explicit automatic index. Replaces `START r=relationship:relationship_auto_index('key:foo*')`", "READ"), BuiltInProceduresTest.record("db.index.explicit.auto.seekRelationships", "db.index.explicit.auto.seekRelationships(key :: STRING?, value :: ANY?) :: (relationship :: RELATIONSHIP?)", "Get relationship from explicit automatic index. Replaces `START r=relationship:relationship_auto_index(key = 'A')`", "READ"), BuiltInProceduresTest.record("db.index.explicit.addNode", "db.index.explicit.addNode(indexName :: STRING?, node :: NODE?, key :: STRING?, value :: ANY?) :: (success :: BOOLEAN?)", "Add a node to an explicit index based on a specified key and value", "WRITE"), BuiltInProceduresTest.record("db.index.explicit.addRelationship", "db.index.explicit.addRelationship(indexName :: STRING?, relationship :: RELATIONSHIP?, key :: STRING?, value :: ANY?) :: (success :: BOOLEAN?)", "Add a relationship to an explicit index based on a specified key and value", "WRITE"), BuiltInProceduresTest.record("db.index.explicit.removeNode", "db.index.explicit.removeNode(indexName :: STRING?, node :: NODE?, key =  <[9895b15e-8693-4a21-a58b-4b7b87e09b8e]>  :: STRING?) :: (success :: BOOLEAN?)", "Remove a node from an explicit index with an optional key", "WRITE"), BuiltInProceduresTest.record("db.index.explicit.removeRelationship", "db.index.explicit.removeRelationship(indexName :: STRING?, relationship :: RELATIONSHIP?, key =  <[9895b15e-8693-4a21-a58b-4b7b87e09b8e]>  :: STRING?) :: (success :: BOOLEAN?)", "Remove a relationship from an explicit index with an optional key", "WRITE"), BuiltInProceduresTest.record("db.index.explicit.drop", "db.index.explicit.drop(indexName :: STRING?) :: (type :: STRING?, name :: STRING?, config :: MAP?)", "Remove an explicit index - YIELD type,name,config", "WRITE"), BuiltInProceduresTest.record("db.index.explicit.forNodes", "db.index.explicit.forNodes(indexName :: STRING?, config = {} :: MAP?) :: (type :: STRING?, name :: STRING?, config :: MAP?)", "Get or create a node explicit index - YIELD type,name,config", "WRITE"), BuiltInProceduresTest.record("db.index.explicit.forRelationships", "db.index.explicit.forRelationships(indexName :: STRING?, config = {} :: MAP?) :: (type :: STRING?, name :: STRING?, config :: MAP?)", "Get or create a relationship explicit index - YIELD type,name,config", "WRITE"), BuiltInProceduresTest.record("db.index.explicit.existsForNodes", "db.index.explicit.existsForNodes(indexName :: STRING?) :: (success :: BOOLEAN?)", "Check if a node explicit index exists", "READ"), BuiltInProceduresTest.record("db.index.explicit.existsForRelationships", "db.index.explicit.existsForRelationships(indexName :: STRING?) :: (success :: BOOLEAN?)", "Check if a relationship explicit index exists", "READ"), BuiltInProceduresTest.record("db.index.explicit.list", "db.index.explicit.list() :: (type :: STRING?, name :: STRING?, config :: MAP?)", "List all explicit indexes - YIELD type,name,config", "READ"), BuiltInProceduresTest.record("dbms.components", "dbms.components() :: (name :: STRING?, versions :: LIST? OF STRING?, edition :: STRING?)", "List DBMS components and their versions.", "DBMS"), BuiltInProceduresTest.record("dbms.procedures", "dbms.procedures() :: (name :: STRING?, signature :: STRING?, description :: STRING?, mode :: STRING?)", "List all procedures in the DBMS.", "DBMS"), BuiltInProceduresTest.record("dbms.functions", "dbms.functions() :: (name :: STRING?, signature :: STRING?, description :: STRING?)", "List all user functions in the DBMS.", "DBMS"), BuiltInProceduresTest.record("dbms.queryJmx", "dbms.queryJmx(query :: STRING?) :: (name :: STRING?, description :: STRING?, attributes :: MAP?)", "Query JMX management data by domain and name. For instance, \"org.neo4j:*\"", "DBMS"), BuiltInProceduresTest.record("dbms.clearQueryCaches", "dbms.clearQueryCaches() :: (value :: STRING?)", "Clears all query caches.", "DBMS"), BuiltInProceduresTest.record("db.createIndex", "db.createIndex(index :: STRING?, providerName :: STRING?) :: (index :: STRING?, providerName :: STRING?, status :: STRING?)", "Create a schema index with specified index provider (for example: CALL db.createIndex(\":Person(name)\", \"lucene+native-2.0\")) - YIELD index, providerName, status", "SCHEMA"), BuiltInProceduresTest.record("db.createUniquePropertyConstraint", "db.createUniquePropertyConstraint(index :: STRING?, providerName :: STRING?) :: (index :: STRING?, providerName :: STRING?, status :: STRING?)", "Create a unique property constraint with index backed by specified index provider (for example: CALL db.createUniquePropertyConstraint(\":Person(name)\", \"lucene+native-2.0\")) - YIELD index, providerName, status", "SCHEMA")}));
    }

    @Test
    public void shouldListSystemComponents() throws Throwable {
        MatcherAssert.assertThat(this.call("dbms.components", new Object[0]), (Matcher)Matchers.contains(BuiltInProceduresTest.record("Neo4j Kernel", Collections.singletonList("1.3.37"), "enterprise")));
    }

    @Test
    public void shouldCloseStatementIfExceptionIsThrownDbLabels() {
        RuntimeException runtimeException = new RuntimeException();
        Mockito.when((Object)this.tokens.labelsGetAllTokens()).thenThrow(new Throwable[]{runtimeException});
        try {
            this.call("db.labels", new Object[0]);
            Assert.fail((String)"Procedure call should have failed");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.is((Object)runtimeException));
        }
        ((Statement)Mockito.verify((Object)this.statement)).close();
    }

    @Test
    public void shouldCloseStatementIfExceptionIsThrownDbPropertyKeys() {
        RuntimeException runtimeException = new RuntimeException();
        Mockito.when((Object)this.tokens.propertyKeyGetAllTokens()).thenThrow(new Throwable[]{runtimeException});
        try {
            this.call("db.propertyKeys", new Object[0]);
            Assert.fail((String)"Procedure call should have failed");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.is((Object)runtimeException));
        }
        ((Statement)Mockito.verify((Object)this.statement)).close();
    }

    @Test
    public void shouldCloseStatementIfExceptionIsThrownDbRelationshipTypes() {
        RuntimeException runtimeException = new RuntimeException();
        Mockito.when((Object)this.tokens.relationshipTypesGetAllTokens()).thenThrow(new Throwable[]{runtimeException});
        try {
            this.call("db.relationshipTypes", new Object[0]);
            Assert.fail((String)"Procedure call should have failed");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.is((Object)runtimeException));
        }
        ((Statement)Mockito.verify((Object)this.statement)).close();
    }

    private static Map<String, String> getIndexProviderDescriptorMap(IndexProviderDescriptor providerDescriptor) {
        return MapUtil.stringMap((String[])new String[]{"key", providerDescriptor.getKey(), "version", providerDescriptor.getVersion()});
    }

    private static Matcher<Object[]> record(Object ... fields) {
        return Matchers.equalTo((Object)fields);
    }

    private void givenIndex(String label, String propKey) {
        int labelId = BuiltInProceduresTest.token(label, this.labels);
        int propId = BuiltInProceduresTest.token(propKey, this.propKeys);
        IndexDescriptor index = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propId}), (IndexProviderDescriptor)IndexProvider.EMPTY.getProviderDescriptor());
        this.indexes.add((IndexReference)index);
    }

    private void givenUniqueConstraint(String label, String propKey) {
        int labelId = BuiltInProceduresTest.token(label, this.labels);
        int propId = BuiltInProceduresTest.token(propKey, this.propKeys);
        IndexDescriptor index = IndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propId}), (IndexProviderDescriptor)IndexProvider.EMPTY.getProviderDescriptor());
        this.uniqueIndexes.add((IndexReference)index);
        this.constraints.add((ConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{propId}));
    }

    private void givenNodePropExistenceConstraint(String label, String propKey) {
        int labelId = BuiltInProceduresTest.token(label, this.labels);
        int propId = BuiltInProceduresTest.token(propKey, this.propKeys);
        this.constraints.add((ConstraintDescriptor)ConstraintDescriptorFactory.existsForLabel((int)labelId, (int[])new int[]{propId}));
    }

    private void givenNodeKeys(String label, String ... props) {
        int labelId = BuiltInProceduresTest.token(label, this.labels);
        int[] propIds = new int[props.length];
        for (int i = 0; i < propIds.length; ++i) {
            propIds[i] = BuiltInProceduresTest.token(props[i], this.propKeys);
        }
        this.constraints.add((ConstraintDescriptor)ConstraintDescriptorFactory.nodeKeyForLabel((int)labelId, (int[])propIds));
    }

    private void givenPropertyKeys(String ... keys) {
        for (String key : keys) {
            BuiltInProceduresTest.token(key, this.propKeys);
        }
    }

    private void givenLabels(String ... labelNames) {
        for (String key : labelNames) {
            BuiltInProceduresTest.token(key, this.labels);
        }
    }

    private void givenRelationshipTypes(String ... types) {
        for (String key : types) {
            BuiltInProceduresTest.token(key, this.relTypes);
        }
    }

    private static Integer token(String name, Map<Integer, String> tokens) {
        IntSupplier allocateFromMap = () -> {
            int newIndex = tokens.size();
            tokens.put(newIndex, name);
            return newIndex;
        };
        return tokens.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(name)).mapToInt(Map.Entry::getKey).findFirst().orElseGet(allocateFromMap);
    }

    private IndexReference getIndexReference(int label, int prop) {
        for (IndexReference index : this.indexes) {
            if (index.schema().getEntityTokenIds()[0] != label || prop != index.properties()[0]) continue;
            return index;
        }
        for (IndexReference index : this.uniqueIndexes) {
            if (index.schema().getEntityTokenIds()[0] != label || prop != index.properties()[0]) continue;
            return index;
        }
        throw new AssertionError();
    }

    private static Answer<Iterator<NamedToken>> asTokens(Map<Integer, String> tokens) {
        return i -> tokens.entrySet().stream().map(entry -> new NamedToken((String)entry.getValue(), ((Integer)entry.getKey()).intValue())).iterator();
    }

    private List<Object[]> call(String name, Object ... args) throws ProcedureException, IndexNotFoundKernelException {
        BasicContext ctx = new BasicContext();
        ctx.put(Context.KERNEL_TRANSACTION, (Object)this.tx);
        ctx.put(DEPENDENCY_RESOLVER, (Object)this.resolver);
        ctx.put(GRAPHDATABASEAPI, (Object)this.graphDatabaseAPI);
        ctx.put(Context.SECURITY_CONTEXT, (Object)SecurityContext.AUTH_DISABLED);
        ctx.put(LOG, (Object)this.log);
        Mockito.when((Object)this.graphDatabaseAPI.getDependencyResolver()).thenReturn((Object)this.resolver);
        Mockito.when((Object)this.resolver.resolveDependency(Procedures.class)).thenReturn((Object)this.procs);
        Mockito.when((Object)this.resolver.resolveDependency(IndexingService.class)).thenReturn((Object)this.indexingService);
        Mockito.when((Object)this.schemaRead.indexGetPopulationProgress((IndexReference)ArgumentMatchers.any(IndexReference.class))).thenReturn((Object)PopulationProgress.DONE);
        return Iterators.asList((RawIterator)this.procs.callProcedure((Context)ctx, ProcedureSignature.procedureName((String[])name.split("\\.")), args, this.resourceTracker));
    }
}

