/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension;

import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.extension.GlobalKernelExtensions;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.KernelExtensionFailureStrategy;
import org.neo4j.kernel.extension.UninitializableKernelExtensionFactory;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.UnsatisfiedDependencyException;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.scheduler.JobScheduler;

public class GlobalKernelExtensionsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldConsultUnsatisfiedDependencyHandlerOnMissingDependencies() {
        KernelContext context = (KernelContext)Mockito.mock(KernelContext.class);
        KernelExtensionFailureStrategy handler = (KernelExtensionFailureStrategy)Mockito.mock(KernelExtensionFailureStrategy.class);
        Dependencies dependencies = new Dependencies();
        TestingExtensionFactory extensionFactory = new TestingExtensionFactory();
        GlobalKernelExtensions extensions = new GlobalKernelExtensions(context, Iterables.iterable((Object[])new TestingExtensionFactory[]{extensionFactory}), dependencies, handler);
        LifeSupport life = new LifeSupport();
        life.add((Lifecycle)extensions);
        try {
            life.start();
            ((KernelExtensionFailureStrategy)Mockito.verify((Object)handler)).handle((KernelExtensionFactory)ArgumentMatchers.eq((Object)((Object)extensionFactory)), (UnsatisfiedDependencyException)((Object)ArgumentMatchers.any(UnsatisfiedDependencyException.class)));
        }
        finally {
            life.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldConsultUnsatisfiedDependencyHandlerOnFailingDependencyClasses() {
        KernelContext context = (KernelContext)Mockito.mock(KernelContext.class);
        KernelExtensionFailureStrategy handler = (KernelExtensionFailureStrategy)Mockito.mock(KernelExtensionFailureStrategy.class);
        Dependencies dependencies = new Dependencies();
        UninitializableKernelExtensionFactory extensionFactory = new UninitializableKernelExtensionFactory();
        GlobalKernelExtensions extensions = new GlobalKernelExtensions(context, Iterables.iterable((Object[])new UninitializableKernelExtensionFactory[]{extensionFactory}), dependencies, handler);
        LifeSupport life = new LifeSupport();
        life.add((Lifecycle)extensions);
        try {
            life.start();
            ((KernelExtensionFailureStrategy)Mockito.verify((Object)handler)).handle((KernelExtensionFactory)ArgumentMatchers.eq((Object)((Object)extensionFactory)), (Throwable)ArgumentMatchers.any(IllegalArgumentException.class));
        }
        finally {
            life.shutdown();
        }
    }

    private static class TestingExtension
    extends LifecycleAdapter {
        TestingExtension(JobScheduler jobScheduler) {
        }
    }

    private static class TestingExtensionFactory
    extends KernelExtensionFactory<TestingDependencies> {
        TestingExtensionFactory() {
            super("testing");
        }

        public Lifecycle newInstance(KernelContext context, TestingDependencies dependencies) {
            return new TestingExtension(dependencies.jobScheduler());
        }
    }

    private static interface TestingDependencies {
        public JobScheduler jobScheduler();
    }
}

