/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.ExplicitIndexWrite;
import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.kernel.api.explicitindex.AutoIndexOperations;
import org.neo4j.kernel.impl.api.explicitindex.InternalAutoIndexOperations;
import org.neo4j.kernel.impl.core.TokenHolder;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.values.storable.Values;

public class AutoIndexOperationsTest {
    private final ExplicitIndexWrite ops = (ExplicitIndexWrite)Mockito.mock(ExplicitIndexWrite.class);
    private final TokenHolder tokens = (TokenHolder)Mockito.mock(TokenHolder.class);
    private final AutoIndexOperations index = new InternalAutoIndexOperations(this.tokens, InternalAutoIndexOperations.EntityType.NODE);
    private final int nonIndexedProperty = 1337;
    private final String nonIndexedPropertyName = "foo";
    private final int indexedProperty = 1338;
    private final int indexedProperty2 = 1339;
    private final String indexedPropertyName = "bar";
    private final String indexedPropertyName2 = "baz";

    @Before
    public void setup() throws TokenNotFoundException {
        Mockito.when((Object)this.tokens.getTokenById(1337)).thenReturn((Object)new NamedToken("foo", 1337));
        Mockito.when((Object)this.tokens.getTokenById(1338)).thenReturn((Object)new NamedToken("bar", 1338));
        Mockito.when((Object)this.tokens.getTokenById(1339)).thenReturn((Object)new NamedToken("bar", 1339));
        this.index.enabled(true);
    }

    @Test
    public void shouldNotRemoveFromIndexForNonAutoIndexedProperty() throws Exception {
        this.index.startAutoIndexingProperty("bar");
        this.index.propertyRemoved(this.ops, 11L, 1337);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.ops});
    }

    @Test
    public void shouldRemoveSpecificValueFromIndexForAutoIndexedProperty() throws Exception {
        long nodeId = 11L;
        int value1 = 1;
        int value2 = 2;
        this.index.startAutoIndexingProperty("bar");
        this.index.startAutoIndexingProperty("baz");
        this.index.propertyAdded(this.ops, nodeId, 1338, Values.of((Object)value1));
        this.index.propertyAdded(this.ops, nodeId, 1339, Values.of((Object)value2));
        Mockito.reset((Object[])new ExplicitIndexWrite[]{this.ops});
        this.index.propertyRemoved(this.ops, nodeId, 1338);
        ((ExplicitIndexWrite)Mockito.verify((Object)this.ops)).nodeRemoveFromExplicitIndex("node_auto_index", nodeId, "bar");
    }

    @Test
    public void shouldNotAddToIndexForNonAutoIndexedProperty() throws Exception {
        this.index.startAutoIndexingProperty("bar");
        this.index.propertyAdded(this.ops, 11L, 1337, Values.of((Object)"Hello!"));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.ops});
    }

    @Test
    public void shouldNotAddOrRemoveFromIndexForNonAutoIndexedProperty() throws Exception {
        this.index.startAutoIndexingProperty("bar");
        this.index.propertyChanged(this.ops, 11L, 1337, Values.of((Object)"Goodbye!"), Values.of((Object)"Hello!"));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.ops});
    }
}

