/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactionTestBase;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class KernelTransactionAssertOpenTest
extends KernelTransactionTestBase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Parameterized.Parameter(value=0)
    public String name;
    @Parameterized.Parameter(value=1)
    public Operation transactionOperation;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList(KernelTransactionAssertOpenTest.operation("nodeExists", (read, write, schema) -> read.nodeExists(0L)), KernelTransactionAssertOpenTest.operation("singleRelationship", (read, write, schema) -> read.singleRelationship(0L, null)), KernelTransactionAssertOpenTest.operation("nodeCreate", (read, write, schema) -> write.nodeCreate()), KernelTransactionAssertOpenTest.operation("relationshipSetProperty", (read, write, schema) -> write.relationshipSetProperty(0L, 2, (Value)Values.longValue((long)42L))), KernelTransactionAssertOpenTest.operation("indexesGetAll", (read, write, schema) -> schema.indexesGetAll()));
    }

    private static Object[] operation(String name, Operation op) {
        return new Object[]{name, op};
    }

    @Test(expected=TransactionTerminatedException.class)
    public void shouldThrowTerminateExceptionWhenTransactionTerminated() throws KernelException {
        KernelTransactionImplementation transaction = this.newTransaction((LoginContext)AnonymousContext.write());
        transaction.success();
        transaction.markForTermination((Status)Status.General.UnknownError);
        this.transactionOperation.operate(transaction.dataRead(), transaction.dataWrite(), transaction.schemaRead());
    }

    @Test(expected=NotInTransactionException.class)
    public void shouldThrowNotInTransactionWhenTransactionClosedAndAccessingOperations() throws KernelException {
        KernelTransactionImplementation transaction = this.newTransaction((LoginContext)AnonymousContext.write());
        transaction.success();
        transaction.close();
        this.transactionOperation.operate(transaction.dataRead(), transaction.dataWrite(), transaction.schemaRead());
    }

    @Test(expected=NotInTransactionException.class)
    public void shouldThrowNotInTransactionWhenTransactionClosedAndAttemptingOperations() throws KernelException {
        KernelTransactionImplementation transaction = this.newTransaction((LoginContext)AnonymousContext.write());
        Read read = transaction.dataRead();
        Write write = transaction.dataWrite();
        SchemaRead schemaRead = transaction.schemaRead();
        transaction.success();
        transaction.close();
        this.transactionOperation.operate(read, write, schemaRead);
    }

    static interface Operation {
        public void operate(Read var1, Write var2, SchemaRead var3) throws KernelException;
    }
}

