/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;

public class OnlineIndexProxyTest {
    private final long indexId = 1L;
    private final IndexDescriptor descriptor = TestIndexDescriptorFactory.forLabel(1, 2);
    private final IndexProviderDescriptor providerDescriptor = (IndexProviderDescriptor)Mockito.mock(IndexProviderDescriptor.class);
    private final IndexAccessor accessor = (IndexAccessor)Mockito.mock(IndexAccessor.class);
    private final IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);

    @Test
    public void shouldRemoveIndexCountsWhenTheIndexItselfIsDropped() throws IOException {
        CapableIndexDescriptor capableIndexDescriptor = this.descriptor.withId(1L).withoutCapabilities();
        OnlineIndexProxy index = new OnlineIndexProxy(capableIndexDescriptor, this.accessor, this.storeView, false);
        index.drop();
        ((IndexAccessor)Mockito.verify((Object)this.accessor)).drop();
        ((IndexStoreView)Mockito.verify((Object)this.storeView)).replaceIndexCounts(1L, 0L, 0L, 0L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.accessor, this.storeView});
    }
}

