/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.event;

import org.junit.Assert;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.helpers.Strings;
import org.neo4j.values.storable.Values;

class PropertyEntryImpl<T extends PropertyContainer>
implements PropertyEntry<T> {
    private final T entity;
    private final String key;
    private final Object value;
    private final Object valueBeforeTx;

    PropertyEntryImpl(T entity, String key, Object value, Object valueBeforeTx) {
        this.entity = entity;
        this.key = key;
        this.value = value;
        this.valueBeforeTx = valueBeforeTx;
    }

    public T entity() {
        return this.entity;
    }

    public String key() {
        return this.key;
    }

    public Object value() {
        return this.value;
    }

    public Object previouslyCommitedValue() {
        return this.valueBeforeTx;
    }

    void compareToAssigned(PropertyEntry<T> entry) {
        this.basicCompareTo(entry);
        PropertyEntryImpl.assertEqualsMaybeNull(entry.value(), this.value(), entry.entity(), entry.key());
    }

    void compareToRemoved(PropertyEntry<T> entry) {
        this.basicCompareTo(entry);
        try {
            entry.value();
            Assert.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertNull((Object)this.value());
    }

    void basicCompareTo(PropertyEntry<T> entry) {
        Assert.assertEquals((Object)entry.entity(), this.entity());
        Assert.assertEquals((Object)entry.key(), (Object)this.key());
        PropertyEntryImpl.assertEqualsMaybeNull(entry.previouslyCommitedValue(), this.previouslyCommitedValue(), entry.entity(), entry.key());
    }

    public String toString() {
        return "PropertyEntry[entity=" + this.entity + ", key=" + this.key + ", value=" + this.value + ", valueBeforeTx=" + this.valueBeforeTx + "]";
    }

    public static <T extends PropertyContainer> void assertEqualsMaybeNull(Object o1, Object o2, T entity, String key) {
        String entityDescription = "For " + entity + " and " + key;
        if (o1 == null || o2 == null) {
            Assert.assertSame((String)(entityDescription + ". " + Strings.prettyPrint((Object)o1) + " != " + Strings.prettyPrint((Object)o2)), (Object)o1, (Object)o2);
        } else {
            Assert.assertEquals((String)entityDescription, (Object)Values.of((Object)o1), (Object)Values.of((Object)o2));
        }
    }
}

