/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.scan.FullStoreChangeStream;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanStore;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.test.rule.RandomRule;

public class NativeLabelScanReaderIT {
    @Rule
    public final RandomRule random = new RandomRule();
    @Rule
    public final PageCacheAndDependenciesRule storage = new PageCacheAndDependenciesRule();
    @Rule
    public final LifeRule life = new LifeRule(true);

    @Test
    public void shouldStartFromGivenIdDense() throws IOException {
        this.shouldStartFromGivenId(10);
    }

    @Test
    public void shouldStartFromGivenIdSparse() throws IOException {
        this.shouldStartFromGivenId(100);
    }

    @Test
    public void shouldStartFromGivenIdSuperSparse() throws IOException {
        this.shouldStartFromGivenId(1000);
    }

    private void shouldStartFromGivenId(int sparsity) throws IOException {
        NativeLabelScanStore store = (NativeLabelScanStore)this.life.add((Lifecycle)new NativeLabelScanStore(this.storage.pageCache(), DatabaseLayout.of((File)this.storage.directory().directory()), this.storage.fileSystem(), FullStoreChangeStream.EMPTY, false, new Monitors(), RecoveryCleanupWorkCollector.immediate()));
        int labelId = 1;
        int highNodeId = 100000;
        BitSet expected = new BitSet(highNodeId);
        try (LabelScanWriter writer = store.newWriter();){
            int updates = highNodeId / sparsity;
            for (int i = 0; i < updates; ++i) {
                int nodeId = this.random.nextInt(highNodeId);
                writer.write(NodeLabelUpdate.labelChanges((long)nodeId, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId}));
                expected.set(nodeId);
            }
        }
        long fromId = this.random.nextInt(highNodeId);
        int nextExpectedId = expected.nextSetBit(Math.toIntExact(fromId + 1L));
        try (LabelScanReader reader = store.newReader();
             PrimitiveLongResourceIterator ids = reader.nodesWithAnyOfLabels(fromId, new int[]{labelId});){
            while (nextExpectedId != -1) {
                Assertions.assertTrue((boolean)ids.hasNext());
                long nextId = ids.next();
                Assert.assertEquals((long)nextExpectedId, (long)Math.toIntExact(nextId));
                nextExpectedId = expected.nextSetBit(nextExpectedId + 1);
            }
            Assert.assertFalse((boolean)ids.hasNext());
        }
    }
}

