/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.UpdateMode;
import org.neo4j.kernel.impl.index.schema.DeferredConflictCheckingIndexUpdater;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class DeferredConflictCheckingIndexUpdaterTest {
    private final int labelId = 1;
    private final int[] propertyKeyIds = new int[]{2, 3};
    private final IndexDescriptor descriptor = TestIndexDescriptorFactory.forLabel(1, this.propertyKeyIds);

    @Test
    public void shouldQueryAboutAddedAndChangedValueTuples() throws Exception {
        IndexUpdater actual = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        IndexReader reader = (IndexReader)Mockito.mock(IndexReader.class);
        Mockito.when((Object)reader.query((IndexQuery[])Matchers.anyVararg())).thenAnswer(invocation -> PrimitiveLongCollections.iterator((long[])new long[]{0L}));
        long nodeId = 0L;
        ArrayList<IndexEntryUpdate> updates = new ArrayList<IndexEntryUpdate>();
        updates.add(IndexEntryUpdate.add((long)nodeId++, (SchemaDescriptorSupplier)this.descriptor, (Value[])this.tuple(10, 11)));
        updates.add(IndexEntryUpdate.change((long)nodeId++, (SchemaDescriptorSupplier)this.descriptor, (Value[])this.tuple("abc", "def"), (Value[])this.tuple("ghi", "klm")));
        updates.add(IndexEntryUpdate.remove((long)nodeId++, (SchemaDescriptorSupplier)this.descriptor, (Value[])this.tuple(1001L, 1002L)));
        updates.add(IndexEntryUpdate.change((long)nodeId++, (SchemaDescriptorSupplier)this.descriptor, (Value[])this.tuple((byte)2, (byte)3), (Value[])this.tuple((byte)4, (byte)5)));
        updates.add(IndexEntryUpdate.add((long)nodeId++, (SchemaDescriptorSupplier)this.descriptor, (Value[])this.tuple(5, "5")));
        try (DeferredConflictCheckingIndexUpdater updater = new DeferredConflictCheckingIndexUpdater(actual, () -> reader, this.descriptor);){
            for (IndexEntryUpdate update : updates) {
                updater.process(update);
                ((IndexUpdater)Mockito.verify((Object)actual)).process(update);
            }
        }
        for (IndexEntryUpdate update : updates) {
            if (update.updateMode() != UpdateMode.ADDED && update.updateMode() != UpdateMode.CHANGED) continue;
            Value[] tuple = update.values();
            IndexQuery[] query = new IndexQuery[tuple.length];
            for (int i = 0; i < tuple.length; ++i) {
                query[i] = IndexQuery.exact((int)this.propertyKeyIds[i], (Object)tuple[i]);
            }
            ((IndexReader)Mockito.verify((Object)reader)).query(query);
        }
        ((IndexReader)Mockito.verify((Object)reader)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{reader});
    }

    @Test
    public void shouldThrowOnIndexEntryConflict() throws Exception {
        IndexUpdater actual = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        IndexReader reader = (IndexReader)Mockito.mock(IndexReader.class);
        Mockito.when((Object)reader.query((IndexQuery[])Matchers.anyVararg())).thenAnswer(invocation -> PrimitiveLongCollections.iterator((long[])new long[]{101L, 202L}));
        DeferredConflictCheckingIndexUpdater updater = new DeferredConflictCheckingIndexUpdater(actual, () -> reader, this.descriptor);
        updater.process(IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)this.descriptor, (Value[])this.tuple(10, 11)));
        try {
            updater.close();
            Assert.fail((String)"Should have failed");
        }
        catch (IndexEntryConflictException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"101"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"202"));
        }
    }

    private Value[] tuple(Object ... values) {
        Value[] result = new Value[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = Values.of((Object)values[i]);
        }
        return result;
    }
}

