/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.schema.CompositeGenericKey;
import org.neo4j.kernel.impl.index.schema.GenericIndexKeyValidator;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class GenericIndexKeyValidatorTest {
    @Rule
    public final RandomRule random = new RandomRule();

    @Test
    public void shouldNotBotherSerializingToRealBytesIfFarFromThreshold() {
        Layout layout = (Layout)Mockito.mock(Layout.class);
        ((Layout)Mockito.doThrow(RuntimeException.class).when((Object)layout)).newKey();
        GenericIndexKeyValidator validator = new GenericIndexKeyValidator(120, layout);
        validator.validate(new Value[]{Values.intValue((int)10), DateValue.epochDate((long)100L), Values.stringValue((String)"abc")});
    }

    @Test
    public void shouldInvolveSerializingToRealBytesIfMayCrossThreshold() {
        Layout layout = (Layout)Mockito.mock(Layout.class);
        Mockito.when((Object)layout.newKey()).thenReturn((Object)new CompositeGenericKey(3, this.spatialSettings()));
        GenericIndexKeyValidator validator = new GenericIndexKeyValidator(48, layout);
        try {
            validator.validate(new Value[]{Values.intValue((int)10), DateValue.epochDate((long)100L), Values.stringValue((String)"abcdefghijklmnopqrstuvw")});
            Assert.fail((String)"Should have failed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"abcdefghijklmnopqrstuvw"));
            ((Layout)Mockito.verify((Object)layout, (VerificationMode)Mockito.times((int)1))).newKey();
        }
    }

    @Test
    public void shouldReportCorrectValidationErrorsOnRandomlyGeneratedValues() {
        int slots = this.random.nextInt(1, 6);
        int maxLength = this.random.nextInt(15, 30) * slots;
        GenericLayout layout = new GenericLayout(slots, this.spatialSettings());
        GenericIndexKeyValidator validator = new GenericIndexKeyValidator(maxLength, (Layout)layout);
        GenericKey key = layout.newKey();
        int countOk = 0;
        int countNotOk = 0;
        for (int i = 0; i < 100; ++i) {
            boolean manualIsOk;
            boolean isOk;
            Object[] tuple = this.generateValueTuple(slots);
            try {
                validator.validate((Value[])tuple);
                isOk = true;
                ++countOk;
            }
            catch (IllegalArgumentException e) {
                isOk = false;
                ++countNotOk;
            }
            int actualSize = GenericIndexKeyValidatorTest.actualSize((Value[])tuple, key);
            boolean bl = manualIsOk = actualSize <= maxLength;
            if (manualIsOk == isOk) continue;
            Assert.fail((String)String.format("Validator not validating %s correctly. Manual validation on actual key resulted in %b whereas validator said %b", Arrays.toString(tuple), manualIsOk, isOk));
        }
    }

    private IndexSpecificSpaceFillingCurveSettingsCache spatialSettings() {
        return new IndexSpecificSpaceFillingCurveSettingsCache(new ConfiguredSpaceFillingCurveSettingsCache(Config.defaults()), new HashMap());
    }

    private static int actualSize(Value[] tuple, GenericKey key) {
        key.initialize(0L);
        for (int i = 0; i < tuple.length; ++i) {
            key.initFromValue(i, tuple[i], NativeIndexKey.Inclusion.NEUTRAL);
        }
        return key.size();
    }

    private Value[] generateValueTuple(int slots) {
        Value[] tuple = new Value[slots];
        for (int j = 0; j < slots; ++j) {
            tuple[j] = this.random.nextValue();
        }
        return tuple;
    }
}

