/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.NumberIndexProvider;
import org.neo4j.kernel.impl.index.schema.SpatialIndexProvider;
import org.neo4j.kernel.impl.index.schema.StringIndexProvider;
import org.neo4j.kernel.impl.index.schema.TemporalIndexProvider;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.SimpleNodeValueClient;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.test.Race;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.test.rule.fs.FileSystemRule;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;

@RunWith(value=Parameterized.class)
public class IndexPopulationStressTest {
    private static final IndexProviderDescriptor PROVIDER = new IndexProviderDescriptor("provider", "1.0");
    private static final int THREADS = 50;
    private static final int MAX_BATCH_SIZE = 100;
    private static final int BATCHES_PER_THREAD = 100;
    @Rule
    public final RandomRule random = new RandomRule();
    @Rule
    public PageCacheAndDependenciesRule rules = new PageCacheAndDependenciesRule().with((FileSystemRule)new DefaultFileSystemRule());
    protected final StoreIndexDescriptor descriptor = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0}), (IndexProviderDescriptor)PROVIDER).withId(0L);
    private final StoreIndexDescriptor descriptor2 = IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{0}), (IndexProviderDescriptor)PROVIDER).withId(1L);
    private final IndexSamplingConfig samplingConfig = new IndexSamplingConfig(1000, 0.2, true);
    private final NodePropertyAccessor nodePropertyAccessor = (NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class);
    @Parameterized.Parameter
    public String name;
    @Parameterized.Parameter(value=1)
    public boolean hasValues;
    @Parameterized.Parameter(value=2)
    public Function<RandomValues, Value> valueGenerator;
    @Parameterized.Parameter(value=3)
    public Function<IndexPopulationStressTest, IndexProvider> providerCreator;
    private IndexPopulator populator;
    private IndexProvider indexProvider;
    private boolean prevAccessCheck;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> providers() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(IndexPopulationStressTest.of("generic", true, RandomValues::nextValue, test -> new GenericNativeIndexProvider(test.directory(), test.rules.pageCache(), test.rules.fileSystem(), IndexProvider.Monitor.EMPTY, RecoveryCleanupWorkCollector.immediate(), false, Config.defaults())));
        parameters.add(IndexPopulationStressTest.of("number", true, RandomValues::nextNumberValue, test -> new NumberIndexProvider(test.rules.pageCache(), test.rules.fileSystem(), test.directory(), IndexProvider.Monitor.EMPTY, RecoveryCleanupWorkCollector.immediate(), false)));
        parameters.add(IndexPopulationStressTest.of("string", true, RandomValues::nextAlphaNumericTextValue, test -> new StringIndexProvider(test.rules.pageCache(), test.rules.fileSystem(), test.directory(), IndexProvider.Monitor.EMPTY, RecoveryCleanupWorkCollector.immediate(), false)));
        parameters.add(IndexPopulationStressTest.of("spatial", false, RandomValues::nextPointValue, test -> new SpatialIndexProvider(test.rules.pageCache(), test.rules.fileSystem(), test.directory(), IndexProvider.Monitor.EMPTY, RecoveryCleanupWorkCollector.immediate(), false, Config.defaults())));
        parameters.add(IndexPopulationStressTest.of("temporal", true, RandomValues::nextTemporalValue, test -> new TemporalIndexProvider(test.rules.pageCache(), test.rules.fileSystem(), test.directory(), IndexProvider.Monitor.EMPTY, RecoveryCleanupWorkCollector.immediate(), false)));
        return parameters;
    }

    private static Object[] of(String name, boolean hasValues, Function<RandomValues, Value> valueGenerator, Function<IndexPopulationStressTest, IndexProvider> providerCreator) {
        return ArrayUtils.toArray((Object[])new Object[]{name, hasValues, valueGenerator, providerCreator});
    }

    private IndexDirectoryStructure.Factory directory() {
        File storeDir = this.rules.directory().databaseDir();
        return IndexDirectoryStructure.directoriesBySubProvider((IndexDirectoryStructure)IndexDirectoryStructure.directoriesByProvider((File)storeDir).forProvider(PROVIDER));
    }

    @Before
    public void setup() throws IOException, EntityNotFoundException {
        this.indexProvider = this.providerCreator.apply(this);
        this.rules.fileSystem().mkdirs(this.indexProvider.directoryStructure().rootDirectory());
        this.populator = this.indexProvider.getPopulator(this.descriptor, this.samplingConfig);
        Mockito.when((Object)this.nodePropertyAccessor.getNodePropertyValue(ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt())).thenThrow(UnsupportedOperationException.class);
        this.prevAccessCheck = UnsafeUtil.exchangeNativeAccessCheckEnabled((boolean)false);
    }

    @After
    public void teardown() {
        UnsafeUtil.exchangeNativeAccessCheckEnabled((boolean)this.prevAccessCheck);
        if (this.populator != null) {
            this.populator.close(true);
        }
    }

    @Test
    public void stressIt() throws Throwable {
        Race race = new Race();
        AtomicReferenceArray lastBatches = new AtomicReferenceArray(50);
        Generator[] generators = new Generator[50];
        this.populator.create();
        CountDownLatch insertersDone = new CountDownLatch(50);
        ReentrantReadWriteLock updateLock = new ReentrantReadWriteLock(true);
        for (int i = 0; i < 50; ++i) {
            race.addContestant(this.inserter(lastBatches, generators, insertersDone, updateLock, i), 1);
        }
        ArrayList updates = new ArrayList();
        race.addContestant(this.updater(lastBatches, insertersDone, updateLock, updates));
        race.go();
        this.populator.close(true);
        this.populator = null;
        this.buildReferencePopulatorSingleThreaded(generators, updates);
        try (IndexAccessor accessor = this.indexProvider.getOnlineAccessor(this.descriptor, this.samplingConfig);
             IndexAccessor referenceAccessor = this.indexProvider.getOnlineAccessor(this.descriptor2, this.samplingConfig);
             IndexReader reader = accessor.newReader();
             IndexReader referenceReader = referenceAccessor.newReader();){
            SimpleNodeValueClient entries = new SimpleNodeValueClient();
            SimpleNodeValueClient referenceEntries = new SimpleNodeValueClient();
            reader.query((IndexProgressor.NodeValueClient)entries, IndexOrder.NONE, this.hasValues, new IndexQuery[]{IndexQuery.exists((int)0)});
            referenceReader.query((IndexProgressor.NodeValueClient)referenceEntries, IndexOrder.NONE, this.hasValues, new IndexQuery[]{IndexQuery.exists((int)0)});
            while (referenceEntries.next()) {
                Assertions.assertTrue((boolean)entries.next());
                Assertions.assertEquals((long)referenceEntries.reference, (long)entries.reference);
                if (!this.hasValues) continue;
                Assertions.assertEquals((Object)ValueTuple.of((Value[])referenceEntries.values), (Object)ValueTuple.of((Value[])entries.values));
            }
            Assert.assertFalse((boolean)entries.next());
        }
    }

    private Runnable updater(AtomicReferenceArray<List<? extends IndexEntryUpdate<?>>> lastBatches, CountDownLatch insertersDone, ReadWriteLock updateLock, Collection<IndexEntryUpdate<?>> updates) {
        return Race.throwing(() -> {
            ArrayList<Long> removed = new ArrayList<Long>();
            RandomValues randomValues = RandomValues.create((Random)new Random(this.random.seed() + 50L));
            while (insertersDone.getCount() > 0L) {
                Thread.sleep(10L);
                updateLock.writeLock().lock();
                try {
                    IndexUpdater updater = this.populator.newPopulatingUpdater(this.nodePropertyAccessor);
                    Throwable throwable = null;
                    try {
                        for (int i = 0; i < 50; ++i) {
                            List batch = (List)lastBatches.get(i);
                            if (batch == null) continue;
                            IndexEntryUpdate update = null;
                            switch (randomValues.nextInt(3)) {
                                case 0: {
                                    if (removed.isEmpty()) break;
                                    Long id = (Long)removed.remove(randomValues.nextInt(removed.size()));
                                    update = IndexEntryUpdate.add((long)id, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{this.valueGenerator.apply(randomValues)});
                                    break;
                                }
                                case 1: {
                                    IndexEntryUpdate removal = (IndexEntryUpdate)batch.get(randomValues.nextInt(batch.size()));
                                    update = IndexEntryUpdate.remove((long)removal.getEntityId(), (SchemaDescriptorSupplier)this.descriptor, (Value[])removal.values());
                                    removed.add(removal.getEntityId());
                                    break;
                                }
                                case 2: {
                                    IndexEntryUpdate removal = (IndexEntryUpdate)batch.get(randomValues.nextInt(batch.size()));
                                    IndexEntryUpdate.change((long)removal.getEntityId(), (SchemaDescriptorSupplier)this.descriptor, (Value[])removal.values(), (Value[])((Value[])ArrayUtils.toArray((Object[])new Value[]{this.valueGenerator.apply(randomValues)})));
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException();
                                }
                            }
                            if (update == null) continue;
                            updater.process(update);
                            updates.add(update);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (updater == null) continue;
                        if (throwable != null) {
                            try {
                                updater.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        updater.close();
                    }
                }
                finally {
                    updateLock.writeLock().unlock();
                }
            }
        });
    }

    private Runnable inserter(AtomicReferenceArray<List<? extends IndexEntryUpdate<?>>> lastBatches, Generator[] generators, CountDownLatch insertersDone, ReadWriteLock updateLock, int slot) {
        int worstCaseEntriesPerThread = 10000;
        return Race.throwing(() -> {
            try {
                Generator generator = generators[slot] = new Generator(100, this.random.seed() + (long)slot, slot * worstCaseEntriesPerThread);
                for (int j = 0; j < 100; ++j) {
                    List<? extends IndexEntryUpdate<?>> batch = generator.batch();
                    updateLock.readLock().lock();
                    try {
                        this.populator.add(batch);
                    }
                    finally {
                        updateLock.readLock().unlock();
                    }
                    lastBatches.set(slot, batch);
                }
            }
            finally {
                insertersDone.countDown();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildReferencePopulatorSingleThreaded(Generator[] generators, Collection<IndexEntryUpdate<?>> updates) throws IndexEntryConflictException {
        IndexPopulator referencePopulator = this.indexProvider.getPopulator(this.descriptor2, this.samplingConfig);
        referencePopulator.create();
        boolean referenceSuccess = false;
        try {
            for (Generator generator : generators) {
                generator.reset();
                for (int i = 0; i < 100; ++i) {
                    referencePopulator.add(generator.batch());
                }
            }
            try (IndexUpdater updater = referencePopulator.newPopulatingUpdater(this.nodePropertyAccessor);){
                for (IndexEntryUpdate<?> update : updates) {
                    updater.process(update);
                }
            }
            referenceSuccess = true;
        }
        finally {
            referencePopulator.close(referenceSuccess);
        }
    }

    private class Generator {
        private final int maxBatchSize;
        private final long seed;
        private final long startEntityId;
        private RandomValues randomValues;
        private long nextEntityId;

        Generator(int maxBatchSize, long seed, long startEntityId) {
            this.startEntityId = startEntityId;
            this.nextEntityId = startEntityId;
            this.maxBatchSize = maxBatchSize;
            this.seed = seed;
            this.reset();
        }

        private void reset() {
            this.randomValues = RandomValues.create((Random)new Random(this.seed));
            this.nextEntityId = this.startEntityId;
        }

        List<? extends IndexEntryUpdate<?>> batch() {
            int n = this.randomValues.nextInt(this.maxBatchSize) + 1;
            ArrayList<IndexEntryUpdate> updates = new ArrayList<IndexEntryUpdate>(n);
            for (int i = 0; i < n; ++i) {
                updates.add(IndexEntryUpdate.add((long)this.nextEntityId++, (SchemaDescriptorSupplier)IndexPopulationStressTest.this.descriptor, (Value[])new Value[]{IndexPopulationStressTest.this.valueGenerator.apply(this.randomValues)}));
            }
            return updates;
        }
    }
}

