/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.UpdateMode;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.IndexUpdateCursor;
import org.neo4j.kernel.impl.index.schema.IndexUpdateStorage;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.Value;

@ExtendWith(value={TestDirectoryExtension.class, RandomExtension.class})
class IndexUpdateStorageTest {
    private static final IndexSpecificSpaceFillingCurveSettingsCache spatialSettings = new IndexSpecificSpaceFillingCurveSettingsCache(new ConfiguredSpaceFillingCurveSettingsCache(Config.defaults()), new HashMap());
    private static final SchemaDescriptorSupplier descriptor = SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
    @Inject
    protected TestDirectory directory;
    @Inject
    protected RandomRule random;
    private final GenericLayout layout = new GenericLayout(1, spatialSettings);

    IndexUpdateStorageTest() {
    }

    @Test
    void shouldAddZeroEntries() throws IOException {
        try (IndexUpdateStorage storage = new IndexUpdateStorage(this.directory.getFileSystem(), this.directory.file("file"), ByteBufferFactory.HEAP_BUFFER_FACTORY, 1000, (Layout)this.layout);){
            List<IndexEntryUpdate<SchemaDescriptorSupplier>> expected = this.generateSomeUpdates(0);
            IndexUpdateStorageTest.storeAll((IndexUpdateStorage<GenericKey, NativeIndexValue>)storage, expected);
            IndexUpdateStorageTest.verify(expected, (IndexUpdateStorage<GenericKey, NativeIndexValue>)storage);
        }
    }

    @Test
    void shouldAddFewEntries() throws IOException {
        try (IndexUpdateStorage storage = new IndexUpdateStorage(this.directory.getFileSystem(), this.directory.file("file"), ByteBufferFactory.HEAP_BUFFER_FACTORY, 1000, (Layout)this.layout);){
            List<IndexEntryUpdate<SchemaDescriptorSupplier>> expected = this.generateSomeUpdates(5);
            IndexUpdateStorageTest.storeAll((IndexUpdateStorage<GenericKey, NativeIndexValue>)storage, expected);
            IndexUpdateStorageTest.verify(expected, (IndexUpdateStorage<GenericKey, NativeIndexValue>)storage);
        }
    }

    @Test
    void shouldAddManyEntries() throws IOException {
        try (IndexUpdateStorage storage = new IndexUpdateStorage(this.directory.getFileSystem(), this.directory.file("file"), ByteBufferFactory.HEAP_BUFFER_FACTORY, 1000, (Layout)this.layout);){
            List<IndexEntryUpdate<SchemaDescriptorSupplier>> expected = this.generateSomeUpdates(1000);
            IndexUpdateStorageTest.storeAll((IndexUpdateStorage<GenericKey, NativeIndexValue>)storage, expected);
            IndexUpdateStorageTest.verify(expected, (IndexUpdateStorage<GenericKey, NativeIndexValue>)storage);
        }
    }

    private static void storeAll(IndexUpdateStorage<GenericKey, NativeIndexValue> storage, List<IndexEntryUpdate<SchemaDescriptorSupplier>> expected) throws IOException {
        for (IndexEntryUpdate<SchemaDescriptorSupplier> update : expected) {
            storage.add(update);
        }
        storage.doneAdding();
    }

    private static void verify(List<IndexEntryUpdate<SchemaDescriptorSupplier>> expected, IndexUpdateStorage<GenericKey, NativeIndexValue> storage) throws IOException {
        try (IndexUpdateCursor reader = (IndexUpdateCursor)storage.reader();){
            for (IndexEntryUpdate<SchemaDescriptorSupplier> expectedUpdate : expected) {
                Assertions.assertTrue((boolean)reader.next());
                Assertions.assertEquals(expectedUpdate, IndexUpdateStorageTest.asUpdate((IndexUpdateCursor<GenericKey, NativeIndexValue>)reader));
            }
            Assertions.assertFalse((boolean)reader.next());
        }
    }

    private static IndexEntryUpdate<SchemaDescriptorSupplier> asUpdate(IndexUpdateCursor<GenericKey, NativeIndexValue> reader) {
        switch (reader.updateMode()) {
            case ADDED: {
                return IndexEntryUpdate.add((long)((GenericKey)reader.key()).getEntityId(), (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{((GenericKey)reader.key()).asValue()});
            }
            case CHANGED: {
                return IndexEntryUpdate.change((long)((GenericKey)reader.key()).getEntityId(), (SchemaDescriptorSupplier)descriptor, (Value)((GenericKey)reader.key()).asValue(), (Value)((GenericKey)reader.key2()).asValue());
            }
            case REMOVED: {
                return IndexEntryUpdate.remove((long)((GenericKey)reader.key()).getEntityId(), (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{((GenericKey)reader.key()).asValue()});
            }
        }
        throw new IllegalArgumentException();
    }

    private List<IndexEntryUpdate<SchemaDescriptorSupplier>> generateSomeUpdates(int count) {
        ArrayList<IndexEntryUpdate<SchemaDescriptorSupplier>> updates = new ArrayList<IndexEntryUpdate<SchemaDescriptorSupplier>>();
        block5: for (int i = 0; i < count; ++i) {
            long entityId = this.random.nextLong(10000000L);
            switch ((UpdateMode)this.random.among((Object[])UpdateMode.MODES)) {
                case ADDED: {
                    updates.add((IndexEntryUpdate<SchemaDescriptorSupplier>)IndexEntryUpdate.add((long)entityId, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{this.random.nextValue()}));
                    continue block5;
                }
                case REMOVED: {
                    updates.add((IndexEntryUpdate<SchemaDescriptorSupplier>)IndexEntryUpdate.remove((long)entityId, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{this.random.nextValue()}));
                    continue block5;
                }
                case CHANGED: {
                    updates.add((IndexEntryUpdate<SchemaDescriptorSupplier>)IndexEntryUpdate.change((long)entityId, (SchemaDescriptorSupplier)descriptor, (Value)this.random.nextValue(), (Value)this.random.nextValue()));
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return updates;
    }
}

