/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableLong;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.SimpleLongLayout;
import org.neo4j.kernel.impl.index.schema.BlockEntry;
import org.neo4j.kernel.impl.index.schema.BlockEntryCursor;
import org.neo4j.kernel.impl.index.schema.ListBasedBlockEntryCursor;
import org.neo4j.kernel.impl.index.schema.MergingBlockEntryReader;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@ExtendWith(value={RandomExtension.class})
class MergingBlockEntryReaderTest {
    @Inject
    protected RandomRule rnd;
    private static final SimpleLongLayout layout = SimpleLongLayout.longLayout().build();
    private static final Comparator<BlockEntry<MutableLong, MutableLong>> blockEntryComparator = (b1, b2) -> layout.compare((MutableLong)b1.key(), (MutableLong)b2.key());

    MergingBlockEntryReaderTest() {
    }

    @Test
    void shouldMergeSingleReader() throws IOException {
        MergingBlockEntryReader merger = new MergingBlockEntryReader((Layout)layout);
        List<BlockEntry<MutableLong, MutableLong>> data = this.someBlockEntries(new HashSet<MutableLong>());
        merger.addSource((BlockEntryCursor)MergingBlockEntryReaderTest.newReader(data));
        List<BlockEntry<MutableLong, MutableLong>> expected = MergingBlockEntryReaderTest.sortAll(Collections.singleton(data));
        MergingBlockEntryReaderTest.verifyMerged(expected, (MergingBlockEntryReader<MutableLong, MutableLong>)merger);
    }

    @Test
    void shouldMergeSingleEmptyReader() throws IOException {
        MergingBlockEntryReader merger = new MergingBlockEntryReader((Layout)layout);
        List<BlockEntry<MutableLong, MutableLong>> data = Collections.emptyList();
        merger.addSource((BlockEntryCursor)MergingBlockEntryReaderTest.newReader(data));
        Assertions.assertFalse((boolean)merger.next());
    }

    @Test
    void shouldMergeMultipleReaders() throws IOException {
        MergingBlockEntryReader merger = new MergingBlockEntryReader((Layout)layout);
        ArrayList<List<BlockEntry<MutableLong, MutableLong>>> datas = new ArrayList<List<BlockEntry<MutableLong, MutableLong>>>();
        HashSet<MutableLong> uniqueKeys = new HashSet<MutableLong>();
        int nbrOfReaders = this.rnd.nextInt(10) + 1;
        for (int i = 0; i < nbrOfReaders; ++i) {
            List<BlockEntry<MutableLong, MutableLong>> data = this.someBlockEntries(uniqueKeys);
            datas.add(data);
            merger.addSource((BlockEntryCursor)MergingBlockEntryReaderTest.newReader(data));
        }
        List<BlockEntry<MutableLong, MutableLong>> expected = MergingBlockEntryReaderTest.sortAll(datas);
        MergingBlockEntryReaderTest.verifyMerged(expected, (MergingBlockEntryReader<MutableLong, MutableLong>)merger);
    }

    @Test
    void shouldCloseAllReaderEvenEmpty() throws IOException {
        MergingBlockEntryReader merger = new MergingBlockEntryReader((Layout)layout);
        CloseTrackingBlockEntryCursor empty = MergingBlockEntryReaderTest.newReader(Collections.emptyList());
        CloseTrackingBlockEntryCursor nonEmpty = MergingBlockEntryReaderTest.newReader(this.someBlockEntries(new HashSet<MutableLong>()));
        merger.addSource((BlockEntryCursor)empty);
        merger.addSource((BlockEntryCursor)nonEmpty);
        merger.close();
        Assertions.assertTrue((boolean)empty.closed);
        Assertions.assertTrue((boolean)nonEmpty.closed);
    }

    @Test
    void shouldCloseAllReaderEvenEmptyAndExhausted() throws IOException {
        MergingBlockEntryReader merger = new MergingBlockEntryReader((Layout)layout);
        CloseTrackingBlockEntryCursor empty = MergingBlockEntryReaderTest.newReader(Collections.emptyList());
        CloseTrackingBlockEntryCursor nonEmpty = MergingBlockEntryReaderTest.newReader(this.someBlockEntries(new HashSet<MutableLong>()));
        merger.addSource((BlockEntryCursor)empty);
        merger.addSource((BlockEntryCursor)nonEmpty);
        while (merger.next()) {
        }
        merger.close();
        Assertions.assertTrue((boolean)empty.closed);
        Assertions.assertTrue((boolean)nonEmpty.closed);
    }

    private static void verifyMerged(List<BlockEntry<MutableLong, MutableLong>> expected, MergingBlockEntryReader<MutableLong, MutableLong> merger) throws IOException {
        for (BlockEntry<MutableLong, MutableLong> expectedEntry : expected) {
            Assertions.assertTrue((boolean)merger.next());
            Assertions.assertEquals((int)0, (int)layout.compare((MutableLong)expectedEntry.key(), (MutableLong)merger.key()));
            Assertions.assertEquals((Object)expectedEntry.value(), (Object)merger.value());
        }
        Assertions.assertFalse((boolean)merger.next());
    }

    private static List<BlockEntry<MutableLong, MutableLong>> sortAll(Iterable<List<BlockEntry<MutableLong, MutableLong>>> data) {
        ArrayList<BlockEntry<MutableLong, MutableLong>> result = new ArrayList<BlockEntry<MutableLong, MutableLong>>();
        for (List<BlockEntry<MutableLong, MutableLong>> list : data) {
            result.addAll(list);
        }
        result.sort(blockEntryComparator);
        return result;
    }

    private static CloseTrackingBlockEntryCursor newReader(List<BlockEntry<MutableLong, MutableLong>> expected) {
        return new CloseTrackingBlockEntryCursor(expected);
    }

    private List<BlockEntry<MutableLong, MutableLong>> someBlockEntries(Set<MutableLong> uniqueKeys) {
        ArrayList<BlockEntry<MutableLong, MutableLong>> entries = new ArrayList<BlockEntry<MutableLong, MutableLong>>();
        for (int i = 0; i < this.rnd.nextInt(10); ++i) {
            MutableLong key;
            while (!uniqueKeys.add(key = layout.key(this.rnd.nextLong(10000L)))) {
            }
            MutableLong value = layout.value(this.rnd.nextLong(10000L));
            entries.add((BlockEntry<MutableLong, MutableLong>)new BlockEntry((Object)key, (Object)value));
        }
        entries.sort(blockEntryComparator);
        return entries;
    }

    private static class CloseTrackingBlockEntryCursor
    extends ListBasedBlockEntryCursor<MutableLong, MutableLong> {
        private boolean closed;

        CloseTrackingBlockEntryCursor(Iterable<BlockEntry<MutableLong, MutableLong>> blockEntries) {
            super(blockEntries);
        }

        public void close() {
            super.close();
            this.closed = true;
        }
    }
}

