/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.impl.index.schema.GatheringNodeValueClient;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeDistinctValuesProgressor;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.SimpleHit;
import org.neo4j.kernel.impl.index.schema.StringIndexKey;
import org.neo4j.kernel.impl.index.schema.StringLayout;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class NativeDistinctValuesProgressorTest {
    private final StringLayout layout = new StringLayout();
    @Rule
    public final RandomRule random = new RandomRule();

    @Test
    public void shouldCountDistinctValues() {
        Value[] strings = this.generateRandomStrings();
        DataCursor source = new DataCursor(this.asHitData(strings));
        GatheringNodeValueClient client = new GatheringNodeValueClient();
        NativeDistinctValuesProgressor progressor = new NativeDistinctValuesProgressor((RawCursor)source, (IndexProgressor.NodeValueClient)client, new ArrayList(), (IndexLayout)this.layout, (arg_0, arg_1) -> ((StringLayout)this.layout).compareValue(arg_0, arg_1));
        client.initialize(null, (IndexProgressor)progressor, new IndexQuery[0], IndexOrder.NONE, true);
        Map<Value, MutableInt> expectedCounts = this.asDistinctCounts(strings);
        int uniqueValues = 0;
        int nonUniqueValues = 0;
        while (progressor.next()) {
            Value string = client.values[0];
            MutableInt expectedCount = expectedCounts.remove(string);
            Assert.assertNotNull((Object)expectedCount);
            Assert.assertEquals((long)expectedCount.intValue(), (long)client.reference);
            if (expectedCount.intValue() > 1) {
                ++nonUniqueValues;
                continue;
            }
            ++uniqueValues;
        }
        Assert.assertTrue((boolean)expectedCounts.isEmpty());
        Assert.assertTrue((uniqueValues > 0 ? 1 : 0) != 0);
        Assert.assertTrue((nonUniqueValues > 0 ? 1 : 0) != 0);
    }

    private Map<Value, MutableInt> asDistinctCounts(Value[] strings) {
        HashMap<Value, MutableInt> map = new HashMap<Value, MutableInt>();
        for (Value string : strings) {
            map.computeIfAbsent(string, s -> new MutableInt(0)).increment();
        }
        return map;
    }

    private Value[] generateRandomStrings() {
        Value[] strings = new Value[1000];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = Values.stringValue((String)String.valueOf(this.random.nextInt(1000)));
        }
        Arrays.sort(strings, Values.COMPARATOR);
        return strings;
    }

    private Collection<Hit<StringIndexKey, NativeIndexValue>> asHitData(Value[] strings) {
        ArrayList<Hit<StringIndexKey, NativeIndexValue>> data = new ArrayList<Hit<StringIndexKey, NativeIndexValue>>(strings.length);
        for (int i = 0; i < strings.length; ++i) {
            StringIndexKey key = this.layout.newKey();
            key.initialize((long)i);
            key.initFromValue(0, strings[i], NativeIndexKey.Inclusion.NEUTRAL);
            data.add(new SimpleHit<StringIndexKey, NativeIndexValue>(key, NativeIndexValue.INSTANCE));
        }
        return data;
    }

    private static class DataCursor
    implements RawCursor<Hit<StringIndexKey, NativeIndexValue>, IOException> {
        private final Iterator<Hit<StringIndexKey, NativeIndexValue>> iterator;
        private Hit<StringIndexKey, NativeIndexValue> current;

        DataCursor(Collection<Hit<StringIndexKey, NativeIndexValue>> data) {
            this.iterator = data.iterator();
        }

        public boolean next() throws RuntimeException {
            if (!this.iterator.hasNext()) {
                return false;
            }
            this.current = this.iterator.next();
            return true;
        }

        public void close() throws RuntimeException {
        }

        public Hit<StringIndexKey, NativeIndexValue> get() {
            return this.current;
        }
    }
}

