/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.index.schema.StringIndexKey;

public class StringIndexKeyTest {
    @Test
    public void shouldReuseByteArrayForFairlySimilarSizedKeys() {
        StringIndexKey key = new StringIndexKey();
        key.setBytesLength(20);
        byte[] first = key.bytes;
        key.setBytesLength(25);
        byte[] second = key.bytes;
        Assert.assertSame((Object)first, (Object)second);
        Assert.assertThat((Object)first.length, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(25)));
    }

    @Test
    public void shouldCreateNewByteArrayForVastlyDifferentKeySizes() {
        StringIndexKey key = new StringIndexKey();
        key.setBytesLength(20);
        byte[] first = key.bytes;
        key.setBytesLength(100);
        byte[] second = key.bytes;
        Assert.assertNotSame((Object)first, (Object)second);
        Assert.assertThat((Object)first.length, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(20)));
        Assert.assertThat((Object)second.length, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(100)));
    }

    @Test
    public void shouldDereferenceByteArrayWhenMaterializingValue() {
        StringIndexKey key = new StringIndexKey();
        key.setBytesLength(20);
        byte[] first = key.bytes;
        key.asValue();
        key.setBytesLength(25);
        byte[] second = key.bytes;
        Assert.assertNotSame((Object)first, (Object)second);
    }
}

