/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.mutable.MutableInt;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.index.schema.TemporalIndexCache;
import org.neo4j.test.Race;
import org.neo4j.values.storable.ValueGroup;

public class TemporalIndexCacheTest {
    private static final ValueGroup[] valueGroups = new ValueGroup[]{ValueGroup.ZONED_DATE_TIME, ValueGroup.LOCAL_DATE_TIME, ValueGroup.DATE, ValueGroup.ZONED_TIME, ValueGroup.LOCAL_TIME, ValueGroup.DURATION};

    @Test
    public void shouldIterateOverCreatedParts() throws Exception {
        StringFactory factory = new StringFactory();
        TemporalIndexCache cache = new TemporalIndexCache((TemporalIndexCache.Factory)factory);
        Assert.assertEquals((long)Iterables.count((Iterable)cache), (long)0L);
        cache.select(ValueGroup.LOCAL_DATE_TIME);
        cache.select(ValueGroup.ZONED_TIME);
        Assert.assertThat((Object)cache, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"LocalDateTime", "ZonedTime"}));
        cache.select(ValueGroup.DATE);
        cache.select(ValueGroup.LOCAL_TIME);
        cache.select(ValueGroup.LOCAL_DATE_TIME);
        cache.select(ValueGroup.ZONED_TIME);
        cache.select(ValueGroup.ZONED_DATE_TIME);
        cache.select(ValueGroup.DURATION);
        Assert.assertThat((Object)cache, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Date", "LocalDateTime", "ZonedDateTime", "LocalTime", "ZonedTime", "Duration"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void stressCache() throws Exception {
        StringFactory factory = new StringFactory();
        TemporalIndexCache cache = new TemporalIndexCache((TemporalIndexCache.Factory)factory);
        ExecutorService pool = Executors.newFixedThreadPool(20);
        Future[] futures = new Future[100];
        AtomicBoolean shouldContinue = new AtomicBoolean(true);
        try {
            for (int i = 0; i < futures.length; ++i) {
                futures[i] = pool.submit(new CacheStresser((TemporalIndexCache<String>)cache, shouldContinue));
            }
            Thread.sleep(5000L);
            shouldContinue.set(false);
            for (Future future : futures) {
                future.get(10L, TimeUnit.SECONDS);
            }
        }
        finally {
            pool.shutdown();
        }
    }

    @Test
    public void stressInstantiationWithClose() throws Throwable {
        StringFactory factory = new StringFactory();
        TemporalIndexCache cache = new TemporalIndexCache((TemporalIndexCache.Factory)factory);
        Race race = new Race().withRandomStartDelays();
        MutableInt instantiatedAtClose = new MutableInt();
        race.addContestant(() -> {
            try {
                cache.uncheckedSelect(valueGroups[0]);
                cache.uncheckedSelect(valueGroups[1]);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }, 1);
        race.addContestant(() -> {
            cache.closeInstantiateCloseLock();
            instantiatedAtClose.setValue((Number)Iterables.count((Iterable)cache));
        }, 1);
        race.go();
        try {
            cache.uncheckedSelect(valueGroups[2]);
            Assert.fail((String)"No instantiation after closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((long)instantiatedAtClose.intValue(), (long)Iterables.count((Iterable)cache));
    }

    private static class StringFactory
    implements TemporalIndexCache.Factory<String> {
        AtomicInteger dateCounter = new AtomicInteger(0);
        AtomicInteger localDateTimeCounter = new AtomicInteger(0);
        AtomicInteger zonedDateTimeCounter = new AtomicInteger(0);
        AtomicInteger localTimeCounter = new AtomicInteger(0);
        AtomicInteger zonedTimeCounter = new AtomicInteger(0);
        AtomicInteger durationCounter = new AtomicInteger(0);

        private StringFactory() {
        }

        public String newDate() {
            this.updateCounterAndAssertSingleUpdate(this.dateCounter);
            return "Date";
        }

        public String newLocalDateTime() {
            this.updateCounterAndAssertSingleUpdate(this.localDateTimeCounter);
            return "LocalDateTime";
        }

        public String newZonedDateTime() {
            this.updateCounterAndAssertSingleUpdate(this.zonedDateTimeCounter);
            return "ZonedDateTime";
        }

        public String newLocalTime() {
            this.updateCounterAndAssertSingleUpdate(this.localTimeCounter);
            return "LocalTime";
        }

        public String newZonedTime() {
            this.updateCounterAndAssertSingleUpdate(this.zonedTimeCounter);
            return "ZonedTime";
        }

        public String newDuration() {
            this.updateCounterAndAssertSingleUpdate(this.durationCounter);
            return "Duration";
        }

        private void updateCounterAndAssertSingleUpdate(AtomicInteger counter) {
            int count = counter.incrementAndGet();
            if (count > 1) {
                throw new IllegalStateException("called new on same factory method multiple times");
            }
        }
    }

    static class CacheStresser
    extends Thread {
        private final TemporalIndexCache<String> cache;
        private final AtomicBoolean shouldContinue;
        private final Random r = new Random();

        CacheStresser(TemporalIndexCache<String> cache, AtomicBoolean shouldContinue) {
            this.cache = cache;
            this.shouldContinue = shouldContinue;
        }

        @Override
        public void run() {
            while (this.shouldContinue.get()) {
                this.stress();
            }
        }

        private void stress() {
            this.cache.select(valueGroups[this.r.nextInt(valueGroups.length)]);
            for (String s : this.cache) {
                if (s != null) continue;
                throw new IllegalStateException("iterated over null");
            }
        }
    }
}

