/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.index.schema.UnsafeDirectByteBufferFactory;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryAllocationTracker;

class UnsafeDirectByteBufferFactoryTest {
    UnsafeDirectByteBufferFactoryTest() {
    }

    @Test
    void shouldAllocateBuffer() {
        LocalMemoryTracker tracker = new LocalMemoryTracker();
        try (UnsafeDirectByteBufferFactory factory = new UnsafeDirectByteBufferFactory((MemoryAllocationTracker)tracker);){
            int bufferSize = 128;
            factory.newBuffer(bufferSize);
            Assertions.assertEquals((long)bufferSize, (long)tracker.usedDirectMemory());
        }
    }

    @Test
    void shouldFreeOnClose() {
        LocalMemoryTracker tracker = new LocalMemoryTracker();
        try (UnsafeDirectByteBufferFactory factory = new UnsafeDirectByteBufferFactory((MemoryAllocationTracker)tracker);){
            factory.newBuffer(256);
        }
        Assertions.assertEquals((long)0L, (long)tracker.usedDirectMemory());
    }

    @Test
    void shouldHandleMultipleClose() {
        LocalMemoryTracker tracker = new LocalMemoryTracker();
        UnsafeDirectByteBufferFactory factory = new UnsafeDirectByteBufferFactory((MemoryAllocationTracker)tracker);
        factory.newBuffer(256);
        factory.close();
        Assertions.assertEquals((long)0L, (long)tracker.usedDirectMemory());
        factory.close();
        Assertions.assertEquals((long)0L, (long)tracker.usedDirectMemory());
    }

    @Test
    void shouldNotAllocateAfterClosed() {
        UnsafeDirectByteBufferFactory factory = new UnsafeDirectByteBufferFactory((MemoryAllocationTracker)new LocalMemoryTracker());
        factory.close();
        try {
            factory.newBuffer(8);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

