/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.neo4j.io.pagecache.ByteArrayPageCursor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsReader;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsWriter;
import org.neo4j.values.storable.CoordinateReferenceSystem;

class SpaceFillingCurveSettingsReaderTest {
    SpaceFillingCurveSettingsReaderTest() {
    }

    @Test
    void shouldReadMultipleSettings() {
        ConfiguredSpaceFillingCurveSettingsCache globalSettings = new ConfiguredSpaceFillingCurveSettingsCache(Config.defaults());
        HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings> expectedSpecificSettings = new HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings>();
        this.rememberSettings(globalSettings, expectedSpecificSettings, CoordinateReferenceSystem.WGS84, CoordinateReferenceSystem.WGS84_3D, CoordinateReferenceSystem.Cartesian);
        IndexSpecificSpaceFillingCurveSettingsCache specificSettings = new IndexSpecificSpaceFillingCurveSettingsCache(globalSettings, expectedSpecificSettings);
        SpaceFillingCurveSettingsWriter writer = new SpaceFillingCurveSettingsWriter(specificSettings);
        byte[] bytes = new byte[8192];
        writer.accept((PageCursor)new ByteArrayPageCursor(bytes));
        HashMap readExpectedSettings = new HashMap();
        SpaceFillingCurveSettingsReader reader = new SpaceFillingCurveSettingsReader(readExpectedSettings);
        reader.read(ByteBuffer.wrap(bytes));
        Assert.assertEquals(expectedSpecificSettings, readExpectedSettings);
    }

    private void rememberSettings(ConfiguredSpaceFillingCurveSettingsCache globalSettings, Map<CoordinateReferenceSystem, SpaceFillingCurveSettings> expectedSpecificSettings, CoordinateReferenceSystem ... crss) {
        for (CoordinateReferenceSystem crs : crss) {
            expectedSpecificSettings.put(crs, globalSettings.forCRS(crs));
        }
    }
}

