/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

public class SpatialIndexValueTestUtil {
    public static Pair<PointValue, PointValue> pointsWithSameValueOnSpaceFillingCurve(Config config) {
        ConfiguredSpaceFillingCurveSettingsCache configuredCache = new ConfiguredSpaceFillingCurveSettingsCache(config);
        SpaceFillingCurveSettings spaceFillingCurveSettings = configuredCache.forCRS(CoordinateReferenceSystem.WGS84);
        SpaceFillingCurve curve = spaceFillingCurveSettings.curve();
        double[] origin = new double[]{0.0, 0.0};
        Long spaceFillingCurveMapForOrigin = curve.derivedValueFor(origin);
        double[] centerPointForOriginTile = curve.centerPointFor(spaceFillingCurveMapForOrigin.longValue());
        PointValue originValue = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])origin);
        PointValue centerPointValue = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])centerPointForOriginTile);
        Assert.assertThat((String)"need non equal points for this test", (Object)origin, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)centerPointValue)));
        return Pair.of((Object)originValue, (Object)centerPointValue);
    }
}

