/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.impl.index.schema.IndexDropAction;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexPopulator;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexTestHelp;
import org.neo4j.kernel.impl.index.schema.fusion.FusionVersion;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;

@RunWith(value=Parameterized.class)
public class FusionIndexPopulatorTest {
    private IndexPopulator[] alivePopulators;
    private EnumMap<IndexSlot, IndexPopulator> populators;
    private FusionIndexPopulator fusionIndexPopulator;
    private final long indexId = 8L;
    private final IndexDropAction dropAction = (IndexDropAction)Mockito.mock(IndexDropAction.class);
    @Parameterized.Parameter
    public static FusionVersion fusionVersion;

    @Parameterized.Parameters(name="{0}")
    public static FusionVersion[] versions() {
        return new FusionVersion[]{FusionVersion.v00, FusionVersion.v10, FusionVersion.v20};
    }

    @Before
    public void setup() {
        this.initiateMocks();
    }

    private void initiateMocks() {
        IndexSlot[] aliveSlots = fusionVersion.aliveSlots();
        this.populators = new EnumMap(IndexSlot.class);
        FusionIndexTestHelp.fill(this.populators, IndexPopulator.EMPTY);
        this.alivePopulators = new IndexPopulator[aliveSlots.length];
        block7: for (int i = 0; i < aliveSlots.length; ++i) {
            IndexPopulator mock;
            this.alivePopulators[i] = mock = (IndexPopulator)Mockito.mock(IndexPopulator.class);
            switch (aliveSlots[i]) {
                case STRING: {
                    this.populators.put(IndexSlot.STRING, mock);
                    continue block7;
                }
                case NUMBER: {
                    this.populators.put(IndexSlot.NUMBER, mock);
                    continue block7;
                }
                case SPATIAL: {
                    this.populators.put(IndexSlot.SPATIAL, mock);
                    continue block7;
                }
                case TEMPORAL: {
                    this.populators.put(IndexSlot.TEMPORAL, mock);
                    continue block7;
                }
                case LUCENE: {
                    this.populators.put(IndexSlot.LUCENE, mock);
                    continue block7;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        this.fusionIndexPopulator = new FusionIndexPopulator(fusionVersion.slotSelector(), new InstanceSelector(this.populators), 8L, this.dropAction, false);
    }

    private void resetMocks() {
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            Mockito.reset((Object[])new IndexPopulator[]{alivePopulator});
        }
    }

    @Test
    public void createMustCreateAll() throws Exception {
        this.fusionIndexPopulator.create();
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            ((IndexPopulator)Mockito.verify((Object)alivePopulator, (VerificationMode)Mockito.times((int)1))).create();
        }
    }

    @Test
    public void createRemoveAnyLeftOversThatWasThereInIndexDirectoryBeforePopulation() throws IOException {
        this.fusionIndexPopulator.create();
        ((IndexDropAction)Mockito.verify((Object)this.dropAction)).drop(8L, false);
    }

    @Test
    public void createMustThrowIfAnyThrow() throws Exception {
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            UncheckedIOException failure = new UncheckedIOException(new IOException("fail"));
            ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)alivePopulator)).create();
            FusionIndexTestHelp.verifyCallFail(failure, () -> {
                this.fusionIndexPopulator.create();
                return null;
            });
            ((IndexPopulator)Mockito.doAnswer(invocation -> null).when((Object)alivePopulator)).create();
        }
    }

    @Test
    public void dropMustDropAll() {
        this.fusionIndexPopulator.drop();
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            ((IndexPopulator)Mockito.verify((Object)alivePopulator, (VerificationMode)Mockito.times((int)1))).drop();
        }
        ((IndexDropAction)Mockito.verify((Object)this.dropAction)).drop(8L);
    }

    @Test
    public void dropMustThrowIfAnyDropThrow() {
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            UncheckedIOException failure = new UncheckedIOException(new IOException("fail"));
            ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)alivePopulator)).drop();
            FusionIndexTestHelp.verifyCallFail(failure, () -> {
                this.fusionIndexPopulator.drop();
                return null;
            });
            ((IndexPopulator)Mockito.doAnswer(invocation -> null).when((Object)alivePopulator)).drop();
        }
    }

    @Test
    public void addMustSelectCorrectPopulator() throws Exception {
        EnumMap<IndexSlot, Value[]> values = FusionIndexTestHelp.valuesByGroup();
        Value[] allValues = FusionIndexTestHelp.allValues();
        for (IndexSlot indexSlot : IndexSlot.values()) {
            for (Value value : values.get(indexSlot)) {
                this.verifyAddWithCorrectPopulator(this.orLucene(this.populators.get(indexSlot)), value);
            }
        }
        for (IndexSlot indexSlot : allValues) {
            for (Value secondValue : allValues) {
                this.verifyAddWithCorrectPopulator(this.populators.get(IndexSlot.LUCENE), new Value[]{indexSlot, secondValue});
            }
        }
    }

    private void verifyAddWithCorrectPopulator(IndexPopulator correctPopulator, Value ... numberValues) throws IndexEntryConflictException, IOException {
        List<IndexEntryUpdate<LabelSchemaDescriptor>> update = Collections.singletonList(FusionIndexTestHelp.add(numberValues));
        this.fusionIndexPopulator.add(update);
        ((IndexPopulator)Mockito.verify((Object)correctPopulator, (VerificationMode)Mockito.times((int)1))).add(update);
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            if (alivePopulator == correctPopulator) continue;
            ((IndexPopulator)Mockito.verify((Object)alivePopulator, (VerificationMode)Mockito.never())).add(update);
        }
    }

    @Test
    public void verifyDeferredConstraintsMustThrowIfAnyThrow() throws Exception {
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            IndexEntryConflictException failure = (IndexEntryConflictException)((Object)Mockito.mock(IndexEntryConflictException.class));
            ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)alivePopulator)).verifyDeferredConstraints((NodePropertyAccessor)ArgumentMatchers.any());
            FusionIndexTestHelp.verifyCallFail((Exception)((Object)failure), () -> {
                this.fusionIndexPopulator.verifyDeferredConstraints(null);
                return null;
            });
            ((IndexPopulator)Mockito.doAnswer(invocation -> null).when((Object)alivePopulator)).verifyDeferredConstraints((NodePropertyAccessor)ArgumentMatchers.any());
        }
    }

    @Test
    public void successfulCloseMustCloseAll() throws Exception {
        this.closeAndVerifyPropagation(true);
    }

    @Test
    public void unsuccessfulCloseMustCloseAll() throws Exception {
        this.closeAndVerifyPropagation(false);
    }

    private void closeAndVerifyPropagation(boolean populationCompletedSuccessfully) throws IOException {
        this.fusionIndexPopulator.close(populationCompletedSuccessfully);
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            ((IndexPopulator)Mockito.verify((Object)alivePopulator, (VerificationMode)Mockito.times((int)1))).close(populationCompletedSuccessfully);
        }
    }

    @Test
    public void closeMustThrowIfCloseAnyThrow() throws Exception {
        for (IndexSlot aliveSlot : fusionVersion.aliveSlots()) {
            UncheckedIOException failure = new UncheckedIOException(new IOException("fail"));
            ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)this.populators.get(aliveSlot))).close(ArgumentMatchers.anyBoolean());
            FusionIndexTestHelp.verifyCallFail(failure, () -> {
                this.fusionIndexPopulator.close(ArgumentMatchers.anyBoolean());
                return null;
            });
            this.initiateMocks();
        }
    }

    private void verifyOtherCloseOnThrow(IndexPopulator throwingPopulator) throws Exception {
        UncheckedIOException failure = new UncheckedIOException(new IOException("fail"));
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)throwingPopulator)).close(ArgumentMatchers.anyBoolean());
        try {
            this.fusionIndexPopulator.close(true);
            Assert.fail((String)"Should have failed");
        }
        catch (UncheckedIOException uncheckedIOException) {
            // empty catch block
        }
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            ((IndexPopulator)Mockito.verify((Object)alivePopulator, (VerificationMode)Mockito.times((int)1))).close(true);
        }
    }

    @Test
    public void closeMustCloseOthersIfAnyThrow() throws Exception {
        for (IndexSlot throwingSlot : fusionVersion.aliveSlots()) {
            this.verifyOtherCloseOnThrow(this.populators.get(throwingSlot));
            this.initiateMocks();
        }
    }

    @Test
    public void closeMustThrowIfAllThrow() throws Exception {
        block3: {
            ArrayList<UncheckedIOException> failures = new ArrayList<UncheckedIOException>();
            for (IndexPopulator alivePopulator : this.alivePopulators) {
                UncheckedIOException failure = new UncheckedIOException(new IOException("FAILURE[" + alivePopulator + "]"));
                failures.add(failure);
                ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)alivePopulator)).close(ArgumentMatchers.anyBoolean());
            }
            try {
                this.fusionIndexPopulator.close(ArgumentMatchers.anyBoolean());
                Assert.fail((String)"Should have failed");
            }
            catch (UncheckedIOException e) {
                if (failures.contains(e)) break block3;
                Assert.fail((String)("Thrown exception didn't match any of the expected failures: " + failures));
            }
        }
    }

    @Test
    public void markAsFailedMustMarkAll() throws Exception {
        String failureMessage = "failure";
        this.fusionIndexPopulator.markAsFailed(failureMessage);
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            ((IndexPopulator)Mockito.verify((Object)alivePopulator, (VerificationMode)Mockito.times((int)1))).markAsFailed(failureMessage);
        }
    }

    @Test
    public void markAsFailedMustThrowIfAnyThrow() throws Exception {
        for (IndexPopulator alivePopulator : this.alivePopulators) {
            UncheckedIOException failure = new UncheckedIOException(new IOException("fail"));
            ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)alivePopulator)).markAsFailed(ArgumentMatchers.anyString());
            FusionIndexTestHelp.verifyCallFail(failure, () -> {
                this.fusionIndexPopulator.markAsFailed(ArgumentMatchers.anyString());
                return null;
            });
            ((IndexPopulator)Mockito.doAnswer(invocation -> null).when((Object)alivePopulator)).markAsFailed(ArgumentMatchers.anyString());
        }
    }

    @Test
    public void shouldIncludeSampleOnCorrectPopulator() {
        EnumMap<IndexSlot, Value[]> values = FusionIndexTestHelp.valuesByGroup();
        for (IndexSlot activeSlot : fusionVersion.aliveSlots()) {
            this.verifySampleToCorrectPopulator(values.get(activeSlot), this.populators.get(activeSlot));
        }
    }

    private void verifySampleToCorrectPopulator(Value[] values, IndexPopulator populator) {
        for (Value value : values) {
            IndexEntryUpdate<LabelSchemaDescriptor> update = FusionIndexTestHelp.add(value);
            this.fusionIndexPopulator.includeSample(update);
            ((IndexPopulator)Mockito.verify((Object)populator)).includeSample(update);
            Mockito.reset((Object[])new IndexPopulator[]{populator});
        }
    }

    private IndexPopulator orLucene(IndexPopulator populator) {
        return populator != IndexPopulator.EMPTY ? populator : this.populators.get(IndexSlot.LUCENE);
    }
}

