/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.LabelSet;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.AutoIndexingKernelException;
import org.neo4j.internal.kernel.api.helpers.StubNodeCursor;
import org.neo4j.internal.kernel.api.helpers.TestRelationshipChain;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.explicitindex.AutoIndexOperations;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.RelExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.index.ExplicitIndexStore;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.IndexTxStateUpdater;
import org.neo4j.kernel.impl.newapi.KernelToken;
import org.neo4j.kernel.impl.newapi.Operations;
import org.neo4j.kernel.impl.newapi.TwoPhaseNodeForRelationshipLockingTest;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.lock.LockTracer;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.test.MockedNeoStores;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class OperationsLockTest {
    private KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
    private Operations operations;
    private final Locks.Client locks = (Locks.Client)Mockito.mock(Locks.Client.class);
    private final Write write = (Write)Mockito.mock(Write.class);
    private InOrder order;
    private DefaultNodeCursor nodeCursor;
    private DefaultPropertyCursor propertyCursor;
    private DefaultRelationshipScanCursor relationshipCursor;
    private TransactionState txState;
    private AllStoreHolder allStoreHolder;
    private final LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)123, (int[])new int[]{456});
    private StorageReader storageReader;
    private ConstraintIndexCreator constraintIndexCreator;

    @Before
    public void setUp() throws InvalidTransactionTypeKernelException {
        this.txState = (TransactionState)Mockito.spy((Object)new TxState());
        Mockito.when((Object)this.transaction.getReasonIfTerminated()).thenReturn(Optional.empty());
        Mockito.when((Object)this.transaction.statementLocks()).thenReturn((Object)new SimpleStatementLocks(this.locks));
        Mockito.when((Object)this.transaction.dataWrite()).thenReturn((Object)this.write);
        Mockito.when((Object)this.transaction.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.transaction.lockTracer()).thenReturn((Object)LockTracer.NONE);
        Mockito.when((Object)this.transaction.txState()).thenReturn((Object)this.txState);
        Mockito.when((Object)this.transaction.securityContext()).thenReturn((Object)SecurityContext.AUTH_DISABLED);
        DefaultCursors cursors = (DefaultCursors)Mockito.mock(DefaultCursors.class);
        this.nodeCursor = (DefaultNodeCursor)Mockito.mock(DefaultNodeCursor.class);
        this.propertyCursor = (DefaultPropertyCursor)Mockito.mock(DefaultPropertyCursor.class);
        this.relationshipCursor = (DefaultRelationshipScanCursor)Mockito.mock(DefaultRelationshipScanCursor.class);
        Mockito.when((Object)cursors.allocateNodeCursor()).thenReturn((Object)this.nodeCursor);
        Mockito.when((Object)cursors.allocatePropertyCursor()).thenReturn((Object)this.propertyCursor);
        Mockito.when((Object)cursors.allocateRelationshipScanCursor()).thenReturn((Object)this.relationshipCursor);
        AutoIndexing autoindexing = (AutoIndexing)Mockito.mock(AutoIndexing.class);
        AutoIndexOperations autoIndexOperations = (AutoIndexOperations)Mockito.mock(AutoIndexOperations.class);
        Mockito.when((Object)autoindexing.nodes()).thenReturn((Object)autoIndexOperations);
        Mockito.when((Object)autoindexing.relationships()).thenReturn((Object)autoIndexOperations);
        StorageEngine engine = (StorageEngine)Mockito.mock(StorageEngine.class);
        this.storageReader = (StorageReader)Mockito.mock(StorageReader.class);
        Mockito.when((Object)this.storageReader.nodeExists(ArgumentMatchers.anyLong())).thenReturn((Object)true);
        Mockito.when((Object)this.storageReader.constraintsGetForLabel(ArgumentMatchers.anyInt())).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.storageReader.constraintsGetAll()).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)engine.newReader()).thenReturn((Object)this.storageReader);
        this.allStoreHolder = new AllStoreHolder(this.storageReader, this.transaction, cursors, (ExplicitIndexStore)Mockito.mock(ExplicitIndexStore.class), (Procedures)Mockito.mock(Procedures.class), (SchemaState)Mockito.mock(SchemaState.class), new Dependencies());
        this.constraintIndexCreator = (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class);
        this.operations = new Operations(this.allStoreHolder, (IndexTxStateUpdater)Mockito.mock(IndexTxStateUpdater.class), this.storageReader, this.transaction, new KernelToken(this.storageReader, this.transaction, MockedNeoStores.mockedTokenHolders()), cursors, autoindexing, this.constraintIndexCreator, (ConstraintSemantics)Mockito.mock(ConstraintSemantics.class), (IndexingService)Mockito.mock(IndexingService.class), Config.defaults());
        this.operations.initialize();
        this.order = Mockito.inOrder((Object[])new Object[]{this.locks, this.txState, this.storageReader});
    }

    @After
    public void tearDown() {
        this.operations.release();
    }

    @Test
    public void shouldAcquireEntityWriteLockCreatingRelationship() throws Exception {
        long rId = this.operations.relationshipCreate(1L, 2, 3L);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{3L});
        ((TransactionState)this.order.verify((Object)this.txState)).relationshipDoCreate(rId, 2, 1L, 3L);
    }

    @Test
    public void shouldAcquireNodeLocksWhenCreatingRelationshipInOrderOfAscendingId() throws Exception {
        long lowId = 3L;
        long highId = 5L;
        int relationshipLabel = 0;
        this.operations.relationshipCreate(lowId, relationshipLabel, highId);
        InOrder lockingOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{lowId});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{highId});
        lockingOrder.verifyNoMoreInteractions();
        Mockito.reset((Object[])new Locks.Client[]{this.locks});
        this.operations.relationshipCreate(highId, relationshipLabel, lowId);
        lockingOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{lowId});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{highId});
        lockingOrder.verifyNoMoreInteractions();
    }

    @Test
    public void shouldAcquireNodeLocksWhenDeletingRelationshipInOrderOfAscendingId() throws Exception {
        long relationshipId = 10L;
        long lowId = 3L;
        long highId = 5L;
        int relationshipLabel = 0;
        this.setStoreRelationship(10L, 3L, 5L, relationshipLabel);
        this.operations.relationshipDelete(10L);
        InOrder lockingOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{3L});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{5L});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{10L});
        lockingOrder.verifyNoMoreInteractions();
        Mockito.reset((Object[])new Locks.Client[]{this.locks});
        this.setStoreRelationship(10L, 5L, 3L, relationshipLabel);
        this.operations.relationshipDelete(10L);
        lockingOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{3L});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{5L});
        ((Locks.Client)lockingOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{10L});
        lockingOrder.verifyNoMoreInteractions();
    }

    @Test
    public void shouldAcquireEntityWriteLockBeforeAddingLabelToNode() throws Exception {
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)LabelSet.NONE);
        this.operations.nodeAddLabel(123L, 456);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((TransactionState)this.order.verify((Object)this.txState)).nodeDoAddLabel(456L, 123L);
    }

    @Test
    public void shouldNotAcquireEntityWriteLockBeforeAddingLabelToJustCreatedNode() throws Exception {
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)LabelSet.NONE);
        Mockito.when((Object)this.transaction.hasTxStateWithChanges()).thenReturn((Object)true);
        this.txState.nodeDoCreate(123L);
        this.operations.nodeAddLabel(123L, 456);
        ((Locks.Client)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.never())).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeAddingLabelToNode() throws Exception {
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)LabelSet.NONE);
        int labelId = 456;
        this.operations.nodeAddLabel(123L, labelId);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId});
        ((TransactionState)this.order.verify((Object)this.txState)).nodeDoAddLabel((long)labelId, 123L);
    }

    @Test
    public void shouldAcquireEntityWriteLockBeforeSettingPropertyOnNode() throws Exception {
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)LabelSet.NONE);
        int propertyKeyId = 8;
        Value value = Values.of((Object)9);
        Mockito.when((Object)this.propertyCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.propertyCursor.propertyKey()).thenReturn((Object)propertyKeyId);
        Mockito.when((Object)this.propertyCursor.propertyValue()).thenReturn((Object)Values.NO_VALUE);
        this.operations.nodeSetProperty(123L, propertyKeyId, value);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((TransactionState)this.order.verify((Object)this.txState)).nodeDoAddProperty(123L, propertyKeyId, value);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeSettingPropertyOnNode() throws Exception {
        int relatedLabelId = 50;
        int unrelatedLabelId = 51;
        int propertyKeyId = 8;
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        LabelSet labelSet = (LabelSet)Mockito.mock(LabelSet.class);
        Mockito.when((Object)labelSet.all()).thenReturn((Object)new long[]{relatedLabelId});
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)labelSet);
        Value value = Values.of((Object)9);
        Mockito.when((Object)this.propertyCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.propertyCursor.propertyKey()).thenReturn((Object)propertyKeyId);
        Mockito.when((Object)this.propertyCursor.propertyValue()).thenReturn((Object)Values.NO_VALUE);
        this.operations.nodeSetProperty(123L, propertyKeyId, value);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{relatedLabelId});
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.never())).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{unrelatedLabelId});
        ((TransactionState)this.order.verify((Object)this.txState)).nodeDoAddProperty(123L, propertyKeyId, value);
    }

    @Test
    public void shouldAcquireEntityWriteLockBeforeSettingPropertyOnRelationship() throws Exception {
        Mockito.when((Object)this.relationshipCursor.next()).thenReturn((Object)true);
        int propertyKeyId = 8;
        Value value = Values.of((Object)9);
        Mockito.when((Object)this.propertyCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.propertyCursor.propertyKey()).thenReturn((Object)propertyKeyId);
        Mockito.when((Object)this.propertyCursor.propertyValue()).thenReturn((Object)Values.NO_VALUE);
        this.operations.relationshipSetProperty(123L, propertyKeyId, value);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{123L});
        ((TransactionState)this.order.verify((Object)this.txState)).relationshipDoReplaceProperty(123L, propertyKeyId, Values.NO_VALUE, value);
    }

    @Test
    public void shouldNotAcquireEntityWriteLockBeforeSettingPropertyOnJustCreatedNode() throws Exception {
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)LabelSet.NONE);
        Mockito.when((Object)this.transaction.hasTxStateWithChanges()).thenReturn((Object)true);
        this.txState.nodeDoCreate(123L);
        int propertyKeyId = 8;
        Value value = Values.of((Object)9);
        this.operations.nodeSetProperty(123L, propertyKeyId, value);
        ((Locks.Client)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.never())).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((TransactionState)Mockito.verify((Object)this.txState)).nodeDoAddProperty(123L, propertyKeyId, value);
    }

    @Test
    public void shouldNotAcquireEntityWriteLockBeforeSettingPropertyOnJustCreatedRelationship() throws Exception {
        Mockito.when((Object)this.relationshipCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.transaction.hasTxStateWithChanges()).thenReturn((Object)true);
        this.txState.relationshipDoCreate(123L, 42, 43L, 45L);
        int propertyKeyId = 8;
        Value value = Values.of((Object)9);
        this.operations.relationshipSetProperty(123L, propertyKeyId, value);
        ((Locks.Client)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.never())).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{123L});
        ((TransactionState)Mockito.verify((Object)this.txState)).relationshipDoReplaceProperty(123L, propertyKeyId, Values.NO_VALUE, value);
    }

    @Test
    public void shouldAcquireEntityWriteLockBeforeDeletingNode() throws AutoIndexingKernelException {
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)LabelSet.NONE);
        Mockito.when((Object)this.allStoreHolder.nodeExistsInStore(123L)).thenReturn((Object)true);
        this.operations.nodeDelete(123L);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((TransactionState)this.order.verify((Object)this.txState)).nodeDoDelete(123L);
    }

    @Test
    public void shouldNotAcquireEntityWriteLockBeforeDeletingJustCreatedNode() throws Exception {
        this.txState.nodeDoCreate(123L);
        Mockito.when((Object)this.transaction.hasTxStateWithChanges()).thenReturn((Object)true);
        this.operations.nodeDelete(123L);
        ((Locks.Client)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.never())).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((TransactionState)Mockito.verify((Object)this.txState)).nodeDoDelete(123L);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeGettingConstraintsByLabelAndProperty() {
        this.allStoreHolder.constraintsGetForSchema((SchemaDescriptor)this.descriptor);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{this.descriptor.getLabelId()});
        ((StorageReader)this.order.verify((Object)this.storageReader)).constraintsGetForSchema((SchemaDescriptor)this.descriptor);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeGettingConstraintsByLabel() {
        this.allStoreHolder.constraintsGetForLabel(42);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{42L});
        ((StorageReader)this.order.verify((Object)this.storageReader)).constraintsGetForLabel(42);
    }

    @Test
    public void shouldAcquireSchemaReadLockBeforeCheckingExistenceConstraints() {
        this.allStoreHolder.constraintExists((ConstraintDescriptor)ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.descriptor));
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{123L});
        ((StorageReader)this.order.verify((Object)this.storageReader)).constraintExists((ConstraintDescriptor)ArgumentMatchers.any());
    }

    @Test
    public void shouldAcquireSchemaReadLockLazilyBeforeGettingAllConstraints() {
        int labelId = 1;
        int relTypeId = 2;
        UniquenessConstraintDescriptor uniquenessConstraint = ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{2, 3, 3});
        RelExistenceConstraintDescriptor existenceConstraint = ConstraintDescriptorFactory.existsForRelType((int)relTypeId, (int[])new int[]{3, 4, 5});
        Mockito.when((Object)this.storageReader.constraintsGetAll()).thenReturn((Object)Iterators.iterator((Object[])new ConstraintDescriptor[]{uniquenessConstraint, existenceConstraint}));
        Iterator result = this.allStoreHolder.constraintsGetAll();
        Iterators.count((Iterator)result);
        MatcherAssert.assertThat((Object)Iterators.asList((Iterator)result), (Matcher)Matchers.empty());
        ((StorageReader)this.order.verify((Object)this.storageReader)).constraintsGetAll();
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId});
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP_TYPE, new long[]{relTypeId});
    }

    @Test
    public void shouldAcquireSchemaWriteLockBeforeRemovingIndexRule() throws Exception {
        CapableIndexDescriptor index = TestIndexDescriptorFactory.forLabel(0, 0).withId(0L).withoutCapabilities();
        Mockito.when((Object)this.storageReader.indexGetForSchema((SchemaDescriptor)ArgumentMatchers.any())).thenReturn((Object)index);
        this.operations.indexDrop((IndexReference)index);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{0L});
        ((TransactionState)this.order.verify((Object)this.txState)).indexDoDrop((IndexDescriptor)index);
    }

    @Test
    public void shouldAcquireSchemaWriteLockBeforeCreatingUniquenessConstraint() throws Exception {
        String defaultProvider = (String)Config.defaults().get(GraphDatabaseSettings.default_schema_provider);
        Mockito.when((Object)this.constraintIndexCreator.createUniquenessConstraintIndex(this.transaction, (SchemaDescriptor)this.descriptor, defaultProvider)).thenReturn((Object)42L);
        Mockito.when((Object)this.storageReader.constraintsGetForSchema((SchemaDescriptor)this.descriptor.schema())).thenReturn(Collections.emptyIterator());
        this.operations.uniquePropertyConstraintCreate((SchemaDescriptor)this.descriptor);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{this.descriptor.getLabelId()});
        ((TransactionState)this.order.verify((Object)this.txState)).constraintDoAdd((IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.descriptor), 42L);
    }

    @Test
    public void shouldAcquireSchemaWriteLockBeforeDroppingConstraint() throws Exception {
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.descriptor);
        Mockito.when((Object)this.storageReader.constraintExists((ConstraintDescriptor)constraint)).thenReturn((Object)true);
        this.operations.constraintDrop((ConstraintDescriptor)constraint);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{this.descriptor.getLabelId()});
        ((TransactionState)this.order.verify((Object)this.txState)).constraintDoDrop((ConstraintDescriptor)constraint);
    }

    @Test
    public void detachDeleteNodeWithoutRelationshipsExclusivelyLockNode() throws KernelException {
        long nodeId = 1L;
        TwoPhaseNodeForRelationshipLockingTest.returnRelationships((Transaction)this.transaction, false, new TestRelationshipChain(nodeId));
        Mockito.when((Object)this.transaction.ambientNodeCursor()).thenReturn((Object)new StubNodeCursor(false).withNode(nodeId));
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        LabelSet labels = (LabelSet)Mockito.mock(LabelSet.class);
        Mockito.when((Object)labels.all()).thenReturn((Object)PrimitiveLongCollections.EMPTY_LONG_ARRAY);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)labels);
        this.operations.nodeDetachDelete(nodeId);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{nodeId});
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.never())).releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{nodeId});
        ((TransactionState)this.order.verify((Object)this.txState)).nodeDoDelete(nodeId);
    }

    @Test
    public void detachDeleteNodeExclusivelyLockNodes() throws KernelException {
        long nodeId = 1L;
        TwoPhaseNodeForRelationshipLockingTest.returnRelationships((Transaction)this.transaction, false, new TestRelationshipChain(nodeId).outgoing(1L, 2L, 42));
        Mockito.when((Object)this.transaction.ambientNodeCursor()).thenReturn((Object)new StubNodeCursor(false).withNode(nodeId));
        LabelSet labels = (LabelSet)Mockito.mock(LabelSet.class);
        Mockito.when((Object)labels.all()).thenReturn((Object)PrimitiveLongCollections.EMPTY_LONG_ARRAY);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)labels);
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        this.operations.nodeDetachDelete(nodeId);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{nodeId, 2L});
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.never())).releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{nodeId});
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.never())).releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{2L});
        ((TransactionState)this.order.verify((Object)this.txState)).nodeDoDelete(nodeId);
    }

    @Test
    public void shouldAcquiredSharedLabelLocksWhenDeletingNode() throws AutoIndexingKernelException {
        long nodeId = 1L;
        long labelId1 = 1L;
        long labelId2 = 2L;
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        LabelSet labels = (LabelSet)Mockito.mock(LabelSet.class);
        Mockito.when((Object)labels.all()).thenReturn((Object)new long[]{labelId1, labelId2});
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)labels);
        this.operations.nodeDelete(nodeId);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{nodeId});
        ((Locks.Client)order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId1, labelId2});
        order.verifyNoMoreInteractions();
    }

    @Test
    public void shouldAcquiredSharedLabelLocksWhenDetachDeletingNode() throws KernelException {
        long nodeId = 1L;
        long labelId1 = 1L;
        long labelId2 = 2L;
        TwoPhaseNodeForRelationshipLockingTest.returnRelationships((Transaction)this.transaction, false, new TestRelationshipChain(nodeId));
        Mockito.when((Object)this.transaction.ambientNodeCursor()).thenReturn((Object)new StubNodeCursor(false).withNode(nodeId));
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        LabelSet labels = (LabelSet)Mockito.mock(LabelSet.class);
        Mockito.when((Object)labels.all()).thenReturn((Object)new long[]{labelId1, labelId2});
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)labels);
        this.operations.nodeDetachDelete(nodeId);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{nodeId});
        ((Locks.Client)order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId1, labelId2});
        order.verifyNoMoreInteractions();
    }

    @Test
    public void shouldAcquiredSharedLabelLocksWhenRemovingNodeLabel() throws EntityNotFoundException {
        long nodeId = 1L;
        int labelId = 1;
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.hasLabel(labelId)).thenReturn((Object)true);
        this.operations.nodeRemoveLabel(nodeId, labelId);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{nodeId});
        ((Locks.Client)order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId});
        order.verifyNoMoreInteractions();
    }

    @Test
    public void shouldAcquiredSharedLabelLocksWhenRemovingNodeProperty() throws AutoIndexingKernelException, EntityNotFoundException {
        long nodeId = 1L;
        long labelId1 = 1L;
        long labelId2 = 1L;
        int propertyKeyId = 5;
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        LabelSet labels = (LabelSet)Mockito.mock(LabelSet.class);
        Mockito.when((Object)labels.all()).thenReturn((Object)new long[]{labelId1, labelId2});
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)labels);
        Mockito.when((Object)this.propertyCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.propertyCursor.propertyKey()).thenReturn((Object)propertyKeyId);
        Mockito.when((Object)this.propertyCursor.propertyValue()).thenReturn((Object)Values.of((Object)"abc"));
        this.operations.nodeRemoveProperty(nodeId, propertyKeyId);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{nodeId});
        ((Locks.Client)order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId1, labelId2});
        order.verifyNoMoreInteractions();
    }

    private void setStoreRelationship(long relationshipId, long sourceNode, long targetNode, int relationshipLabel) {
        Mockito.when((Object)this.relationshipCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.relationshipCursor.relationshipReference()).thenReturn((Object)relationshipId);
        Mockito.when((Object)this.relationshipCursor.sourceNodeReference()).thenReturn((Object)sourceNode);
        Mockito.when((Object)this.relationshipCursor.targetNodeReference()).thenReturn((Object)targetNode);
        Mockito.when((Object)this.relationshipCursor.type()).thenReturn((Object)relationshipLabel);
    }
}

