/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class QueryEngineProviderTest {
    @Test
    public void shouldUsePickTheEngineWithLowestPriority() {
        QueryEngineProvider provider1 = (QueryEngineProvider)Mockito.mock(QueryEngineProvider.class);
        QueryEngineProvider provider2 = (QueryEngineProvider)Mockito.mock(QueryEngineProvider.class);
        Mockito.when((Object)provider1.enginePriority()).thenReturn((Object)1);
        Mockito.when((Object)provider2.enginePriority()).thenReturn((Object)2);
        Dependencies deps = new Dependencies();
        GraphDatabaseAPI graphAPI = (GraphDatabaseAPI)Mockito.mock(GraphDatabaseAPI.class);
        QueryExecutionEngine executionEngine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
        QueryExecutionEngine executionEngine2 = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
        Mockito.when((Object)provider1.createEngine((Dependencies)ArgumentMatchers.any(), (GraphDatabaseAPI)ArgumentMatchers.any())).thenReturn((Object)executionEngine);
        Mockito.when((Object)provider2.createEngine((Dependencies)ArgumentMatchers.any(), (GraphDatabaseAPI)ArgumentMatchers.any())).thenReturn((Object)executionEngine2);
        Iterable providers = Iterables.asIterable((Object[])new QueryEngineProvider[]{provider1, provider2});
        QueryExecutionEngine engine = QueryEngineProvider.initialize((Dependencies)deps, (GraphDatabaseAPI)graphAPI, (Iterable)providers);
        Assert.assertSame((Object)executionEngine, (Object)engine);
    }

    @Test
    public void shouldPickTheOneAndOnlyQueryEngineAvailable() {
        QueryEngineProvider provider = (QueryEngineProvider)Mockito.mock(QueryEngineProvider.class);
        Mockito.when((Object)provider.enginePriority()).thenReturn((Object)1);
        Dependencies deps = new Dependencies();
        GraphDatabaseAPI graphAPI = (GraphDatabaseAPI)Mockito.mock(GraphDatabaseAPI.class);
        QueryExecutionEngine executionEngine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
        Mockito.when((Object)provider.createEngine((Dependencies)ArgumentMatchers.any(), (GraphDatabaseAPI)ArgumentMatchers.any())).thenReturn((Object)executionEngine);
        Iterable providers = Iterables.asIterable((Object[])new QueryEngineProvider[]{provider});
        QueryExecutionEngine engine = QueryEngineProvider.initialize((Dependencies)deps, (GraphDatabaseAPI)graphAPI, (Iterable)providers);
        Assert.assertSame((Object)executionEngine, (Object)engine);
    }
}

